/*
 * Photo Image Print System
 * Copyright (C) SEIKO EPSON CORPORATION 2003-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifndef __PAPER_RSC__
#define __PAPER_RSC__

#include <string.h>
#include "paper.h"
#define LIST_END { NULL, -1, -1, -1, -1, -1, -1 }

/* ASF */
PAPER_CONF paper_auto[] = {
/* A4 210 x 297 mm */                	 { "A4",      2976,   4209,   2892,   3969,   42,     42 },
/* A5 148 x 210 mm */                	 { "A5",      2098,   2976,   2014,   2736,   42,     42 },
/* A6 105 x 148 mm */                	 { "A6",      1488,   2098,   1404,   1858,   42,     42 },
/* A3 297 x 420 mm */                	 { "A3",      4209,   5953,   4125,   5713,   42,     42 },
/* A3 Ɏˎ 329 x 483 mm */            	 { "A3+",     4663,   6846,   4579,   6606,   42,     42 },
/* B5 182 x 257 mm */                	 { "B5",      2580,   3643,   2496,   3403,   42,     42 },
/* B4 257 x 364 mm */                	 { "B4",      3643,   5159,   3559,   4919,   42,     42 },
/* ϥ 100 x 148 mm */            	 { "PC",      1417,   2098,   1333,   1858,   42,     42 },
/* ϥ 200 x 148 mm */        	 { "DPC",     2835,   2098,   2751,   1858,   42,     42 },
/* եȥ 102 x 152 mm */      	 { "PHOTO",   1610,   2330,   1526,   2246,   42,     42 },
/* LȽ 89 x 127 mm */                	 { "L",       1260,   1800,   1176,   1560,   42,     42 },
/* 2LȽ 127 x 178 mm */              	 { "2L",      1800,   2522,   1716,   2282,   42,     42 },
/* Ĺ3 120 x 235 mm */       	 { "ENVC3",   1701,   3685,   1617,   3091,   42,    396 },
/* Ĺ4 90 x 205 mm */        	 { "ENVC4",   1276,   3161,   1192,   2666,   42,    297 },
/* η1 120 x 176 mm */       	 { "ENVY1",   1701,   2494,   1617,   2254,   42,     42 },
/* η2 114 x 162 mm */       	 { "ENVY2",   1616,   2296,   1532,   2056,   42,     42 },
/* η3 98 x 148 mm */        	 { "ENVY3",   1389,   2098,   1305,   1858,   42,     42 },
/* η4 105 x 235 mm */       	 { "ENVY4",   1488,   3331,   1404,   3091,   42,     42 },
/* Letter 8 1/2 x 11 in */           	 { "LT",      3060,   3960,   2976,   3720,   42,     42 },
/* Legal 8 1/2 x 14 in */            	 { "LGL",     3060,   5040,   2976,   4800,   42,     42 },
/* Executive 7 1/4 x 10 1/2 in */    	 { "EXE",     2610,   3780,   2526,   3540,   42,     42 },
/* Half Letter 5 1/2 x 8 1/2 in */   	 { "HLT",     1980,   3060,   1896,   2820,   42,     42 },
/* Index card 5 x 8 in */            	 { "INDEX5",  1800,   2880,   1716,   2640,   42,     42 },
/* Index card 8 x 10 in */           	 { "INDEX8",  2880,   3600,   2796,   3360,   42,     42 },
/* Envelope #10 4 1/8 x 9 1/2 in */  	 { "ENV10",   3420,   1485,   2976,   1245,   42,     42 },
/* Envelope DL 110 x 220 mm */       	 { "ENVDL",   3118,   1559,   2976,   1319,   42,     42 },
/* Envelope C6 114 x 162 mm */       	 { "ENVC6",   2296,   1616,   2212,   1376,   42,     42 },
/* Envelope 132 x 220 mm */          	 { "ENV5X8",  3118,   1871,   2976,   1631,   42,     42 },
/* 4x6  100 x 152 mm */                { "4X6",     1417,   2160,   1333,   1920,   42,     42 },
/* Photo Paper 4 x 6 in No Perforation*/ { "4X6FULL", 1440,   2160,   1356,   1920,   42,     42 },
/* Photo Paper 100 x 150 mm */       	 { "PP100",   1417,   2125,   1333,   1885,   42,     42 },
/* Photo Paper 200 x 300 mm */       	 { "PP200",   3061,   4790,   2976,   4394,   42,    198 },
/* Panoramic 210 x 594 mm */         	 { "PANORAM", 2976,   8419,   2892,   8179,   42,     42 },
                                     	 LIST_END
};

/* Roll */                                                      
PAPER_CONF paper_roll[] = {
/* A4 210 x 297 mm */                    { "A4",      2976,   4209,   2892,   4209,   42,       0 },
/* A5 148 x 210 mm */                    { "A5",      2098,   2976,   2014,   2976,   42,       0 },
/* A6 105 x 148 mm */                    { "A6",      1488,   2098,   1404,   2098,   42,       0 },
/* A3 297 x 420 mm */                    { "A3",      4209,   5953,   4125,   5953,   42,       0 },
/* A3 Ɏˎ 329 x 483 mm */                { "A3+",     4663,   6846,   4579,   6846,   42,       0 },
/* B5 182 x 257 mm */                    { "B5",      2580,   3643,   2496,   3643,   42,       0 },
/* B4 257 x 364 mm */                    { "B4",      3643,   5159,   3559,   5159,   42,       0 },
/* ϥ 100 x 148 mm */                { "PC",      1417,   2098,   1333,   2098,   42,       0 },
/* ϥ 200 x 148 mm */            { "DPC",     2835,   2098,   2751,   2098,   42,       0 },
/* Letter 8 1/2 x 11 in */               { "LT",      3060,   3960,   2976,   3960,   42,       0 },
/* Legal 8 1/2 x 14 in */                { "LGL",     3060,   5040,   2976,   5040,   42,       0 },
/* 4x6  100 x 152 mm */                { "4X6",     1417,   2160,   1333,   2160,   42,       0 },
/* Photo Paper 4 x 6 in No Perforation*/ { "4X6FULL", 1440,   2160,   1356,   2160,   42,       0 },
/* L 89 x 127 mm */                    { "L",       1261,   1800,   1177,   1800,   42,       0 },
/* L() 127 x 89 mm */                { "LL",      1800,   1261,   1716,   1261,   42,       0 },
/* 2LȽ 127 x 178 mm */                  { "2L",      1800,   2522,   1716,   2522,   42,       0 },
/* ̾ 89 x 55 mm */                    { "NC",      1261,    779,   1177,    779,   42,       0 },
/* Panoramic 210 x 594 mm */         	 { "PANORAM", 2976,   8419,   2892,   8419,   42,       0 },
/* Index card 5 x 8 in */            	 { "INDEX5",  1800,   2880,   1716,   2880,   42,       0 },
/* Index card 8 x 10 in */           	 { "INDEX8",  2880,   3600,   2796,   3600,   42,       0 },
/* Photo Paper 100 x 150 mm */       	 { "PP100",   1417,   2125,   1333,   2125,   42,       0 },
                                         LIST_END
};

/* Roll (trim) */                                               
PAPER_CONF paper_roll_trim[] = {
/* A4 210 x 297 mm */                    { "A4",      2976,   4209,   3047,   4209,   0,        0 },
/* A3 297 x 420 mm */                    { "A3",      4209,   5953,   4280,   5953,   0,        0 },
/* A3 Ɏˎ 329 x 483 mm */                { "A3+",     4663,   6846,   4734,   6846,   0,        0 },
/* ϥ 100 x 148 mm */                { "PC",      1417,   2098,   1488,   2098,   0,        0 },
/* 4x6  100 x 152 mm */                { "4X6",     1417,   2160,   1488,   2160,   0,        0 },
/* Photo Paper 4 x 6 in No Perforation*/ { "4X6FULL", 1440,   2160,   1511,   2160,   0,        0 },
/* L 89 x 127 mm */                    { "L",       1261,   1800,   1332,   1800,   0,        0 },
/* L() 127 x 89 mm */                { "LL",      1800,   1261,   1871,   1261,   0,        0 },
/* 2LȽ 127 x 178 mm */                  { "2L",      1800,   2522,   1871,   2522,   0,        0 },
/* ̾ 89 x 55 mm */                    { "NC",      1261,    779,   1332,    779,   0,        0 },
/* Panoramic 210 x 594 mm */         	 { "PANORAM", 2976,   8419,   3047,   8419,   0,        0 },
/* B5 182 x 257 mm */                    { "B5",      2580,   3643,   2651,   3643,   0,        0 },
/* A5 148 x 210 mm */                    { "A5",      2098,   2976,   2169,   2976,   0,        0 },
/* A6 105 x 148 mm */                    { "A6",      1488,   2098,   1559,   2098,   0,        0 },
/* Index card 5 x 8 in */            	 { "INDEX5",  1800,   2880,   1871,   2880,   0,        0 },
/* Index card 8 x 10 in */           	 { "INDEX8",  2880,   3600,   2951,   3600,   0,        0 },
/* Photo Paper 100 x 150 mm */       	 { "PP100",   1417,   2125,   1488,   2125,   0,        0 },
                                         LIST_END
};

/* ASF (trim) */                                                
PAPER_CONF paper_auto_trim[] = {
/* A4 210 x 297 mm */                { "A4",    2976,   4209,   3047,   3969,   0,       42 },
/* ϥ 100 x 148 mm */            { "PC",    1417,   2098,   1488,   1858,   0,       42 },
                                     LIST_END
};

/*  ASF (No Margin) */
PAPER_CONF paper_auto_trim_4[] = {
/*  A4 210 x 297 mm */               	 { "A4",      2976,   4209,   3047,   4322,    0,      0 },
/* A3 297 x 420 mm */                	 { "A3",      4209,   5953,   4280,   6066,    0,      0 },
/* A3 Ɏˎ 329 x 483 mm */            	 { "A3+",     4663,   6846,   4734,   6846,    0,      0 },
/*  ϥ 100 x 148 mm */           	 { "PC",      1417,   2098,   1488,   2211,    0,      0 },
/* Letter 8 1/2 x 11 in */           	 { "LT",      3060,   3960,   3131,   4073,    0,      0 },
/*  LȽ 89 x 127 mm */               	 { "L",       1260,   1800,   1331,   1913,    0,      0 },
/*  2LȽ 127 x 178 mm */             	 { "2L",      1800,   2520,   1871,   2633,    0,      0 },
/* Index card 5 x 8 in */            	 { "INDEX5",  1800,   2880,   1871,   2993,    0,      0 },
/* Index card 8 x 10 in */           	 { "INDEX8",  2880,   3600,   2951,   3713,    0,      0 },
/* Panoramic 210 x 594 mm */         	 { "PANORAM", 2976,   8419,   3047,   8532,    0,      0 },
/* Photo Paper 100 x 150 mm */       	 { "PP100",   1417,   2125,   1488,   2238,    0,      0 },
/* Photo Paper 4 x 6 in No Perforation*/ { "4X6FULL", 1440,   2160,   1511,   2273,    0,      0 },
                                         LIST_END
};

#endif /* __PAPER_RSC__ */
