/*
 * Photo Image Print System
 * Copyright (C) 2001-2002 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2001-2002.
 *
 * This file is part of the `dtrfilter' program.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission
 * to link the code of this program with the `dtr' library and
 * distribute linked combinations including the two.  You must obey
 * the GNU General Public License in all respects for all of the
 * code used other then `dtr'.
 */
#include <dlfcn.h>
#include "pfpng.h"

void *dl_handle_libpng = 0;

lib_png_access_version_number  *dl_png_access_version_number;
lib_png_create_info_struct     *dl_png_create_info_struct;
lib_png_create_read_struct     *dl_png_create_read_struct;
lib_png_destroy_read_struct    *dl_png_destroy_read_struct;
lib_png_get_IHDR               *dl_png_get_IHDR;
lib_png_get_valid              *dl_png_get_valid;
lib_png_init_io                *dl_png_init_io;
lib_png_read_end               *dl_png_read_end;
lib_png_read_info              *dl_png_read_info;
lib_png_read_rows              *dl_png_read_rows;
lib_png_read_update_info       *dl_png_read_update_info;
lib_png_set_expand             *dl_png_set_expand;
lib_png_set_gray_to_rgb        *dl_png_set_gray_to_rgb;
lib_png_set_interlace_handling *dl_png_set_interlace_handling;
lib_png_set_packing            *dl_png_set_packing;
lib_png_set_rgb_to_gray        *dl_png_set_rgb_to_gray;
lib_png_set_sig_bytes          *dl_png_set_sig_bytes;
lib_png_set_strip_16           *dl_png_set_strip_16;
lib_png_set_strip_alpha        *dl_png_set_strip_alpha;
lib_png_sig_cmp                *dl_png_sig_cmp;

void *
open_png_library (void)
{
	dl_handle_libpng = dlopen ("libpng.so", RTLD_LAZY);
	if (dl_handle_libpng)
	{
		dl_png_access_version_number  = (lib_png_access_version_number *)  dlsym (dl_handle_libpng, "png_access_version_number");
		dl_png_create_info_struct     = (lib_png_create_info_struct *)     dlsym (dl_handle_libpng, "png_create_info_struct");
		dl_png_create_read_struct     = (lib_png_create_read_struct *)     dlsym (dl_handle_libpng, "png_create_read_struct");
		dl_png_destroy_read_struct    = (lib_png_destroy_read_struct *)    dlsym (dl_handle_libpng, "png_destroy_read_struct");
		dl_png_get_IHDR               = (lib_png_get_IHDR *)               dlsym (dl_handle_libpng, "png_get_IHDR");
		dl_png_get_valid              = (lib_png_get_valid *)              dlsym (dl_handle_libpng, "png_get_valid");
		dl_png_init_io                = (lib_png_init_io *)                dlsym (dl_handle_libpng, "png_init_io");
                dl_png_read_end               = (lib_png_read_end *)               dlsym (dl_handle_libpng, "png_read_end");
		dl_png_read_info              = (lib_png_read_info *)              dlsym (dl_handle_libpng, "png_read_info");
		dl_png_read_rows              = (lib_png_read_rows *)              dlsym (dl_handle_libpng, "png_read_rows");
		dl_png_read_update_info       = (lib_png_read_update_info *)       dlsym (dl_handle_libpng, "png_read_update_info");
		dl_png_set_expand             = (lib_png_set_expand *)             dlsym (dl_handle_libpng, "png_set_expand");
		dl_png_set_gray_to_rgb        = (lib_png_set_gray_to_rgb *)        dlsym (dl_handle_libpng, "png_set_gray_to_rgb");
		dl_png_set_interlace_handling = (lib_png_set_interlace_handling *) dlsym (dl_handle_libpng, "png_set_interlace_handling");
		dl_png_set_packing            = (lib_png_set_packing *)            dlsym (dl_handle_libpng, "png_set_packing");
		dl_png_set_rgb_to_gray        = (lib_png_set_rgb_to_gray *)        dlsym (dl_handle_libpng, "png_set_rgb_to_gray");
		dl_png_set_sig_bytes          = (lib_png_set_sig_bytes *)          dlsym (dl_handle_libpng, "png_set_sig_bytes");
		dl_png_set_strip_16           = (lib_png_set_strip_16 *)           dlsym (dl_handle_libpng, "png_set_strip_16");
		dl_png_set_strip_alpha        = (lib_png_set_strip_alpha *)        dlsym (dl_handle_libpng, "png_set_strip_alpha");
		dl_png_sig_cmp                = (lib_png_sig_cmp *)                dlsym (dl_handle_libpng, "png_sig_cmp");
	}

	if (! dl_png_access_version_number ||
	    ! dl_png_create_info_struct ||
	    ! dl_png_create_read_struct ||
	    ! dl_png_destroy_read_struct ||
	    ! dl_png_get_IHDR ||
	    ! dl_png_get_valid ||
	    ! dl_png_init_io ||
	    ! dl_png_read_end ||
	    ! dl_png_read_info ||
	    ! dl_png_read_rows ||
	    ! dl_png_read_update_info ||
	    ! dl_png_set_expand ||
	    ! dl_png_set_gray_to_rgb ||
	    ! dl_png_set_interlace_handling ||
	    ! dl_png_set_packing ||
	    ! dl_png_set_rgb_to_gray ||
	    ! dl_png_set_sig_bytes ||
	    ! dl_png_set_strip_16 ||
	    ! dl_png_set_strip_alpha ||
	    ! dl_png_sig_cmp)
	{
		dlclose (dl_handle_libpng);
		dl_handle_libpng = 0;
	}

	return (void *)dl_handle_libpng;
}

void
close_png_library (void)
{
	if (dl_handle_libpng)
		dlclose (dl_handle_libpng);

	return;
}
