/*
 * Photo Image Print System
 * Copyright (C) 2001-2002 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2001-2002.
 *
 * This file is part of the `ekpnavi' program.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "navi.h"

void
on_cancel_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  end_navi ();
  return;
}


void
on_prev_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  int page;

  page = get_navi_page ();
  set_navi_page (page - 1);
  return;
}


void
on_ink_black_button_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  init_cartridge (INK_BLACK);
  set_navi_page (1);
  return;
}


void
on_ink_color_button_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  init_cartridge (INK_COLOR);
  set_navi_page (1);
  return;
}


void
on_retry_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  int page;

  page = get_navi_page ();
  set_navi_page (page + 2);
  return;
}


void
on_next_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  int page;

  page = get_navi_page ();
  set_navi_page (page + 1);
  return;
}


void
on_ok_button_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  on_next_button_clicked (button, user_data);
  return;
}

void
on_msg_ok_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_main_quit();
	return;
}

