/*
 * Photo Image Print System
 * Copyright (C) 2001-2002 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2001-2002.
 *
 * This file is part of the `ekpnavi' program.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>

#include "interface.h"
#include "support.h"
#include "navi.h"

int
main (int argc, char *argv[])
{
  GtkWidget *ekpnavi_dialog;
  int c;
  int index = 0;

  struct option allopt[] =
  {
    { "alignment", 0, 0, 'a' },
    { "ink",       0, 0, 'i' },
    { "cut",       0, 0, 'C' },
    { "printer",   1, 0, 'P' },
    { "ruled",     1, 0, 'r' },
    { "patch",     1, 0, 'p' },
    { "band",      1, 0, 'b' },
    { "double",    0, 0, 'd' },
    { "rpath",     1, 0, 'e' },
    { "ppath",     1, 0, 'c' },
    { "bpath",     1, 0, 'n' },
    { "cpath",     1, 0, 't' },
    { "extension", 1, 0, 'x' },
    { "platen",    0, 0, 's' },
    { 0,0,0,0 }			/* end of options */
  };
  char *usage = "usage : Please activate ekpnavi from pips.\n";

  char printer[128];
  char ruled_path[128];
  char patch_path[128];
  char band_path[128];
  char cut_path[128];
  char model[128];
  int type_flag = 0;
  int ink = 0;
  int ruled = 0;
  int patch = 0;
  int band = 0;
  int platen = 0;

#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
/*   bindtextdomain (PACKAGE, "/usr/share/locale"); */
  textdomain (PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");

  printer[0] = ruled_path[0] = patch_path[0] = band_path[0] =  '\0';
  while ((c = getopt_long (argc, argv, "aCiP:r:p:b:de:c:n:t:x:s", allopt, &index)) != -1)
    {
      switch (c)
	{
	case 'a':
	  type_flag = DOT_ALIGNMENT;
	  break;
	
	case 'd':
	  ink ++;
	  break;

	case 'C':
	  type_flag = AUTOCUT_ABJUSTMENT;
	  break;
	  
	case 'i':
	  type_flag = INK_CHENGE;
	  break;

	case 'P':
	  if (strlen (optarg) < 128)
	    memcpy (printer, optarg, strlen(optarg) + 1);
	  break;

	case 'r':
	  ruled = atoi (optarg);
	  break;

	case 'p':
	  patch = atoi (optarg);
	  break;

	case 'b':
	  band = atoi (optarg);
	  break;
	  
	case 'e':
	  if (strlen (optarg) < 128)
	    memcpy (ruled_path, optarg, strlen(optarg) + 1);
	  break;

	case 'c':
	  if (strlen (optarg) < 128)
	    memcpy (patch_path, optarg, strlen(optarg) + 1);
	  break;

	case 'n':
	  if (strlen (optarg) < 128)
	    memcpy (band_path, optarg, strlen(optarg) + 1);
	  break;

	case 't':
	  if (strlen (optarg) < 128)
	    memcpy (cut_path, optarg, strlen(optarg) + 1);
	  break;

	case 'x':
	  if (strlen (optarg) < 128)
	    memcpy (model, optarg, strlen(optarg) + 1);
	  break;

	case 's':
		platen ++;
	  break;

	case '?':
	default:
	  fputs (usage, stderr);
	  return 1;
	}
    }
  
  if (type_flag == 0)
    {
      fputs (usage, stderr);
      return 1;
    }

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  ekpnavi_dialog = create_ekpnavi_dialog ();
  gtk_widget_show (ekpnavi_dialog);

  init_navi (ekpnavi_dialog, type_flag);

  if (type_flag == DOT_ALIGNMENT)
	  init_alignment (printer, ruled, patch, band, ruled_path, patch_path, band_path, model);

  else if (type_flag == AUTOCUT_ABJUSTMENT)
	  init_align_autocut (printer, cut_path, model);

  if (ink)
	  init_cartridge (INK_ALL);

  if (platen)
	  set_platen (); 	/* add 2002-10-30 */
  
  gtk_signal_connect(GTK_OBJECT(ekpnavi_dialog), "destroy", GTK_SIGNAL_FUNC(destroy_navi), NULL);

  set_navi_page (get_navi_page ());
  gtk_main ();
  return 0;
}

