/*
 * Photo Image Print System
 * Copyright (C) 2001-2002 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2001-2002.
 *
 * This file is part of the `ekpstm' program.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "inkbox.h"

GtkWidget*
create_stm_window (void)
{
  GtkWidget *stm_window;
  GtkWidget *vbox1;
  GtkWidget *hbox1;
  GtkWidget *prt_pix;
  GtkWidget *vbox2;
  GtkWidget *st_label;
  GtkWidget *scrolledwindow1;
  GtkWidget *st_txt;
  GtkWidget *hbox2;
#if (USE_INKBOX)
  /* 2004.03.08 renew 				*/
  /* 2004.03.08 added tooltips for ink color	*/
  GtkWidget *pixmap;
  GtkTooltips *tooltips;  
  GtkWidget *event_box;
  int	iink;			/* counter	*/
  char 	name_buf[64];		/* name buffer	*/ 
#else
  GtkWidget *vbox3;
  GtkWidget *label2;
  GtkWidget *black_prog;
  GtkWidget *vbox4;
  GtkWidget *label3;
  GtkWidget *color_prog;
#endif /* USE_INKBOX */
  GtkWidget *stm_hbuttonbox;
  GtkWidget *eject_button;
  GtkWidget *continue_button;
  GtkWidget *reset_button;
  GtkWidget *ink_button;
  GtkWidget *cancel_button;
  GtkWidget *close_button;

  stm_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (stm_window), "stm_window", stm_window);
  gtk_window_set_title (GTK_WINDOW (stm_window), _("Status Monitor"));

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (stm_window), vbox1);

  hbox1 = gtk_hbox_new (FALSE, 20);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);

  prt_pix = create_pixmap (stm_window, "warning.xpm");
  gtk_widget_ref (prt_pix);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "prt_pix", prt_pix,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (prt_pix);
  gtk_box_pack_start (GTK_BOX (hbox1), prt_pix, FALSE, FALSE, 0);
  gtk_misc_set_padding (GTK_MISC (prt_pix), 19, 20);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox2);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "vbox2", vbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox2);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox2, TRUE, TRUE, 0);

  st_label = gtk_label_new (_("Ready"));
  gtk_widget_ref (st_label);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "st_label", st_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (st_label);
  gtk_box_pack_start (GTK_BOX (vbox2), st_label, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (st_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (st_label), 7.45058e-09, 0.5);
  gtk_label_set_line_wrap (GTK_LABEL (st_label), TRUE);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow1);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "scrolledwindow1", scrolledwindow1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox2), scrolledwindow1, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  st_txt = gtk_text_new (NULL, NULL);
  gtk_widget_ref (st_txt);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "st_txt", st_txt,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (st_txt);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), st_txt);
  gtk_widget_set_usize (st_txt, 240, -2);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "hbox2", hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox2, TRUE, TRUE, 10);

#if (USE_INKBOX)
  for ( iink = 1; iink <= INK_NUMBER ; iink++ ){
 	/* 2004.03.08 create event box for pixmap */
	event_box = gtk_event_box_new(); 
	tooltips  = gtk_tooltips_new();
	gtk_tooltips_set_tip(tooltips, event_box, "not_defined", NULL );
	gtk_widget_ref (event_box);
	sprintf( name_buf, "eventbox%d", iink );
	gtk_object_set_data_full (GTK_OBJECT (stm_window), name_buf, event_box,
                            (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (event_box);
	/*****************************************/
  
	pixmap = create_pixmap (stm_window, NULL);
	gtk_widget_ref (pixmap);
	sprintf( name_buf, "pixmap%d", iink );
	gtk_object_set_data_full (GTK_OBJECT (stm_window), name_buf, pixmap,
                            (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pixmap);
	
	gtk_container_add (GTK_CONTAINER (event_box), pixmap );
	gtk_box_pack_start (GTK_BOX (hbox2), event_box, TRUE, FALSE, 0);
	
  }
#else

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox3);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "vbox3", vbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox3);
  gtk_box_pack_start (GTK_BOX (hbox2), vbox3, TRUE, TRUE, 5);

  label2 = gtk_label_new (_("Black"));
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (vbox3), label2, FALSE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label2), 0, 0.5);

  black_prog = gtk_progress_bar_new ();
  gtk_widget_ref (black_prog);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "black_prog", black_prog,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (black_prog);
  gtk_box_pack_start (GTK_BOX (vbox3), black_prog, FALSE, FALSE, 0);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox4);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "vbox4", vbox4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox4);
  gtk_box_pack_start (GTK_BOX (hbox2), vbox4, TRUE, TRUE, 5);

  label3 = gtk_label_new (_("Color"));
  gtk_widget_ref (label3);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "label3", label3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label3);
  gtk_box_pack_start (GTK_BOX (vbox4), label3, FALSE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);
  gtk_label_set_line_wrap (GTK_LABEL (label3), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label3), 0, 0.5);

  color_prog = gtk_progress_bar_new ();
  gtk_widget_ref (color_prog);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "color_prog", color_prog,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (color_prog);
  gtk_box_pack_start (GTK_BOX (vbox4), color_prog, FALSE, FALSE, 0);

#endif /* USE_INKBOX */

  stm_hbuttonbox = gtk_hbutton_box_new ();
  gtk_widget_ref (stm_hbuttonbox);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "stm_hbuttonbox", stm_hbuttonbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (stm_hbuttonbox);
  gtk_box_pack_start (GTK_BOX (vbox1), stm_hbuttonbox, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (stm_hbuttonbox), GTK_BUTTONBOX_END);

  eject_button = gtk_button_new_with_label (_("Eject"));
  gtk_widget_ref (eject_button);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "eject_button", eject_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (stm_hbuttonbox), eject_button);
  GTK_WIDGET_SET_FLAGS (eject_button, GTK_CAN_DEFAULT);

  continue_button = gtk_button_new_with_label (_("Continue"));
  gtk_widget_ref (continue_button);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "continue_button", continue_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (stm_hbuttonbox), continue_button);
  GTK_WIDGET_SET_FLAGS (continue_button, GTK_CAN_DEFAULT);

  reset_button = gtk_button_new_with_label (_("Reset"));
  gtk_widget_ref (reset_button);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "reset_button", reset_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (stm_hbuttonbox), reset_button);
  GTK_WIDGET_SET_FLAGS (reset_button, GTK_CAN_DEFAULT);

  ink_button = gtk_button_new_with_label (_("Ink"));
  gtk_widget_ref (ink_button);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "ink_button", ink_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (stm_hbuttonbox), ink_button);
  GTK_WIDGET_SET_FLAGS (ink_button, GTK_CAN_DEFAULT);

  cancel_button = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_ref (cancel_button);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "cancel_button", cancel_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (stm_hbuttonbox), cancel_button);
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);

  close_button = gtk_button_new_with_label (_("Close"));
  gtk_widget_ref (close_button);
  gtk_object_set_data_full (GTK_OBJECT (stm_window), "close_button", close_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (close_button);
  gtk_container_add (GTK_CONTAINER (stm_hbuttonbox), close_button);
  GTK_WIDGET_SET_FLAGS (close_button, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (eject_button), "clicked",
                      GTK_SIGNAL_FUNC (on_eject_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (continue_button), "clicked",
                      GTK_SIGNAL_FUNC (on_continue_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (reset_button), "clicked",
                      GTK_SIGNAL_FUNC (on_reset_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (ink_button), "clicked",
                      GTK_SIGNAL_FUNC (on_ink_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
                      GTK_SIGNAL_FUNC (on_cancel_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (close_button), "clicked",
                      GTK_SIGNAL_FUNC (on_close_button_clicked),
                      NULL);

  return stm_window;
}

GtkWidget*
create_msg_no_ekpd (void)
{
  GtkWidget *msg_no_ekpd;
  GtkWidget *dialog_vbox1;
  GtkWidget *msg_label;
  GtkWidget *dialog_action_area1;
  GtkWidget *msg_ok_button;

  msg_no_ekpd = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (msg_no_ekpd), "msg_no_ekpd", msg_no_ekpd);
  gtk_window_set_title (GTK_WINDOW (msg_no_ekpd), "dialog1");
  GTK_WINDOW (msg_no_ekpd)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_modal (GTK_WINDOW (msg_no_ekpd), TRUE);
  gtk_window_set_policy (GTK_WINDOW (msg_no_ekpd), FALSE, FALSE, FALSE);

  dialog_vbox1 = GTK_DIALOG (msg_no_ekpd)->vbox;
  gtk_object_set_data (GTK_OBJECT (msg_no_ekpd), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  msg_label = gtk_label_new (_("ekpd has not started.\n\nIn order to use a printer, it is necessary to start ekpd. Start a status monitor again after starting ekpd. In order to start ekpd, execute the following commands in root authority.\n\n# /etc/rc.d/init.d/ekpd start"));
  gtk_widget_ref (msg_label);
  gtk_object_set_data_full (GTK_OBJECT (msg_no_ekpd), "msg_label", msg_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (msg_label);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), msg_label, FALSE, FALSE, 0);
  gtk_label_set_line_wrap (GTK_LABEL (msg_label), TRUE);
  gtk_misc_set_padding (GTK_MISC (msg_label), 20, 20);

  dialog_action_area1 = GTK_DIALOG (msg_no_ekpd)->action_area;
  gtk_object_set_data (GTK_OBJECT (msg_no_ekpd), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  msg_ok_button = gtk_button_new_with_label (_("OK"));
  gtk_widget_ref (msg_ok_button);
  gtk_object_set_data_full (GTK_OBJECT (msg_no_ekpd), "msg_ok_button", msg_ok_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (msg_ok_button);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), msg_ok_button, FALSE, TRUE, 0);

  gtk_signal_connect (GTK_OBJECT (msg_ok_button), "clicked",
                      GTK_SIGNAL_FUNC (on_msg_ok_button_clicked),
                      NULL);

  return msg_no_ekpd;
}

