/*
 * Photo Image Print System
 * Copyright (C) 2001-2002 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2001-2002.
 *
 * This file is part of the `ekpstm' program.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"

#include <unistd.h>
#include <getopt.h>
#include <stdio.h>
#include "ekpcom.h"
#include "stm.h"

#define DOWN_TIMEOUT 60

void destroy (GtkWidget*, gpointer);

int
main (int argc, char *argv[])
{
  GtkWidget *stm_window;
  int c;
  int index = 0;
  struct option allopt[] =
  {
    { "auto", 0, 0, 'a' }
  };

#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");

  /* Getopt */
  auto_down_set (0);
  while ((c = getopt_long (argc, argv, "a", allopt, &index)) != -1)
    {
      switch (c)
        {
        case 'a':
          auto_down_set (DOWN_TIMEOUT);
          break;
	  
        default:
	  break;
        }
    }
  
  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  stm_window = create_stm_window ();
  gtk_widget_show (stm_window);

  gtk_signal_connect(GTK_OBJECT(stm_window), "destroy", GTK_SIGNAL_FUNC(destroy), NULL);
  /* socket ³ */
  sock_open ();

  init_stm (stm_window);
  gtk_main ();
  return 0;
}

void
destroy (GtkWidget *widget, gpointer data)
{
  end_stm ();
  return;
}
