/*
 * Photo Image Print System
 * Copyright (C) 2002 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2002.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#ifndef DEBUG_H
#define DEBUG_H
#include <stdarg.h>

#include <def.h>

#if !DEBUG   /* not DEBUG */
#define DEBUG_START
#define DEDBUG_END

#define DEBUG_INIT_STRUCT(str)
#define DEBUG_PAGE_STRUCT(str)
#define DEBUG_BAND_STRUCT(str)

#else /* DEBUG */
#define DEBUG_START debug_init ()
#define DEDBUG_END debug_end ()

#define DEBUG_INIT_STRUCT(str) \
debug_dump ("--- LIBPRT_INIT_STRUCT ---\n\n" \
	    "output     = -----\n" \
	    "paper      = %s\n" \
	    "format     = %s\n" \
	    "resol      = %s\n" \
	    "high_speed = %s\n" \
	    "media_type = %s\n" \
	    "qlevel     = %s\n" \
	    "margin     = (%d, %d)\n" \
	    "paper_size = (%d, %d)\n" \
	    "paper_area = (%d, %d)\n" \
	    "mw_type    = %s\n" \
	    "inkset     = %s\n" \
	    "auto_cut   = %s\n\n" \
	    "--------------------------\n\n" \
	    ,str.paper \
	    ,str.format \
	    ,str.resol \
	    ,str.high_speed \
	    ,str.media_type \
	    ,str.qlevel \
	    ,str.margin.x \
	    ,str.margin.y \
	    ,str.paper_size.x \
	    ,str.paper_size.y \
	    ,str.paper_area.x \
	    ,str.paper_area.y \
	    ,str.mw_type \
	    ,str.inkset \
	    ,str.auto_cut)

#define DEBUG_PAGE_STRUCT(str) \
debug_dump ("--- LIBPRT_PAGE_STRUCT ---\n\n" \
	    "color_mode    = %s\n" \
	    "halftone_type = %s\n" \
	    "brightness    = %d\n" \
	    "contrast      = %d\n" \
	    "saturation    = %d\n" \
	    "r_strength    = %d\n" \
	    "g_strength    = %d\n" \
	    "b_strength    = %d\n\n" \
	    "--------------------------\n\n" \
	    ,str.color_mode \
	    ,str.halftone_type \
	    ,str.brightness \
	    ,str.contrast \
	    ,str.saturation \
	    ,str.r_strength \
	    ,str.g_strength \
	    ,str.b_strength)

#define DEBUG_BAND_STRUCT(str) \
debug_dump ("--- LIBPRT_BAND_STRUCT ---\n\n" \
	    "width_pixel = %d\n" \
	    "width_bytes = %d\n" \
	    "line_number = %d\n" \
	    "byte_data   = -----\n\n" \
	    "--------------------------\n\n" \
	    ,str.width_pixel \
	    ,str.width_bytes \
	    ,str.line_number)


BEGIN_C

void debug_init (void);
void debug_dump (const char *, ...);
void debug_end (void);

END_C

#endif /* DEBUG */

#endif /* DEBUG_H */
