/*
 * Photo Image Print System
 * Copyright (C) 2000-2002 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2002.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef __X_MODE_H__
#define __X_MODE_H__

#include "pips.h"
#if USE_GTK
#include <gtk/gtk.h>
#include <glib.h>

#ifndef _
#include "libintl.h"
#define _(magic_words) gettext (magic_words)
#endif

#include "inkbox.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define INPUT 0
#define OUTPUT 1
#if USE_GTK

#define GTK_BORDER 3

	typedef struct _RADIO_PACK{
		int id;
		GtkWidget *label;
		GtkWidget *pixmap;
		GSList *group;
	} RADIO_PACK;
  
	typedef struct _CHECK_PACK{
		int id;
		int flag;
		GtkWidget *pixmap;
		GtkWidget *check;
	} CHECK_PACK;
  
	typedef struct _SELECT_PACK{
		int id;
		GtkWidget *pixmap;
		GtkWidget *label;
		GtkWidget *optmenu;
		GtkWidget *hbox;
	} SELECT_PACK;
  
	typedef struct _SPIN_PACK{
		int id;
		GtkWidget *pixmap;
		GtkWidget *label;
		GtkObject *adj;
		GtkWidget *spin;
	} SPIN_PACK;
  
	typedef struct _ADJUSTMENT_PACK{
		int id;
		GtkWidget *pixmap;
		GtkWidget *label;
		GtkObject *adj;
		GtkWidget *entry;
		GtkWidget *hscale;
		double max;
		double min;
	} ADJUSTMENT_PACK;

	typedef struct _UTIL_PACK
	{
		int socket_fd;
		int timer;
		GtkWidget *connect_frame;
		GtkWidget *no_connect_frame;
		GtkWidget *black_prog;
		GtkWidget *color_prog;
		char ** inkbox_xpm;
		GtkWidget *main_widget;
		GtkWidget *inkbox_widget[INK_NUMBER];
		short inkbox_use_flag[INK_NUMBER];
		int inkbox_counter;

		int ink_low_flag;
	} UTIL_PACK, *LP_UTIL_PACK;

#endif

        typedef struct INK_NODE {
 	       unsigned long id;
	       int rest;
	       struct INK_NODE *next;
        } InkNode, *InkList;

	extern char *inkEntry[];
	extern char *mediaSizeEntry[];
	extern char *mediaTypeEntry[];
	extern char *resolutionEntry[];
	extern char *colorModeEntry[];
	extern char *halftoneEntry[];
	extern char *dotEntry[];
	extern char *levelEntry[];
	extern char *multiPageEntry[];

	extern char *mediaSizeEntry_R[];
#ifndef PM820_3300C
	extern char *mediaSizeEntry_TR[];
#else
	extern char *mediaSizeEntry_TR_PM3300C[];
	extern char *mediaSizeEntry_TR_PM820C[];
	extern char *mediaSizeEntry_TA[];
#endif /* PM820_3300C */
#ifdef USE_AUTO_TRIM_4
	extern char *mediaSizeEntry_NMA[];
#endif /* USE_AUTO_TRIM_4 */

#if (PMG800) || (PXG900) || (PMG820) || (PXG920) || (PMA900) || (PXG5000)
	extern char *mediaSizeEntry_A[];
	extern char *mediaSizeEntry_TA[];
	extern char *mediaSizeEntry_M[];
	extern char *mediaSizeEntry_TM[];
#endif
#if (PMA900)
	extern char *mediaSizeEntry_REAR[];
	extern char *mediaSizeEntry_TREAR[];
#endif
#if (PM940C) || (PM980C)
	extern char *mediaSizeReject[];
#endif
	
	extern char *binEntry[];

#if AUTO_CUT
	/* 2004.03.05 for Auto Cut */
	extern char *autoCutEntry[];
#endif

#if CLEAR_INK
	/* 2004.01.21 for Clear Ink */
	extern char *clearInkEntry[];
#endif

	extern short pModeCol[];
	extern short pModeMono[];

	extern char *highRanckLabels[];
	extern char *ioLabels[];
	extern char *finishButtonLabels[];
	extern char *outputTypeLabels;
	extern char *outputLabels[];
	extern char *def_margin_label;
	extern OPTION_ALL opt_all[];

	extern char Status_Monitor[];
	extern char Nozzle_Check[];
	extern char Head_Cleaning[];
	extern char Print_Head_Alignment[];
#if AUTO_CUT
	extern char Auto_Cutter_Adjustment[];
#endif
	extern char Ink_Volume[];
	extern char Ink_Black[];
	extern char Ink_Color[];
	extern char Ink_Chenge[];
	extern char No_Connect_Message[];

	extern char Nozzle_Check_Err_Msg[];
	extern char Head_Cleaning_Err_Msg[];
	extern char Head_Alignment_Err_Msg[];
	extern char Utility_Err_Msg[];

	extern char Ink_Change[];
	extern char Ink_Change_Msg[];

	char* commonLabelCall (int, OPTION_DATA*);
	void commonSetOptionsSensitive (void);

#if USE_GTK
	GtkWidget* radioPackNew(char*, char*[], int);
	GtkWidget* checkPackNew(char*, int);
	GtkWidget* selectPackNew(char*, char*[], int);
	GtkWidget* spinPackNew(char*, int, double[]);
	GtkWidget* adjustmentPackNew(char*, int, double[]);
	GtkWidget* ioPackNew(char*, int);

	GtkWidget* commandButtonNew (char*);
	GtkWidget* progressPackNew (char*);
	GtkWidget* inkboxPackNew (void);
	int getInkStatus (void*);
#ifdef CONV_VERSION2
	GtkWidget*
	margin_default_set_button (void);
#endif /* CONV_VERSION2 */

#endif

	void optionsUpdata(int);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __X_MODE_H__ */
