/*
 * Photo Image Print System
 * Copyright (C) 2001-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2001-2004.
 *
 * This file is part of the `ekpnavi' program.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef MSG_H
#define MSG_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

enum MSG_TYPE {
	MSG_NO_BLACK = 0,
	MSG_NO_COLOR,
	MSG_NO_INKALL,
	MSG_NO_CONNECT,
	MSG_NO_IDLE
};

#define CREATE_MSG_NO_BLACK   create_msg_dialog_with_type(MSG_NO_BLACK)
#define CREATE_MSG_NO_COLOR   create_msg_dialog_with_type(MSG_NO_COLOR)
#define CREATE_MSG_NO_INKALL  create_msg_dialog_with_type(MSG_NO_INKALL)
#define CREATE_MSG_NO_CONNECT create_msg_dialog_with_type(MSG_NO_CONNECT)
#define CREATE_MSG_NO_IDLE    create_msg_dialog_with_type(MSG_NO_IDLE)


GtkWidget *create_msg_dialog_with_type (enum MSG_TYPE);


#endif /* MSG_H */
