/*
 * Photo Image Print System
 * Copyright (C) 2001-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2001-2004.
 *
 * This file is part of the `ekpnavi' program.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

/* Debug */
#define _DF(x) x

#include <gtk/gtk.h>

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "interface.h"
#include "support.h"
#include "ekpcom.h"
#include "navi.h"
#include "image.h"
#include "printer.h"
#include "msg.h"
#include "getstat.h"

/*  #define SPOOLER_PATH "lpr -s -Pcl700" */
#define PATTERN_MAX 4
#define MSG_SIZE_MAX 1024
#define BUF_SIZE 256

#define ALIGNMENT_TYPE_NUMBER 8
enum ALIGNMENT_TYPE
{
	TYPE_RULED = 0,
	TYPE_PATCH,
	TYPE_BAND,
	TYPE_AUTOCUT,
	TYPE_RULED_COLOR,
	TYPE_PATCH_COLOR,
	TYPE_BAND_COLOR,

	TYPE_PATCH_EXT,			/* Added for PM-G700 */
	TYPE_PATCH_EXT_COLOR,

};

enum EXCEPTION_BITS
{
	NAVI_EX_NORMAL = 0,
	NAVI_EX_PM950C,
	NAVI_EX_SC82S,
	NAVI_EX_PM970C,
	NAVI_EX_PM4000PX,
	NAVI_EX_PMG700,
	NAVI_EX_PXV600,
	NAVI_EX_SC64_63S,
	NAVI_EX_PMG800,
	NAVI_EX_PMA850
};

typedef struct _EKP_NAVI_INFO
{
	GtkWidget* top_dialog;
	int get_status_timer;
	int wait_timer;
	int page;
	int status;
	int error;

	GdkPixmap *pixmap[5];
	GdkBitmap *mask[5];
	int npix;			/* Ѥpixmap */
	int cpix;			/* ɽpixmapֹ */

	char printer[BUF_SIZE];
	int navi_mode;
	int align_val[ALIGNMENT_TYPE_NUMBER];
	int ink_select;		/* INK_BLACK, INK_COLOR, INK_ALL */
	char align_path[ALIGNMENT_TYPE_NUMBER][BUF_SIZE];

	int sn_flag;
	DD_PARAM * ruled_dd;
	DD_PARAM * patch_dd;
	DD_PARAM * band_dd;
	DD_PARAM * cut_dd;
	
	EX_DD_PARAM * ex_patch_dd;
	int ex_bits;
} NAVI_INFO, *P_NAVI_INFO;


static NAVI_INFO _navi_info;

static char command_start[] = {
	0x00, 0x00, 0x00, 0x1b, 0x01, 0x40, 0x45, 0x4a,
	0x4c, 0x20, 0x31, 0x32, 0x38, 0x34, 0x2e, 0x34,
	0x0a, 0x40, 0x45, 0x4a, 0x4c, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x0a,

	0x1b, 0x40, 0x1b, 0x40,
	0x1b, 0x28, 0x52, 0x08, 0x00, 0x00, 'R', 'E',
	'M', 'O', 'T', 'E', '1'
};

/*
  static char command_end[] = {
  0x00, 0x00
  };
*/

static char alignment_print_end[] = {
	0x1b, 0x00, 0x00, 0x00,
	0x0c,
	0x1b, '@', 0x1b, '@'
};

static char alignment_set_end[] = {
	0x1b, 0x00, 0x00, 0x00,
	0x1b, 0x40, 0x1b, 0x40,

	0x1b, 0x28, 0x52, 0x08, 0x00, 0x00, 0x52, 0x45,
	0x4d, 0x4f, 0x54, 0x45, 0x31, 0x4a, 0x45, 0x01,
	0x00, 0x00, 0x1b, 0x00, 0x00, 0x00
};

static char platen_gap[] = {
	'S', 'N', 0x03, 0x00, 0x00, 0x01, 0x00
};

static char alignment_print[] = {
	'D',  'T',  0x03, 0x00, 0x00, 0xff, 0x00
}; 

static char alignment_set[] = {
	'D',  'A',  0x04, 0x00, 0x00, 0xff, 0x00, 0xff
};

static char alignment_patch_print[] = {
	'D',  'U',  0x06, 0x00, 0x00, 0xff, 0x00, 0x09, 0x00, 0xff
}; 

static char alignment_patch_set[] = {
	'D',  'A',  0x06, 0x00, 0x00, 0xff, 0x00, 0xff, 0x09, 0x00
};

static char alignment_set_dd[] = {
	'D',  'D',  0x05, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
};

static char alignment_save[] = {
	'S', 'V', 0x00, 0x00
};

static char alignment_load[] = {
	'L', 'D', 0x00, 0x00
};


/*
  static char alignment_band_print[] = {
  'B',  'F',  0x74, 0x00
  };
*/
static char get_st_com[] = { 's', 't', 0x01, 0x00, 0x01 };
/*  static char ink_status[] = { 'c', 's', 0x01, 0x00, 0x00 }; */ /* ink_status[4]0x00Ǥ */
static char ink_move[] = { 'x', 'i', 0x01, 0x00, 0x00 }; /* ink_move[4]0x00Ǥ */
static char ink_position[] = { 'c', 'x', 0x01, 0x00, 0x01 };
static char ink_end[] = { 'e', 'i', 0x01, 0x00, 0x00 };


static void alignment_navi (int);
static void align_ruled_navi (int);
static void align_patch_navi (int);
static void align_band_navi (int);
static void align_autocut_navi (int);
static void align_patch_ext_navi (int);

static void cartridge_navi (int);
static void black_cartridge (int);
static void color_cartridge (int);
static void all_cartridge (int);

static void exec_printer (char *, int);
static void exec_printer_for_file (char*);

static void set_align_combo (int, int, int);
static int wait_set_cartridge (void*);
static int wait_charge (void*);
static void all_hide (GtkWidget *);
static int get_printer_status (void*);

static void display_message (GtkText*, char*);

void
set_platen (void)
{
	_navi_info.sn_flag = 1;
	return;
}

void
init_navi (GtkWidget* top, int mode)
{
	memset (&_navi_info, 0, sizeof (_navi_info));
	_navi_info.top_dialog = top;
	_navi_info.navi_mode = mode;

	if (mode == INK_CHENGE)
	{
		sock_open ();
		_navi_info.get_status_timer = gtk_timeout_add (1000, get_printer_status, NULL);
	}
	return;
}

void
end_navi (void)
{
	if (_navi_info.navi_mode == INK_CHENGE)
	{
		int nwrite;

		sock_close ();
		gtk_timeout_remove (_navi_info.get_status_timer);

		if ((_navi_info.page >= 1 && _navi_info.page < 5)
		    || (_navi_info.page >= 6 && _navi_info.page < 10))
		{
			ink_move[4] = 0xff;
			nwrite = sizeof (ink_move);
			sock_write_abandon_reply (ink_move, &nwrite);

			nwrite = sizeof (ink_end);
			sock_write_abandon_reply (ink_end, &nwrite);
		}
	}

	else if (_navi_info.navi_mode == DOT_ALIGNMENT)
	{
		char command[BUF_SIZE];
		int nwrite = 0;

		if (_navi_info.ex_bits == NAVI_EX_PM950C
		    && _navi_info.align_val[TYPE_RULED] == 0
		    && _navi_info.align_val[TYPE_PATCH] != 0)
		{
			int i;
			
			memcpy (command, command_start, sizeof (command_start));
			nwrite += sizeof (command_start);
			
			for (i = 0; i < _navi_info.align_val[TYPE_PATCH]; i++)
			{
				assert (_navi_info.patch_dd[i].bid_id != 0xff);
				
				switch (i)
				{
				case 0:	alignment_set_dd[7] = 0xfe; break;
				case 1:	alignment_set_dd[7] = 0xfc; break;
				case 2:	alignment_set_dd[7] = 0x00; break;
				default: break;
				}
				alignment_set_dd[5] = _navi_info.patch_dd[i].bid_id;
				alignment_set_dd[6] = _navi_info.patch_dd[i].color;
				alignment_set_dd[8] = _navi_info.patch_dd[i].unit;
				memcpy (command + nwrite, alignment_set_dd, sizeof (alignment_set_dd));
				nwrite += sizeof (alignment_set_dd);
			}
			memcpy (command + nwrite, alignment_save, sizeof (alignment_save));
			nwrite += sizeof (alignment_save);
			memcpy (command + nwrite, alignment_print_end, sizeof (alignment_print_end));
			nwrite += sizeof (alignment_print_end);
			exec_printer (command, nwrite);
			nwrite = 0;
		}
		
		memcpy (command, command_start, sizeof (command_start));
		nwrite += sizeof (command_start);
		memcpy (command + nwrite, alignment_load, sizeof (alignment_load));
		nwrite += sizeof (alignment_load);
		memcpy (command + nwrite, alignment_set_end, sizeof (alignment_set_end));
		nwrite += sizeof (alignment_set_end);
		exec_printer (command, nwrite);
	}

	else if (_navi_info.navi_mode == AUTOCUT_ABJUSTMENT)
	{
		/* No action */
	}

	gtk_main_quit ();
}

void
destroy_navi (GtkWidget* widget, gpointer data)
{
	end_navi ();
}

void
init_alignment (char* printer, int ruled, int patch, int band,
		char* ruled_path, char* patch_path, char* band_path, char* model)
{
	memcpy (_navi_info.printer, printer, strlen (printer) + 1);
	_navi_info.ex_bits = NAVI_EX_NORMAL;

	memcpy (_navi_info.align_path[TYPE_RULED], ruled_path, strlen (ruled_path) + 1);
	memcpy (_navi_info.align_path[TYPE_PATCH], patch_path, strlen (patch_path) + 1);
	memcpy (_navi_info.align_path[TYPE_BAND], band_path, strlen (band_path) + 1);

	/* use PATCH path */
	memcpy (_navi_info.align_path[TYPE_PATCH_EXT], patch_path, strlen (patch_path) + 1);

	if (!strcmp (model, "PM-890C"))
	{
		_navi_info.align_val[TYPE_RULED] = 3;
		_navi_info.align_val[TYPE_PATCH] = 2;

		_navi_info.sn_flag = 1;
		_navi_info.patch_dd = dd_pm890c;
	}
	else if (!strcmp (model, "PM-950C") || !strcmp (model, "Stylus Photo 960"))
	{
		_navi_info.align_val[TYPE_RULED] = 4;
		_navi_info.align_val[TYPE_PATCH] = 3;

		_navi_info.patch_dd = dd_pm950c;
		_navi_info.ex_bits = NAVI_EX_PM950C;
	}
	else if (!strcmp (model, "PM-850PT")
		 || !strcmp (model, "Stylus Photo 925")
		 || !strcmp (model, "PM-870C")
		 || !strcmp (model, "PM-860PT") )
	{
		_navi_info.align_val[TYPE_RULED] = 3;
		_navi_info.align_val[TYPE_PATCH] = 2;

		_navi_info.patch_dd = dd_patch_pm850pt;

		/* color patch */
		if( !strcmp(model, "PM-860PT" ) ){
			strcat(_navi_info.align_path[TYPE_PATCH], ".COLOR");
		}

	}
	else if (!strcmp (model, "PM-840C"))
	{
		_navi_info.align_val[TYPE_RULED] = 3;
		_navi_info.align_val[TYPE_PATCH] = 2;

		_navi_info.patch_dd = dd_patch_pm840c;
	}
	else if (!strcmp (model, "Stylus C82 Series")
	      || !strcmp (model, "PX-V700")
	      || !strcmp (model, "CC-600PX")
	      || !strcmp (model, "Stylus CX5100_5200 Series")
	      || !strcmp (model, "Stylus CX5300_5400 Series")
	      || !strcmp (model, "Stylus CX6300_6400 Series"))
	{
		_navi_info.align_val[TYPE_RULED] = 5;
		_navi_info.align_val[TYPE_RULED_COLOR] = 4;
		_navi_info.align_val[TYPE_BAND] = 1;
		_navi_info.align_val[TYPE_BAND_COLOR] = 1;
		_navi_info.ex_bits = NAVI_EX_SC82S;
	}
	else if (!strcmp (model, "PM-970C")
	      || !strcmp (model, "PM-980C") )
	{
		int inkset;

		_navi_info.align_val[TYPE_RULED] = 1;
		_navi_info.align_val[TYPE_PATCH] = 3;
		_navi_info.align_val[TYPE_PATCH_COLOR] = 3;

		inkset = get_inkset ();

		_navi_info.ruled_dd = dd_ruled_pm970c;
		_navi_info.ex_bits = NAVI_EX_PM970C;

		if (strlen(_navi_info.align_path[TYPE_RULED]) + strlen(".x") + 1 > BUF_SIZE
		    || strlen(_navi_info.align_path[TYPE_PATCH]) + strlen(".x") + 1 > BUF_SIZE) {
			exit(1);
		}

		if (inkset == PIPS_INKSET_CMYKcmDY) {
			_navi_info.ex_patch_dd = dd_patch_pm970c_7color;
			strcat(_navi_info.align_path[TYPE_RULED], ".7");
			strcat(_navi_info.align_path[TYPE_PATCH], ".7");
		} else if (inkset == PIPS_INKSET_CMYK) {
			_navi_info.ex_patch_dd = dd_patch_pm970c_4color;
			strcat(_navi_info.align_path[TYPE_RULED], ".4");
			strcat(_navi_info.align_path[TYPE_PATCH], ".4");
		} else {
			exit(1);
		}
	}
	else if (!strcmp (model, "PM-930C")
	      || !strcmp (model, "PM-940C")  )
	{
		/* using PM-970C Sequence	*/
		_navi_info.align_val[TYPE_RULED] = 1;
		_navi_info.align_val[TYPE_PATCH] = 3;
		_navi_info.align_val[TYPE_PATCH_COLOR] = 3;

		_navi_info.ruled_dd = dd_ruled_pm970c;
		_navi_info.ex_bits = NAVI_EX_PM970C;

		_navi_info.ex_patch_dd = dd_patch_pm970c_7color;
	}
	else if (!strcmp (model, "Stylus Photo 2100_2200")
	      || !strcmp (model, "PM-4000PX") )
	{
		_navi_info.align_val[TYPE_RULED] = 2;
		_navi_info.align_val[TYPE_PATCH] = 3;
		_navi_info.align_val[TYPE_BAND]  = 1;

		_navi_info.patch_dd = dd_patch_pm4000px;
		_navi_info.ex_bits = NAVI_EX_PM4000PX;

		/* color patch */
		strcat(_navi_info.align_path[TYPE_PATCH], ".COLOR");
	}
	else if (!strcmp (model, "PM-3700C"))
	{
		_navi_info.align_val[TYPE_RULED] = ruled;
		_navi_info.align_val[TYPE_PATCH] = patch;

		_navi_info.sn_flag = 1 ;
	}
	else if (!strcmp (model, "PM-G700") || !strcmp (model, "PM-A850") || !strcmp (model, "PM-D750")
			|| !strcmp (model, "Stylus Photo R300_310") || !strcmp (model, "Stylus Photo R200_210")
			|| !strcmp (model, "Stylus Photo RX600_610") || !strcmp (model, "Stylus Photo RX500_510"))
	{
		_navi_info.align_val[TYPE_PATCH_EXT]       = 4;
		_navi_info.align_val[TYPE_PATCH_EXT_COLOR] = 4;
		if( !strcmp (model, "PM-G700") || !strcmp (model, "PM-D750") || !strcmp (model, "Stylus Photo R300_310")
			|| !strcmp (model, "Stylus Photo R200_210") || !strcmp (model, "Stylus Photo RX500_510"))
			_navi_info.ex_bits = NAVI_EX_PMG700;
		if( !strcmp (model, "PM-A850") || !strcmp (model, "Stylus Photo RX600_610") )
			_navi_info.ex_bits = NAVI_EX_PMA850;

	}else if (!strcmp (model, "Stylus C64_63 Series" ) || !strcmp (model, "PX-V500" )){
		_navi_info.align_val[TYPE_PATCH_EXT]       = 4;
		_navi_info.align_val[TYPE_PATCH_EXT_COLOR] = 4;
		_navi_info.align_val[TYPE_BAND]       = 1;
		_navi_info.align_val[TYPE_BAND_COLOR] = 1;
		_navi_info.ex_bits = NAVI_EX_SC64_63S;

	}else if (!strcmp (model, "PX-V600" ) || !strcmp (model, "Stylus C84_83 Series" )){
		_navi_info.align_val[TYPE_PATCH_EXT]       = 5;
		_navi_info.align_val[TYPE_PATCH_EXT_COLOR] = 4;
		_navi_info.align_val[TYPE_BAND]       = 1;
		_navi_info.align_val[TYPE_BAND_COLOR] = 1;
		_navi_info.ex_bits = NAVI_EX_PXV600;

	}
	else if (!strcmp (model, "PM-G800"))
	{
		_navi_info.align_val[TYPE_PATCH_EXT]       = 3;
		_navi_info.ex_bits = NAVI_EX_PMG800;
	}
	else
	{
		_navi_info.align_val[TYPE_RULED] = ruled;
		_navi_info.align_val[TYPE_PATCH] = patch;
		_navi_info.align_val[TYPE_BAND] = band;
	}

	return;
}

void
init_align_autocut (char* printer, char* path, char* model)
{
	memcpy (_navi_info.printer, printer, strlen (printer) + 1);
	_navi_info.ex_bits = NAVI_EX_NORMAL;
	
	if (!strcmp (model, "PM-850PT") || !strcmp (model, "Stylus Photo 925")
	    || !strcmp (model, "PM-860PT"))
	{
		_navi_info.align_val[TYPE_AUTOCUT] = 1;
		_navi_info.cut_dd = dd_cut_pm850pt;
		memcpy (_navi_info.align_path[TYPE_AUTOCUT], path, strlen (path) + 1);
	}

	return;
}


int
get_navi_page (void)
{
	return _navi_info.page;
}

void
set_navi_page (int page_now)
{
	GtkWidget* top = _navi_info.top_dialog;
	GtkWidget* widget;
	int i;

	_navi_info.page = page_now;
	all_hide (top);

	/* PIXMAP */
	_navi_info.cpix = 0;
	for(i = 0; i < _navi_info.npix; i++)
		gdk_pixmap_unref(_navi_info.pixmap[i]);
  
	if (_navi_info.navi_mode == DOT_ALIGNMENT)
		alignment_navi (page_now);

	else if (_navi_info.navi_mode == INK_CHENGE)
		cartridge_navi (page_now);

	else if (_navi_info.navi_mode == AUTOCUT_ABJUSTMENT)
	{
		if (_navi_info.align_val[TYPE_AUTOCUT] <= 0)
			end_navi ();
		align_autocut_navi (page_now);
	}

	else
		_exit (1);

	widget = lookup_widget (top, "st_pix");
	gtk_pixmap_set(GTK_PIXMAP(widget), _navi_info.pixmap[0], _navi_info.mask[0]);
	return;
}


static void
alignment_navi (int page)
{
	if (_navi_info.align_val[TYPE_RULED] > 0) {
		align_ruled_navi (page);
	} else {
		if (_navi_info.align_val[TYPE_PATCH] > 0) {
			align_patch_navi (page);
		} else if (_navi_info.align_val[TYPE_BAND] > 0) {
			align_band_navi (page);
		} else if (_navi_info.align_val[TYPE_PATCH_EXT] > 0) {
			align_patch_ext_navi (page);
		} else {
			end_navi ();
		}
	}
}

static void
align_ruled_navi (int page)
{
	GtkWidget *text, *widget;
	GtkWidget *top = _navi_info.top_dialog;

	/*  char message[MSG_SIZE_MAX]; */
	char command[BUF_SIZE];
	int nwrite;
	int i;

	nwrite = 0;
	memset (command, 0, sizeof (command));
	text = lookup_widget (top, "message");

	switch (page)
	{
	case 0:
		_navi_info.npix = 1;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)S1901);

		if (_navi_info.ex_bits == NAVI_EX_PM950C)
		{
			memcpy (command, command_start, sizeof (command_start));
			nwrite += sizeof (command_start);

			for (i = 0; i < _navi_info.align_val[TYPE_RULED]; i++)
			{
				alignment_set[5] = i;
				if (i == 2)
					alignment_set[7] = 0x08;
				else
					alignment_set[7] = 0x04;

				memcpy (command + nwrite, alignment_set, sizeof (alignment_set));
				nwrite += sizeof (alignment_set);
			}
			memcpy (command + nwrite, alignment_print_end, sizeof (alignment_print_end));
			nwrite += sizeof (alignment_print_end);
			exec_printer (command, nwrite);
			nwrite = 0;
		}
		
		display_message (GTK_TEXT(text),
				 _("The Print Head Alignment utility improves printout quality if used before printing in High Speed mode.\n\n"
				   "If also fixes misaligned vertical lines and blurry printouts."));
		widget = lookup_widget (top, "cancel_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "next_button");
		gtk_widget_show (widget);
		break;

	case 1:
		_navi_info.npix = 1;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)S1901);

		display_message (GTK_TEXT(text),
				 _("The printer will print an alignment sheet.\n\n"
				   "Please make sure that the printer is on and connected to the computer. Print head alignment requires several sheets of A4 or Letter size paper.\n\n"
				   "Click \"Next\" when ready."));
		widget = lookup_widget (top, "cancel_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "next_button");
		gtk_widget_show (widget);
		break;

	case 2:
		_navi_info.npix = 1;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)S1901);

		if (*_navi_info.align_path[TYPE_RULED] == '\0')
		{
			memcpy (command, command_start, sizeof (command_start));
			nwrite += sizeof (command_start);
	  
			for (i = 0; i < _navi_info.align_val[TYPE_RULED]; i++)
			{
				if (_navi_info.sn_flag)
				{
					memcpy (command + nwrite, platen_gap, sizeof (platen_gap));
					nwrite += sizeof (platen_gap);
				}
				alignment_print[5] = i;
				memcpy (command + nwrite, alignment_print, sizeof (alignment_print));
				nwrite += sizeof (alignment_print);
			}
			memcpy (command + nwrite, alignment_print_end, sizeof (alignment_print_end));
			nwrite += sizeof (alignment_print_end);
			exec_printer (command, nwrite);
		}
		else
		{
			exec_printer_for_file (_navi_info.align_path[TYPE_RULED]);
		}

		display_message (GTK_TEXT(text),
				 _("Look at the alignment sheet.\n\n"
				   "Find the patterns on the printed sheet that are vertically aligned. Then click the drop down list and select the number of those alignment patterns from the lists below and click \"OK\". This will make the new settings take effect.\n\n"
				   "If you cannot find an aligned pattern, select the number of the most aligned pattern, and click \"Retry\". The alignment sheet will be printed again."));
		widget = lookup_widget (top, "retry_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "cancel_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "ok_button");
		gtk_widget_show (widget);

		for (i = 0; i < _navi_info.align_val[TYPE_RULED]; i++)
		{
			char label_name[] = "align_label_X";
			char combo_name[] = "align_combo_X";

			set_align_combo (i, 15, 8);

			label_name[12] = '1' + i;
			combo_name[12] = '1' + i;
			widget = lookup_widget (top, label_name);
			gtk_widget_show (widget);
			widget = lookup_widget (top, combo_name);
			gtk_widget_show (widget);
		}
		break;

	case 3:
		_navi_info.npix = 0;

		memcpy (command, command_start, sizeof (command_start));
		nwrite += sizeof (command_start);

		if (_navi_info.ex_bits == NAVI_EX_PM970C)
		{
			for (i = 0; _navi_info.ruled_dd[i].bid_id != 0xff; i++)
			{
				int val;
				
				widget = lookup_widget (top, "align_combo_1");
				val = atoi (gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(widget)->entry)));
				
				alignment_set_dd[5] = _navi_info.ruled_dd[i].bid_id;
				alignment_set_dd[6] = _navi_info.ruled_dd[i].color;
				alignment_set_dd[7] = (char)(val - 8) & 0xff; /* ͤžƤ */
				alignment_set_dd[8] = _navi_info.ruled_dd[i].unit;
				memcpy (command + nwrite, alignment_set_dd, sizeof (alignment_set_dd));
				nwrite += sizeof (alignment_set_dd);
			}
		}
		else
		{
			for (i = 0; i < _navi_info.align_val[TYPE_RULED]; i++)
			{
				char wname[] = "align_combo_X";
				int val;
				int len;
				
				wname[12] = '1' + i;
				widget = lookup_widget (top, wname);
				val = atoi (gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(widget)->entry)));
				
				len = strlen (_navi_info.align_path[TYPE_RULED]) - strlen ("COLOR");
				if (strncmp (_navi_info.align_path[TYPE_RULED] + len, "COLOR", strlen ("COLOR")))
				{
					if (_navi_info.ex_bits == NAVI_EX_SC82S)
					{
						alignment_set[5] = (i == 4) ? 0 : i + 1;
					}
					else
					{
						alignment_set[5] = i;
					}
					alignment_set[6] = 0x00;
				}
				else
				{
					if (_navi_info.ex_bits == NAVI_EX_SC82S)
					{
						alignment_set[5] = (i == 3) ? 0 : i + 2;
					}
					else
					{
						alignment_set[5] = i;
					}
					alignment_set[6] = 0x01;
				}
				
				alignment_set[7] = val;
				memcpy (command + nwrite, alignment_set, sizeof (alignment_set));
				nwrite += sizeof (alignment_set);
			}
		}
		memcpy (command + nwrite, alignment_save, sizeof (alignment_save));
		nwrite += sizeof (alignment_save);
		memcpy (command + nwrite, alignment_set_end, sizeof (alignment_set_end));
		nwrite += sizeof (alignment_set_end);
		exec_printer (command, nwrite);

		if (_navi_info.ex_bits == NAVI_EX_PM950C)
		{
			nwrite = 0;
			memcpy (command, command_start, sizeof (command_start));
			nwrite += sizeof (command_start);

			for (i = 0; i < _navi_info.align_val[TYPE_RULED]; i++)
			{
				alignment_set[5] = i;
				if (i == 2)
					alignment_set[7] = 0x08;
				else
					alignment_set[7] = 0x0C;

				memcpy (command + nwrite, alignment_set, sizeof (alignment_set));
				nwrite += sizeof (alignment_set);
			}
			memcpy (command + nwrite, alignment_save, sizeof (alignment_save));
			nwrite += sizeof (alignment_save);
			memcpy (command + nwrite, alignment_print_end, sizeof (alignment_print_end));
			nwrite += sizeof (alignment_print_end);
			exec_printer (command, nwrite);

		}

		if (_navi_info.align_val[TYPE_RULED_COLOR])
		{
			if ((strlen (_navi_info.align_path[TYPE_RULED]) + strlen (".COLOR")) < BUF_SIZE)
			{
				_navi_info.align_val[TYPE_RULED] = _navi_info.align_val[TYPE_RULED_COLOR];
				strcat (_navi_info.align_path[TYPE_RULED], ".COLOR");
				_navi_info.align_val[TYPE_RULED_COLOR] = 0;
				set_navi_page (1);
			}
			else
			{
				_navi_info.align_val[TYPE_RULED_COLOR] = 0;
				_navi_info.align_val[TYPE_RULED] = 0;
			}
		}
		else
		{
			_navi_info.align_val[TYPE_RULED] = 0;

		}

		set_navi_page (0);
		break;

	case 4:
		_navi_info.npix = 0;

		memcpy (command, command_start, sizeof (command_start));
		nwrite += sizeof (command_start);
      
		if (_navi_info.ex_bits == NAVI_EX_PM970C)
		{
			for (i = 0; _navi_info.ruled_dd[i].bid_id != 0xff; i++)
			{
				int val;
				
				widget = lookup_widget (top, "align_combo_1");
				val = atoi (gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(widget)->entry)));
				
				alignment_set_dd[5] = _navi_info.ruled_dd[i].bid_id;
				alignment_set_dd[6] = _navi_info.ruled_dd[i].color;
				alignment_set_dd[7] = (char)(val - 8) & 0xff; /* ͤžƤ */
				alignment_set_dd[8] = _navi_info.ruled_dd[i].unit;
				memcpy (command + nwrite, alignment_set_dd, sizeof (alignment_set_dd));
				nwrite += sizeof (alignment_set_dd);
			}
		}
		else
		{
			for (i = 0; i < _navi_info.align_val[TYPE_RULED]; i++)
			{
				char wname[] = "align_combo_X";
				int val;
				int len;
				
				wname[12] = '1' + i;
				widget = lookup_widget (top, wname);
				val = atoi (gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(widget)->entry)));
				len = strlen (_navi_info.align_path[TYPE_RULED]) - strlen ("COLOR");
				
				if (strncmp (_navi_info.align_path[TYPE_RULED] + len, "COLOR", strlen ("COLOR")))
				{
					if (_navi_info.ex_bits == NAVI_EX_SC82S)
					{
						alignment_set[5] = (i == 4) ? 0 : i + 1;
					}
					else
					{
						alignment_set[5] = i;
					}
					alignment_set[6] = 0x00;
				}
				else
				{
					if (_navi_info.ex_bits == NAVI_EX_SC82S)
					{
						alignment_set[5] = (i == 3) ? 0 : i + 2;
					}
					else
					{
						alignment_set[5] = i;
					}
					alignment_set[6] = 0x01;
				}
				
				alignment_set[7] = val;
				memcpy (command + nwrite, alignment_set, sizeof (alignment_set));
				nwrite += sizeof (alignment_set);
			}
		}
		memcpy (command + nwrite, alignment_set_end, sizeof (alignment_set_end));
		nwrite += sizeof (alignment_set_end);
		exec_printer (command, nwrite);

		set_navi_page (1);
		break;

	default:
		fprintf (stderr, "error page (%d).\n", page);
		end_navi ();
		break;
	}
};

static void
align_patch_navi (int page)
{
	GtkWidget *text, *widget;
	GtkWidget *top = _navi_info.top_dialog;

	/*  char message[MSG_SIZE_MAX]; */
	char command[BUF_SIZE];
	int nwrite;
	int i;

	nwrite = 0;
	memset (command, 0, sizeof (command));
	text = lookup_widget (top, "message");

	switch (page)
	{
	case 0:
		if (_navi_info.ex_bits == NAVI_EX_PM950C)
		{
			memcpy (command, command_start, sizeof (command_start));
			nwrite += sizeof (command_start);
			
			for (i = 0; i < _navi_info.align_val[TYPE_PATCH]; i++)
			{
				assert (_navi_info.patch_dd[i].bid_id != 0xff);
				
				switch (i)
				{
				case 0:	alignment_set_dd[7] = 0x02; break;
				case 1:	alignment_set_dd[7] = 0x04; break;
				case 2:	alignment_set_dd[7] = 0x00; break;
				default: break;
				}
				alignment_set_dd[5] = _navi_info.patch_dd[i].bid_id;
				alignment_set_dd[6] = _navi_info.patch_dd[i].color;
				alignment_set_dd[8] = _navi_info.patch_dd[i].unit;
				memcpy (command + nwrite, alignment_set_dd, sizeof (alignment_set_dd));
				nwrite += sizeof (alignment_set_dd);
				
			}
			memcpy (command + nwrite, alignment_save, sizeof (alignment_save));
			nwrite += sizeof (alignment_save);
			memcpy (command + nwrite, alignment_print_end, sizeof (alignment_print_end));
			nwrite += sizeof (alignment_print_end);
			exec_printer (command, nwrite);
			nwrite = 0;
		}
		_navi_info.page ++;
		/* down */
	case 1:
		_navi_info.npix = 1;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)A0101);

		{		/* Fri Feb 21 2003 - PM-970C */
			int len;
			
			len = strlen (_navi_info.align_path[TYPE_PATCH]) - strlen ("COLOR");
			if( *_navi_info.align_path[TYPE_PATCH] != '\0' 
			&& strncmp (_navi_info.align_path[TYPE_PATCH] + len, "COLOR", strlen ("COLOR")) ){
				display_message (GTK_TEXT(text),
						 _("The printer will print an alignment sheet for black printing (#1).\n\n"
						   "Please make sure that the printer is turned on and is connected to the computer.\n"
						   "Print head alignment requires several sheets of A4 or Letter size Photo Quality Ink Jet Paper.\n\n"
						   "Click \"Next\" when ready."));
			} else {
				display_message (GTK_TEXT(text),
						 _("The printer will print an alignment sheet for color printing (#1).\n\n"
						   "Please make sure that the printer is turned on and is connected to the computer.\n"
						   "Print head alignment requires several sheets of A4 or Letter size Photo Quality Ink Jet Paper.\n\n"
						   "Click \"Next\" when ready."));
			}
		}

		widget = lookup_widget (top, "cancel_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "next_button");
		gtk_widget_show (widget);

		if (_navi_info.align_val[TYPE_PATCH] == 1) /* ѥ󤬰Ĥʤ */
			_navi_info.page += 2;

		break;

	case 2:
		_navi_info.npix = 1;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)A0201);

		if (*_navi_info.align_path[TYPE_PATCH] == '\0')
		{
			memcpy (command, command_start, sizeof (command_start));
			nwrite += sizeof (command_start);
			if (_navi_info.sn_flag)
			{
				memcpy (command + nwrite, platen_gap, sizeof (platen_gap));
				nwrite += sizeof (platen_gap);
			}
			alignment_patch_print[5] = 1;
			alignment_patch_print[9] = 0;
			memcpy (command + nwrite, alignment_patch_print, sizeof (alignment_patch_print));
			nwrite += sizeof (alignment_patch_print);
			memcpy (command + nwrite, alignment_print_end, sizeof (alignment_print_end));
			nwrite += sizeof (alignment_print_end);
			exec_printer (command, nwrite);
		}
		else
		{
			exec_printer_for_file (_navi_info.align_path[TYPE_PATCH]);
		}
		
		{		/* Fri Feb 21 2003 - PM-970C */
			int len;
			
			len = strlen (_navi_info.align_path[TYPE_PATCH]) - strlen ("COLOR");
			if( *_navi_info.align_path[TYPE_PATCH] != '\0' 
			&& strncmp (_navi_info.align_path[TYPE_PATCH] + len, "COLOR", strlen ("COLOR")) ){
				display_message (GTK_TEXT(text),
						 _("The printer will print an alignment sheet for black printing (#2).\n\n"
						   "Reload the sheet printed side up, inserting the top edge first.\n\n"
						   "Click \"Next\" when ready."));
			} else {
				display_message (GTK_TEXT(text),
						 _("The printer will print an alignment sheet for color printing (#2).\n\n"
						   "Reload the sheet printed side up, inserting the top edge first.\n\n"
						   "Click \"Next\" when ready."));
			}
		}

		widget = lookup_widget (top, "cancel_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "next_button");
		gtk_widget_show (widget);

		if (_navi_info.align_val[TYPE_PATCH] == 2) /* ѥ */
			_navi_info.page++;

		break;

	case 3:
		_navi_info.npix = 1;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)A0201);

		if (*_navi_info.align_path[TYPE_PATCH] == '\0')
		{
			memcpy (command, command_start, sizeof (command_start));
			nwrite += sizeof (command_start);
			if (_navi_info.sn_flag)
			{
				memcpy (command + nwrite, platen_gap, sizeof (platen_gap));
				nwrite += sizeof (platen_gap);
			}
			alignment_patch_print[5] = 1;
			alignment_patch_print[9] = 0;
			memcpy (command + nwrite, alignment_patch_print, sizeof (alignment_patch_print));
			nwrite += sizeof (alignment_patch_print);
			memcpy (command + nwrite, alignment_print_end, sizeof (alignment_print_end));
			nwrite += sizeof (alignment_print_end);
			exec_printer (command, nwrite);
		}
		else
		{
			if (_navi_info.align_val[TYPE_PATCH] == 1) /* ѥ󤬰Ĥʤ */
			{
				exec_printer_for_file (_navi_info.align_path[TYPE_PATCH]);
			}
			else
			{
				char path[130];
				
				sprintf (path, "%s.2", _navi_info.align_path[TYPE_PATCH]);
				exec_printer_for_file (path);
			}
		}
		
		{		/* Fri Feb 21 2003 - PM-970C */
			int len;
			
			len = strlen (_navi_info.align_path[TYPE_PATCH]) - strlen ("COLOR");
			if (strncmp (_navi_info.align_path[TYPE_PATCH] + len, "COLOR", strlen ("COLOR")))
			{
				display_message (GTK_TEXT(text),
						 _("The printer will print an alignment sheet for black printing (#3).\n\n"
						   "Reload the sheet printed side up, inserting the top edge first.\n\n"
						   "Click \"Next\" when ready."));
			} else {
				display_message (GTK_TEXT(text),
						 _("The printer will print an alignment sheet for color printing (#3).\n\n"
						   "Reload the sheet printed side up, inserting the top edge first.\n\n"
						   "Click \"Next\" when ready."));
			}
		}

		widget = lookup_widget (top, "cancel_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "next_button");
		gtk_widget_show (widget);

		break;

	case 4:
		_navi_info.npix = 1;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)S1901);

		if (*_navi_info.align_path[TYPE_PATCH] == '\0')
		{
			memcpy (command, command_start, sizeof (command_start));
			nwrite += sizeof (command_start);
			if (_navi_info.sn_flag)
			{
				memcpy (command + nwrite, platen_gap, sizeof (platen_gap));
				nwrite += sizeof (platen_gap);
			}
			
			switch (_navi_info.align_val[TYPE_PATCH])
			{
			case 1:
				alignment_patch_print[5] = 1;
				alignment_patch_print[9] = 0;
				break;

			case 2:
				alignment_patch_print[5] = 2;
				alignment_patch_print[9] = 1;
				break;

			case 3:
				alignment_patch_print[5] = 3;
				alignment_patch_print[9] = 2;
				break;
			default:
				break;
			}

			memcpy (command + nwrite, alignment_patch_print, sizeof (alignment_patch_print));
			nwrite += sizeof (alignment_patch_print);
			memcpy (command + nwrite, alignment_print_end, sizeof (alignment_print_end));
			nwrite += sizeof (alignment_print_end);
			exec_printer (command, nwrite);
		}
		else
		{
			if (_navi_info.align_val[TYPE_PATCH] == 1) /* ѥ󤬰Ĥʤ */
			{
				exec_printer_for_file (_navi_info.align_path[TYPE_PATCH]);
			}
			else
			{
				char path[130];
				
				sprintf (path, "%s.%d", _navi_info.align_path[TYPE_PATCH], _navi_info.align_val[TYPE_PATCH]);
				exec_printer_for_file (path);
			}
		}


		display_message (GTK_TEXT(text),
				 _("Look at the alignment sheet.\n"
				   "Decide which pattern is the least grainy. Select the number that corresponds to that pattern from the drop-down list and click \"OK\".\n\n"
				   "If you cannot find a smooth pattern, select the number for the pattern that is the least grainy, and click \"Retry\". The alignment sheet will be printed again."));
		widget = lookup_widget (top, "retry_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "cancel_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "ok_button");
		gtk_widget_show (widget);

		for (i = 0; i < _navi_info.align_val[TYPE_PATCH]; i++)
		{
			char label_name[] = "align_label_X";
			char combo_name[] = "align_combo_X";

			if (_navi_info.ex_bits == NAVI_EX_PM970C 
			||  _navi_info.ex_bits == NAVI_EX_PM4000PX ){
				set_align_combo (i, 7, 4);
			} else {
				set_align_combo (i, 9, 5);
			}

			label_name[12] = '1' + i;
			combo_name[12] = '1' + i;
			widget = lookup_widget (top, label_name);
			gtk_widget_show (widget);
			widget = lookup_widget (top, combo_name);
			gtk_widget_show (widget);
		}
		break;

	case 5:
		_navi_info.npix = 0;

		memcpy (command, command_start, sizeof (command_start));
		nwrite += sizeof (command_start);
      
		for (i = 0; i < _navi_info.align_val[TYPE_PATCH]; i++)
		{
			char wname[] = "align_combo_X";
			int val;

			wname[12] = '1' + i;
			widget = lookup_widget (top, wname);
			val = atoi (gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(widget)->entry)));

			if (_navi_info.patch_dd != NULL)
			{
				if( _navi_info.ex_bits == NAVI_EX_PM4000PX )
				{
					/* PM4000PX */
					alignment_set_dd[5] = _navi_info.patch_dd[i*2].bid_id;
					alignment_set_dd[6] = _navi_info.patch_dd[i*2].color;
					alignment_set_dd[7] = (char)(val) & 0xff;
					alignment_set_dd[8] = _navi_info.patch_dd[i*2].unit;
					memcpy (command + nwrite, alignment_set_dd, sizeof (alignment_set_dd));
					nwrite += sizeof (alignment_set_dd);
					if( i != 2 ){
						alignment_set_dd[5] = _navi_info.patch_dd[i*2+1].bid_id;
						alignment_set_dd[6] = _navi_info.patch_dd[i*2+1].color;
						alignment_set_dd[7] = (char)(val) & 0xff;
						alignment_set_dd[8] = _navi_info.patch_dd[i*2+1].unit;
						memcpy (command + nwrite, alignment_set_dd, sizeof (alignment_set_dd));
						nwrite += sizeof (alignment_set_dd);
					}
				}
				else
				{

					alignment_set_dd[5] = _navi_info.patch_dd[i].bid_id;
					alignment_set_dd[6] = _navi_info.patch_dd[i].color;
					alignment_set_dd[7] = (char)(5 - val) & 0xff;
					alignment_set_dd[8] = _navi_info.patch_dd[i].unit;
					memcpy (command + nwrite, alignment_set_dd, sizeof (alignment_set_dd));
					nwrite += sizeof (alignment_set_dd);
				}
			}
			else if (_navi_info.ex_bits == NAVI_EX_PM970C)
			{
				int j;
				for (j = 0; _navi_info.ex_patch_dd[j].type != 0xff; j++)
				{
					int len;
					
					len = strlen (_navi_info.align_path[TYPE_PATCH]) - strlen ("COLOR");
					if (strncmp (_navi_info.align_path[TYPE_PATCH] + len, "COLOR", strlen ("COLOR"))) {
						if (_navi_info.ex_patch_dd[j].type != 0x00) {
							continue;
						}
					} else {
						if (_navi_info.ex_patch_dd[j].type != 0x01) {
							continue;
						}
					}
					if ((int)_navi_info.ex_patch_dd[j].number != i) {
						continue;
					}
					alignment_set_dd[5] = _navi_info.ex_patch_dd[j].bid_id;
					alignment_set_dd[6] = _navi_info.ex_patch_dd[j].color;
					alignment_set_dd[7] = (char)(4 - val) & 0xff;
					alignment_set_dd[8] = _navi_info.ex_patch_dd[j].unit;
					memcpy (command + nwrite, alignment_set_dd, sizeof (alignment_set_dd));
					nwrite += sizeof (alignment_set_dd);
				}
			}
			else
			{
				alignment_patch_set[5] = i;
				alignment_patch_set[7] = val;
				memcpy (command + nwrite, alignment_patch_set, sizeof (alignment_patch_set));
				nwrite += sizeof (alignment_patch_set);
			}
		}
		memcpy (command + nwrite, alignment_save, sizeof (alignment_save));
		nwrite += sizeof (alignment_save);
		memcpy (command + nwrite, alignment_set_end, sizeof (alignment_set_end));
		nwrite += sizeof (alignment_set_end);
		exec_printer (command, nwrite);

		if (_navi_info.ex_bits == NAVI_EX_PM950C)
		{
			nwrite = 0;
			memcpy (command, command_start, sizeof (command_start));
			nwrite += sizeof (command_start);

			for (i = 0; i < _navi_info.align_val[TYPE_PATCH]; i++)
			{
				assert (_navi_info.patch_dd[i].bid_id != 0xff);

				switch (i)
				{
				case 0:	alignment_set_dd[7] = 0xfe; break;
				case 1:	alignment_set_dd[7] = 0xfc; break;
				case 2:	alignment_set_dd[7] = 0x00; break;
				default: break;
				}
				alignment_set_dd[5] = _navi_info.patch_dd[i].bid_id;
				alignment_set_dd[6] = _navi_info.patch_dd[i].color;
				alignment_set_dd[8] = _navi_info.patch_dd[i].unit;
				memcpy (command + nwrite, alignment_set_dd, sizeof (alignment_set_dd));
				nwrite += sizeof (alignment_set_dd);
			}
			memcpy (command + nwrite, alignment_save, sizeof (alignment_save));
			nwrite += sizeof (alignment_save);
			memcpy (command + nwrite, alignment_print_end, sizeof (alignment_print_end));
			nwrite += sizeof (alignment_print_end);
			exec_printer (command, nwrite);
		}

		if (_navi_info.align_val[TYPE_PATCH_COLOR])
		{
			if ((strlen (_navi_info.align_path[TYPE_PATCH]) + strlen (".COLOR")) < BUF_SIZE)
			{
				_navi_info.align_val[TYPE_PATCH] = _navi_info.align_val[TYPE_PATCH_COLOR];
				strcat (_navi_info.align_path[TYPE_PATCH], ".COLOR");
				_navi_info.align_val[TYPE_PATCH_COLOR] = 0;
				set_navi_page (1);
			}
			else
			{
				_navi_info.align_val[TYPE_PATCH_COLOR] = 0;
				_navi_info.align_val[TYPE_PATCH] = 0;
			}
		}
		else
		{
			_navi_info.align_val[TYPE_PATCH] = 0;

		}

		set_navi_page (0);
		break;

	case 6:
		_navi_info.npix = 0;

		memcpy (command, command_start, sizeof (command_start));
		nwrite += sizeof (command_start);

		for (i = 0; i < _navi_info.align_val[TYPE_PATCH]; i++)
		{
			char wname[] = "align_combo_X";
			int val;

			wname[12] = '1' + i;
			widget = lookup_widget (top, wname);
			val = atoi (gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(widget)->entry)));

			if (_navi_info.patch_dd != NULL)
			{
				assert (_navi_info.patch_dd[i].bid_id != 0xff);
				alignment_set_dd[5] = _navi_info.patch_dd[i].bid_id;
				alignment_set_dd[6] = _navi_info.patch_dd[i].color;
				alignment_set_dd[7] = (char)(5 - val) & 0xff;
				alignment_set_dd[8] = _navi_info.patch_dd[i].unit;
				memcpy (command + nwrite, alignment_set_dd, sizeof (alignment_set_dd));
				nwrite += sizeof (alignment_set_dd);
			}
			else if (_navi_info.ex_bits == NAVI_EX_PM970C)
			{
				int j;
				for (j = 0; _navi_info.ex_patch_dd[j].type != 0xff; j++)
				{
					int len;
					
					len = strlen (_navi_info.align_path[TYPE_PATCH]) - strlen ("COLOR");
					if (strncmp (_navi_info.align_path[TYPE_PATCH] + len, "COLOR", strlen ("COLOR"))) {
						if (_navi_info.ex_patch_dd[j].type != 0x00) {
							continue;
						}
					} else {
						if (_navi_info.ex_patch_dd[j].type != 0x01) {
							continue;
						}
					}
					if ((int)_navi_info.ex_patch_dd[j].number != i) {
						continue;
					}
					alignment_set_dd[5] = _navi_info.ex_patch_dd[j].bid_id;
					alignment_set_dd[6] = _navi_info.ex_patch_dd[j].color;
					alignment_set_dd[7] = (char)(4 - val) & 0xff;
					alignment_set_dd[8] = _navi_info.ex_patch_dd[j].unit;
					memcpy (command + nwrite, alignment_set_dd, sizeof (alignment_set_dd));
					nwrite += sizeof (alignment_set_dd);
				}

				memcpy (command + nwrite, alignment_save, sizeof (alignment_save));
				nwrite += sizeof (alignment_save);
			}
			else
			{
				alignment_set[5] = i;
				alignment_set[7] = val;
				memcpy (command + nwrite, alignment_patch_set, sizeof (alignment_patch_set));
				nwrite += sizeof (alignment_patch_set);
			}
		}

		if (_navi_info.patch_dd != NULL)
		{
			memcpy (command + nwrite, alignment_save, sizeof (alignment_save));
			nwrite += sizeof (alignment_save);
		}

		memcpy (command + nwrite, alignment_set_end, sizeof (alignment_set_end));
		nwrite += sizeof (alignment_set_end);
		exec_printer (command, nwrite);

		set_navi_page (1);
		break;

	default:
		fprintf (stderr, "error page (%d).\n", page);
		end_navi ();
		break;
	}
	return;
}

static void
align_band_navi (int page)
{
	GtkWidget *text, *widget;
	GtkWidget *top = _navi_info.top_dialog;

	/*  char message[MSG_SIZE_MAX]; */
	char command[BUF_SIZE];
	int nwrite;
	int i;
	int len;

	nwrite = 0;
	memset (command, 0, sizeof (command));
	text = lookup_widget (top, "message");

	switch (page)
	{
	case 0:
		_navi_info.npix = 1;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)S1901);
		
		len = strlen (_navi_info.align_path[TYPE_BAND]) - strlen ("COLOR");
		if (strncmp (_navi_info.align_path[TYPE_BAND] + len, "COLOR", strlen ("COLOR"))){
			display_message (GTK_TEXT(text),
				 _("A black horizontal alignment sheet will be printed.\n"
				   "Make sure that A4 or Letter size plain paper is loaded in the sheet feeder.\n\n"
				   "Click \"Next\" when ready."));
		}else{
			display_message (GTK_TEXT(text),
				 _("A color horizontal alignment sheet will be printed.\n"
				   "Make sure that A4 or Letter size plain paper is loaded in the sheet feeder.\n\n"
				   "Click \"Next\" when ready."));
		}
		
		widget = lookup_widget (top, "cancel_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "next_button");
		gtk_widget_show (widget);
		break;

	case 1:
		_navi_info.npix = 1;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)S1901);

		if (*_navi_info.align_path[TYPE_BAND] == '\0')
		{
			memcpy (command, command_start, sizeof (command_start));
			nwrite += sizeof (command_start);
			alignment_print[5] = 0x10;
			memcpy (command + nwrite, alignment_print, sizeof (alignment_print));
			nwrite += sizeof (alignment_print);
			memcpy (command + nwrite, alignment_print_end, sizeof (alignment_print_end));
			nwrite += sizeof (alignment_print_end);
			exec_printer (command, nwrite);
		}
		else
		{
			exec_printer_for_file (_navi_info.align_path[TYPE_BAND]);
		}

		display_message (GTK_TEXT(text),
				 _("Look at the alignment sheet.\n"
				   "Find the pattern with no black or white band. Select the number that corresponds to that pattern from the list below and click \"OK\".\n\n"
				   "If each pattern contains a band, select the pattern with the thinnest band. Click \"Retry\". The selected pattern will shift to the center position and a new alignment sheet will be printed."));

		widget = lookup_widget (top, "retry_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "cancel_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "ok_button");
		gtk_widget_show (widget);

		for (i = 0; i < _navi_info.align_val[TYPE_BAND]; i++)
		{
			char label_name[] = "align_label_X";
			char combo_name[] = "align_combo_X";

			set_align_combo (i, 7, 4);

			label_name[12] = '1' + i;
			combo_name[12] = '1' + i;
			widget = lookup_widget (top, label_name);
			gtk_widget_show (widget);
			widget = lookup_widget (top, combo_name);
			gtk_widget_show (widget);
		}
		break;

	case 2:
		_navi_info.npix = 0;

		memcpy (command, command_start, sizeof (command_start));
		nwrite += sizeof (command_start);
      
		for (i = 0; i < _navi_info.align_val[TYPE_BAND]; i++)
		{
			char wname[] = "align_combo_X";
			int val;

			wname[12] = '1' + i;
			widget = lookup_widget (top, wname);
			val = atoi (gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(widget)->entry)));

			len = strlen (_navi_info.align_path[TYPE_BAND]) - strlen ("COLOR");

			/* model depend	*/
			if(_navi_info.ex_bits == NAVI_EX_PXV600
			|| _navi_info.ex_bits == NAVI_EX_SC64_63S ){
				if (strncmp (_navi_info.align_path[TYPE_BAND] + len, "COLOR", strlen ("COLOR")))
				{
					alignment_set_dd[6] = 0x00;
				}
				else
				{
					alignment_set_dd[6] = 0x01;
				}

				alignment_set_dd[5] = 0x80;
				alignment_set_dd[7] = val-4;
				alignment_set_dd[8] = 0x02; 
				memcpy (command + nwrite, alignment_set_dd, sizeof (alignment_set_dd));
				nwrite += sizeof (alignment_set_dd);
			}else{
				if (strncmp (_navi_info.align_path[TYPE_BAND] + len, "COLOR", strlen ("COLOR")))
				{
					alignment_set[6] = 0x00;
				}
				else
				{
					alignment_set[6] = 0x01;
				}

				alignment_set[5] = 0x10 + i;
				alignment_set[7] = val;
				memcpy (command + nwrite, alignment_set, sizeof (alignment_set));
				nwrite += sizeof (alignment_set);
			}
		}
		memcpy (command + nwrite, alignment_save, sizeof (alignment_save));
		nwrite += sizeof (alignment_save);
		memcpy (command + nwrite, alignment_set_end, sizeof (alignment_set_end));
		nwrite += sizeof (alignment_set_end);
		exec_printer (command, nwrite);

		if (_navi_info.align_val[TYPE_BAND_COLOR])
		{
			if ((strlen (_navi_info.align_path[TYPE_BAND]) + strlen (".COLOR")) < BUF_SIZE)
			{
				_navi_info.align_val[TYPE_BAND] = _navi_info.align_val[TYPE_BAND_COLOR];
				strcat (_navi_info.align_path[TYPE_BAND], ".COLOR");
				_navi_info.align_val[TYPE_BAND_COLOR] = 0;
			}
			else
			{
				_navi_info.align_val[TYPE_BAND_COLOR] = 0;
				_navi_info.align_val[TYPE_BAND] = 0;
			}
		}
		else
		{
			_navi_info.align_val[TYPE_BAND] = 0;
		}

		set_navi_page (0);
		break;

	case 3:
		_navi_info.npix = 0;

		memcpy (command, command_start, sizeof (command_start));
		nwrite += sizeof (command_start);
     
		for (i = 0; i < _navi_info.align_val[TYPE_BAND]; i++)
		{
			char wname[] = "align_combo_X";
			int val;
			int len;

			wname[12] = '1' + i;
			widget = lookup_widget (top, wname);
			val = atoi (gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(widget)->entry)));

			len = strlen (_navi_info.align_path[TYPE_BAND]) - strlen ("COLOR");

			/* model depend	*/
			if(_navi_info.ex_bits == NAVI_EX_PXV600
			|| _navi_info.ex_bits == NAVI_EX_SC64_63S ){
				if (strncmp (_navi_info.align_path[TYPE_BAND] + len, "COLOR", strlen ("COLOR")))
				{
					alignment_set_dd[6] = 0x00;
				}
				else
				{
					alignment_set_dd[6] = 0x01;
				}

				alignment_set_dd[5] = 0x80;
				alignment_set_dd[7] = val-4; /* offset value */
				alignment_set_dd[8] = 0x02; 
				memcpy (command + nwrite, alignment_set_dd, sizeof (alignment_set_dd));
				nwrite += sizeof (alignment_set_dd);
			}else{
				if (strncmp (_navi_info.align_path[TYPE_BAND] + len, "COLOR", strlen ("COLOR")))
				{
					alignment_set[6] = 0x00;
				}
				else
				{
					alignment_set[6] = 0x01;
				}
				alignment_set[5] = 0x10 + i;
				alignment_set[7] = val;
				memcpy (command + nwrite, alignment_set, sizeof (alignment_set));
				nwrite += sizeof (alignment_set);
			}
		}
		memcpy (command + nwrite, alignment_save, sizeof (alignment_save));
		nwrite += sizeof (alignment_save);
		memcpy (command + nwrite, alignment_set_end, sizeof (alignment_set_end));
		nwrite += sizeof (alignment_set_end);
		exec_printer (command, nwrite);

		set_navi_page (0);
		break;

	default:
		fprintf (stderr, "error page (%d).\n", page);
		end_navi ();
		break;
	}
	return;
};


static void
align_patch_ext_navi (int page)
{
	GtkWidget *text, *widget;
	GtkWidget *top = _navi_info.top_dialog;

	/*  char message[MSG_SIZE_MAX]; */
	char command[BUF_SIZE];
	int nwrite;
	int len,i;

	nwrite = 0;
	memset (command, 0, sizeof (command));
	text = lookup_widget (top, "message");

	switch (page)
	{
	case 0:
		_navi_info.npix = 1;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)S1901);

		display_message (GTK_TEXT(text),
				 _("The Print Head Alignment utility improves printout quality if used before printing in High Speed mode.\n\n"
				   "If also fixes misaligned vertical lines and blurry printouts."));
		widget = lookup_widget (top, "cancel_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "next_button");
		gtk_widget_show (widget);
		break;

	case 1:
		_navi_info.npix = 1;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)S1901);

		len = strlen (_navi_info.align_path[TYPE_PATCH_EXT]) - strlen ("COLOR");
		if (strncmp (_navi_info.align_path[TYPE_PATCH_EXT] + len, "COLOR", strlen ("COLOR"))){
			display_message (GTK_TEXT(text),
				_("A black vertical alignment sheet will be printed.\n\n"
				  "Make sure that the printer is turned on and connected to the computer.\n"
				  "Also make sure that A4 size plain paper is loaded in the sheet feeder.\n\n"
				  "Click \"Next\" when ready."));
		}else{
			display_message (GTK_TEXT(text),
				_("A color vertical alignment sheet will be printed.\n\n"
				  "Make sure that A4 size plain paper is loaded in the sheet feeder.\n"
				  "Click \"Next\" when ready."));
		}

		widget = lookup_widget (top, "cancel_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "next_button");
		gtk_widget_show (widget);
		break;

	case 2:
		_navi_info.npix = 1;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)S1901);

		if (*_navi_info.align_path[TYPE_PATCH_EXT] == '\0')
		{
			/* in this case not happned! */
		}
		else
		{
			exec_printer_for_file (_navi_info.align_path[TYPE_PATCH_EXT]);
		}


		// depends on patch alignment count
		if( _navi_info.align_val[TYPE_PATCH_EXT] == 5 ){
			display_message (GTK_TEXT(text),
				_("Look at the alignment sheet."
				  "Find the square without any visible bands in sets #1 though #5.Select"
				  "the number that corresponds to that square from the list below for all sets.\n\n"
				  "If every square contains a band, select the square with the thinnest bandor bands.\n"
				  "Then click Realignment.") );
		}else if( _navi_info.align_val[TYPE_PATCH_EXT] == 4 ){
			display_message (GTK_TEXT(text),
				_("Look at the alignment sheet."
				  "Find the square without any visible bands in sets #1 though #4.Select"
				  "the number that corresponds to that square from the list below for all sets.\n\n"
				  "If every square contains a band, select the square with the thinnest bandor bands.\n"
				  "Then click Realignment.") );
		}else if( _navi_info.align_val[TYPE_PATCH_EXT] == 3 ){
			display_message (GTK_TEXT(text),
				_("Look at the alignment sheet."
				  "Find the square without any visible bands in sets #1 though #3.Select"
				  "the number that corresponds to that square from the list below for all sets.\n\n"
				  "If every square contains a band, select the square with the thinnest bandor bands.\n"
				  "Then click Realignment.") );
		}else{
		}
		widget = lookup_widget (top, "retry_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "cancel_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "ok_button");
		gtk_widget_show (widget);

		for (i = 0; i < _navi_info.align_val[TYPE_PATCH_EXT]; i++)
		{
			char label_name[] = "align_label_X";
			char combo_name[] = "align_combo_X";

			set_align_combo (i, 9, 5);

			label_name[12] = '1' + i;
			combo_name[12] = '1' + i;
			widget = lookup_widget (top, label_name);
			gtk_widget_show (widget);
			widget = lookup_widget (top, combo_name);
			gtk_widget_show (widget);
		}
		break;

	case 3:
	case 4: /* realignment */
		_navi_info.npix = 0;

		memcpy (command, command_start, sizeof (command_start));
		nwrite += sizeof (command_start);

		{
			for (i = 0; i < _navi_info.align_val[TYPE_PATCH_EXT]; i++)
			{
				char wname[] = "align_combo_X";
				int val;
				int len;
				int modulo = _navi_info.align_val[TYPE_PATCH_EXT];
				static char align_val[] = {-6,-4,-2,-1,0,1,2,4,6 };
				
				wname[12] = '1' + i;
				widget = lookup_widget (top, wname);
				val = atoi (gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(widget)->entry)));
				/* model depend	*/
				if(_navi_info.ex_bits == NAVI_EX_PMG800 ){
					int j = 0;

					alignment_set_dd[8] = 0x02;
					for( j = 0; j < 3; j++ ){
						/* not checked color */
						alignment_set_dd[5] = i+1;
						alignment_set_dd[6] = j+1;
						if( j == 2 )
 							alignment_set_dd[7] = 0; /* value */
						else
 							alignment_set_dd[7] = align_val[val-1]; /* value */			
						/* write dd command */
						memcpy (command + nwrite, alignment_set_dd, sizeof (alignment_set_dd));
						nwrite += sizeof (alignment_set_dd);
					}
				
					for( j = 0; j < 3; j++ ){
						/* not checked color */
						alignment_set_dd[5] = i+4;
						alignment_set_dd[6] = j+1;
						if( j == 2 )
 							alignment_set_dd[7] = 0; /* value */
						else
 							alignment_set_dd[7] = align_val[val-1]; /* value */			
						/* write dd command */
						memcpy (command + nwrite, alignment_set_dd, sizeof (alignment_set_dd));
						nwrite += sizeof (alignment_set_dd);
					}
				}else{
					/* first dd  */
					len = strlen (_navi_info.align_path[TYPE_PATCH_EXT]) - strlen ("COLOR");
					if (strncmp (_navi_info.align_path[TYPE_PATCH_EXT] + len, "COLOR", strlen ("COLOR"))){
						alignment_set_dd[5] = (i+1)%modulo;
						alignment_set_dd[6] = 0x00;
					}else{
						if(_navi_info.ex_bits == NAVI_EX_PXV600 ){
							/* model depndent color pattern 4/mono patern 5 */
							/* skip first index and ... 			*/
							alignment_set_dd[5] = (i+2)%(modulo+1);
						}else{
							alignment_set_dd[5] = (i+1)%modulo;
						}
						alignment_set_dd[6] = 0x01;
					}
					alignment_set_dd[8] = 0x02;
					alignment_set_dd[7] = align_val[val-1]; /* value */			
					memcpy (command + nwrite, alignment_set_dd, sizeof (alignment_set_dd));
					nwrite += sizeof (alignment_set_dd);

					/* model depend	*/
					if(_navi_info.ex_bits == NAVI_EX_PMG700 ){
						/* second dd */
						alignment_set_dd[5] += 0x10;
						memcpy (command + nwrite, alignment_set_dd, sizeof (alignment_set_dd));
						nwrite += sizeof (alignment_set_dd);
					}
				}
			}
		}
		memcpy (command + nwrite, alignment_save, sizeof (alignment_save));
		nwrite += sizeof (alignment_save);
		memcpy (command + nwrite, alignment_set_end, sizeof (alignment_set_end));
		nwrite += sizeof (alignment_set_end);
		exec_printer (command, nwrite);


		if( page == 4 ){
			/* realignment */
			set_navi_page (1);
			break;
		}

		if (_navi_info.align_val[TYPE_PATCH_EXT_COLOR])
		{
			if ((strlen (_navi_info.align_path[TYPE_PATCH_EXT]) + strlen (".COLOR")) < BUF_SIZE)
			{
				_navi_info.align_val[TYPE_PATCH_EXT] = _navi_info.align_val[TYPE_PATCH_EXT_COLOR];
				strcat (_navi_info.align_path[TYPE_PATCH_EXT], ".COLOR");
				_navi_info.align_val[TYPE_PATCH_EXT_COLOR] = 0;
				set_navi_page (1);
			}
			else
			{
				_navi_info.align_val[TYPE_PATCH_EXT_COLOR] = 0;
				_navi_info.align_val[TYPE_PATCH_EXT] = 0;
			}
		}
		else
		{
			_navi_info.align_val[TYPE_PATCH_EXT] = 0;

		}

		set_navi_page (1);
		break;

	default:
		fprintf (stderr, "error page (%d).\n", page);
		end_navi ();
		break;
	}



};


static void
align_autocut_navi (int page)
{
	GtkWidget *text, *widget;
	GtkWidget *top = _navi_info.top_dialog;

	/*  char message[MSG_SIZE_MAX]; */
	char command[BUF_SIZE];
	int nwrite;
	int i;

	nwrite = 0;
	memset (command, 0, sizeof (command));
	text = lookup_widget (top, "message");

	switch (page)
	{
/*
	case 0:
		_navi_info.npix = 1;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)S1901);
		
		display_message (GTK_TEXT(text),
				 _("This utility adjusts the auto cutter position for cutting paper at the correct position.\n\n"
				   "Use this utility if paper is not cut at the correct position."));
		widget = lookup_widget (top, "cancel_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "next_button");
		gtk_widget_show (widget);
		break;
*/
	case 0:
		_navi_info.npix = 1;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)S1901);

		display_message (GTK_TEXT(text),
				 _("This utility prints a cut position adjustment pattern and then cuts the paper.\n"
				   "Check that the printer cable is connected, and then turn the printer on.\n"
				   "Also, set the EPSON original roll paper to the printer.\n\n"
				   "Click \"Next\" when ready."));
		widget = lookup_widget (top, "cancel_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "next_button");
		gtk_widget_show (widget);
		break;

	case 1:
		_navi_info.npix = 1;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)S1901);

		exec_printer_for_file (_navi_info.align_path[TYPE_AUTOCUT]);

		display_message (GTK_TEXT(text),
				 _("Check the cut roll paper and find the pattern number that is cut at the most correct position of the color border.\n\n"
				   "Select the pattern number from the drop down list and then click \"OK\"."));

		widget = lookup_widget (top, "cancel_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "ok_button");
		gtk_widget_show (widget);

		for (i = 0; i < _navi_info.align_val[TYPE_AUTOCUT]; i++)
		{
			char label_name[] = "align_label_X";
			char combo_name[] = "align_combo_X";

			set_align_combo (i, 17, 9);

			label_name[12] = '1' + i;
			combo_name[12] = '1' + i;
			widget = lookup_widget (top, label_name);
			gtk_widget_show (widget);
			widget = lookup_widget (top, combo_name);
			gtk_widget_show (widget);
		}
		break;

	case 2:
		_navi_info.npix = 0;

		memcpy (command, command_start, sizeof (command_start));
		nwrite += sizeof (command_start);
      
		for (i = 0; i < _navi_info.align_val[TYPE_AUTOCUT]; i++)
		{
			char wname[] = "align_combo_X";
			int val;

			wname[12] = '1' + i;
			widget = lookup_widget (top, wname);
			val = atoi (gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(widget)->entry)));

			assert (_navi_info.cut_dd != NULL);
			assert (_navi_info.cut_dd[i].bid_id != 0xff);
			alignment_set_dd[5] = _navi_info.cut_dd[i].bid_id;
			alignment_set_dd[6] = _navi_info.cut_dd[i].color;
			alignment_set_dd[7] = (char)((9 - val) * 8) & 0xff;
			alignment_set_dd[8] = _navi_info.cut_dd[i].unit;
			memcpy (command + nwrite, alignment_set_dd, sizeof (alignment_set_dd));
			nwrite += sizeof (alignment_set_dd);
		}
		memcpy (command + nwrite, alignment_save, sizeof (alignment_save));
		nwrite += sizeof (alignment_save);
		memcpy (command + nwrite, alignment_set_end, sizeof (alignment_set_end));
		nwrite += sizeof (alignment_set_end);
		exec_printer (command, nwrite);

		_navi_info.align_val[TYPE_AUTOCUT] = 0;
		set_navi_page (0);
		break;

	case 3:
		_navi_info.npix = 0;

		_navi_info.align_val[TYPE_AUTOCUT] = 0;
		set_navi_page (0);
		break;

	default:
		fprintf (stderr, "error page (%d).\n", page);
		end_navi ();
		break;
	}
	return;
};


static void
set_align_combo (int number, int list, int val)
{
	GtkWidget* top = _navi_info.top_dialog;
	GtkWidget* widget;
	GList* combo_items = NULL;
	char numlist[][3] = { "1", "2", "3", "4", "5", "6", "7", "8", "9", "10",
			      "11", "12", "13", "14", "15", "16", "17" };
	char combo_name[] = "align_combo_X";
	char numstr[3];
	int i;

	combo_name[12] = '1' + number;
	widget = lookup_widget (top, combo_name);

	for (i = 0; i < list; i++)
		combo_items = g_list_append (combo_items, _(numlist[i]));
	gtk_combo_set_popdown_strings (GTK_COMBO (widget), combo_items);
	g_list_free (combo_items);

	memset (numstr, 0, 3);
	sprintf (numstr, "%d", val);
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (widget)->entry), _(numstr));
}

static void
exec_printer (char *command, int size)
{
	FILE *fp;

#if DEBUG
	int i;

	fprintf(stderr, "[Command Dump]\n");
	for (i = 0; i < size; i++) {
		fprintf(stderr, "%02x", (unsigned char)command[i]);
		if ((i + 1) % 16) {
			fprintf(stderr, " ");
		} else {
			fprintf(stderr, "\n");
		}
	}
	fprintf(stderr, "\n\n");
#endif

	fp = popen (_navi_info.printer, "w");
	/*    fp = popen (SPOOLER_PATH, "w"); */
	fwrite (command, size, 1, fp);
	pclose (fp);
	return;
}


static void
exec_printer_for_file (char* path)
{
	char syscommand[256];

	sprintf (syscommand, "%s %s", _navi_info.printer, path);
	system (syscommand);

	return;
}

void
init_cartridge (int ink_select)
{
	_navi_info.ink_select = ink_select;
	return;
}


static void
cartridge_navi (int page)
{
	GtkWidget *text, *widget;
	GtkWidget *top = _navi_info.top_dialog;

	text = lookup_widget (top, "message");

	if (page == 0)
	{
		get_printer_status ("INIT");
		_navi_info.npix = 1;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[1], NULL, (gchar**)R01B01);
      
		display_message (GTK_TEXT(text),
				 _("This utility guides you through replacing an old or damaged ink cartridge.\n"
				   "Click the button for the ink cartridge you want to replace.\n"
				   "If the ink cartridge is not empty and your printout is fine, you can continue using the cartridge until an alert message instructs you to replace it.\n"
				   "Click Cancel to exit this utility."));
		widget = lookup_widget (top, "cancel_button");
		gtk_widget_show (widget);

		if (_navi_info.status == 8 || _navi_info.ink_select == INK_ALL)
		{
			init_cartridge (INK_ALL);
			widget = lookup_widget (top, "next_button");
			gtk_widget_show (widget);
		}
		else
		{
			widget = lookup_widget (top, "ink_black_button");
			gtk_widget_show (widget);
			widget = lookup_widget (top, "ink_color_button");
			gtk_widget_show (widget);
		}
	}

	else
	{
		if (page == 1)
		{
			if (_navi_info.status != 4 && (_navi_info.status == 0 && _navi_info.error != 5))
			{
				GtkWidget *widget;
	      
				set_navi_page (0);
				widget = CREATE_MSG_NO_IDLE;
				gtk_widget_show (widget);
				end_navi ();
				return;
			}
		}

		switch (_navi_info.ink_select)
		{
		case INK_BLACK:
			black_cartridge (page);
			break;

		case INK_COLOR:
			color_cartridge (page);
			break;

		case INK_ALL:
			all_cartridge (page);
			break;
		}
	}
	return;
}


static void
black_cartridge (int page)
{
	GtkWidget *text, *widget;
	GtkWidget *top = _navi_info.top_dialog;
	int nwrite;

	text = lookup_widget (top, "message");

	switch (page)
	{
	case 1:
		_navi_info.npix = 3;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)R0201);
		_navi_info.pixmap[1] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[1], NULL, (gchar**)R0202);
		_navi_info.pixmap[2] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[2], NULL, (gchar**)R0203);

		ink_move[4] = 0x03;
		nwrite = sizeof (ink_move);
		sock_write_abandon_reply (ink_move, &nwrite);

		display_message (GTK_TEXT(text),
				 _("Open the printer cover."));
		widget = lookup_widget (top, "next_button");
		gtk_widget_show (widget);
		break;

	case 2:
		all_cartridge (2);
		break;

	case 3:
		all_cartridge (3);
		break;

	case 4:
		all_cartridge (4);
		_navi_info.npix = 5;
		_navi_info.pixmap[3] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[3], NULL, (gchar**)R0904);
		_navi_info.pixmap[4] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[4], NULL, (gchar**)R0905);
		break;

	case 5:
		all_cartridge (9);
		gdk_pixmap_unref(_navi_info.pixmap[0]);
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)R01K01);
		break;

	case 6:
		all_cartridge (10);
		break;
      
	case 7:
		all_cartridge (11);
		break;
      
	default:
		fprintf (stderr, "error page (%d).\n", page);
		end_navi ();
		break;
	}
}

static void
color_cartridge (int page)
{
	GtkWidget *text, *widget;
	GtkWidget *top = _navi_info.top_dialog;
	int nwrite;

	text = lookup_widget (top, "message");

	switch (page)
	{
	case 1:
		_navi_info.npix = 3;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)R0201);
		_navi_info.pixmap[1] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[1], NULL, (gchar**)R0202);
		_navi_info.pixmap[2] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[2], NULL, (gchar**)R0203);
		ink_move[4] = 0x04;
		nwrite = sizeof (ink_move);
		sock_write_abandon_reply (ink_move, &nwrite);

		display_message (GTK_TEXT(text),
				 _("Open the printer cover."));
		widget = lookup_widget (top, "next_button");
		gtk_widget_show (widget);
		break;

	case 2:
		all_cartridge (6);
		break;

	case 3:
		all_cartridge (7);
		break;

	case 4:
		all_cartridge (8);
		break;

	case 5:
		all_cartridge (9);
		gdk_pixmap_unref(_navi_info.pixmap[0]);
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)R01C01);
		break;

	case 6:
		all_cartridge (10);
		break;

	case 7:
		all_cartridge (11);
		break;
      
	default:
		fprintf (stderr, "error page (%d).\n", page);
		end_navi ();
		break;
	}
}

static void
all_cartridge (int page)
{
	GtkWidget *text, *widget;
	GtkWidget *top = _navi_info.top_dialog;
	int nwrite;

	text = lookup_widget (top, "message");

	switch (page)
	{
	case 1:
		_navi_info.npix = 3;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)R0201);
		_navi_info.pixmap[1] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[1], NULL, (gchar**)R0202);
		_navi_info.pixmap[2] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[2], NULL, (gchar**)R0203);

		ink_move[4] = 0x03;
		nwrite = sizeof (ink_move);
		sock_write_abandon_reply (ink_move, &nwrite);

		display_message (GTK_TEXT(text),
				 _("Open the printer cover."));
		widget = lookup_widget (top, "next_button");
		gtk_widget_show (widget);
		break;

	case 2:
		_navi_info.npix = 3;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)R0301);
		_navi_info.pixmap[1] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[1], NULL, (gchar**)R0302);
		_navi_info.pixmap[2] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[2], NULL, (gchar**)R0303);

		display_message (GTK_TEXT(text),
				 _("Lift up the clamp over the black ink cartridge as far as it will go.\n"
				   "The cartridge rises partly out of the cartridge holder.\n"
				   "Lift the cartridge out of the printer and dispose of it properly.\n"
				   "Do not take the used cartridge apart or try to refill it."));
		widget = lookup_widget (top, "next_button");
		gtk_widget_show (widget);
		break;

	case 3:
		_navi_info.npix = 4;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)R0401);
		_navi_info.pixmap[1] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[1], NULL, (gchar**)R0402);
		_navi_info.pixmap[2] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[2], NULL, (gchar**)R0403);
		_navi_info.pixmap[3] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[3], NULL, (gchar**)R0404);

		display_message (GTK_TEXT(text),
				 _("Remove a new black ink cartridge from its package.\n"
				   "Remove the yellow tape seal from the cartridge."));
		widget = lookup_widget (top, "prev_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "next_button");
		gtk_widget_show (widget);
		break;

	case 4:
		_navi_info.npix = 4;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)R0501);
		_navi_info.pixmap[1] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[1], NULL, (gchar**)R0502);
		_navi_info.pixmap[2] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[2], NULL, (gchar**)R0503);
		_navi_info.pixmap[3] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[3], NULL, (gchar**)R0504);

		display_message (GTK_TEXT(text),
				 _("Place the cartridge, with its blue label facing up, into the cartridge holder.\n"
				   "Push the ink cartridge clamp down until it locks into place.\n"
				   "Click OK to start ink charging."));
		widget = lookup_widget (top, "cancel_button");
		gtk_widget_show (widget);

		widget = lookup_widget (top, "ok_button");
		gtk_widget_show (widget);
		break;

	case 5:
		ink_move[4] = 0x80;
		nwrite = sizeof (ink_move);
		sock_write_abandon_reply (ink_move, &nwrite);
		sleep (5);

		ink_move[4] = 0x04;
		nwrite = sizeof (ink_move);
		sock_write_abandon_reply (ink_move, &nwrite);
		set_navi_page (6);
		break;

		/*
		 * 6-8 Color ink cartridge
		 */
	case 6:
		_navi_info.npix = 3;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)R0701);
		_navi_info.pixmap[1] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[1], NULL, (gchar**)R0702);
		_navi_info.pixmap[2] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[2], NULL, (gchar**)R0703);

		display_message (GTK_TEXT(text),
				 _("Lift up the clamp over the color ink cartridge as far as it will go.\n"
				   "The cartridge rises partly out of the cartridge holder.\n"
				   "Lift the cartridge out of the printer and dispose of it properly.\n"
				   "Do not take the used cartridge apart or try to refill it."));
		widget = lookup_widget (top, "next_button");
		gtk_widget_show (widget);
		break;

	case 7:
		_navi_info.npix = 4;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)R0801);
		_navi_info.pixmap[1] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[1], NULL, (gchar**)R0802);
		_navi_info.pixmap[2] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[2], NULL, (gchar**)R0803);
		_navi_info.pixmap[3] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[3], NULL, (gchar**)R0804);

		display_message (GTK_TEXT(text),
				 _("Remove a new color ink cartridge from its package.\n"
				   "Remove the yellow tape seal from the cartridge."));
		widget = lookup_widget (top, "prev_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "next_button");
		gtk_widget_show (widget);
		break;

	case 8:
		_navi_info.npix = 5;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)R0901);
		_navi_info.pixmap[1] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[1], NULL, (gchar**)R0902);
		_navi_info.pixmap[2] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[2], NULL, (gchar**)R0903);
		_navi_info.pixmap[3] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[3], NULL, (gchar**)R0904);
		_navi_info.pixmap[4] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[4], NULL, (gchar**)R0905);

		display_message (GTK_TEXT(text),
				 _("Place the cartridge, with its blue label facing up, into the cartridge holder.\n"
				   "Push the ink cartridge clamp down until it locks into place.\n"
				   "Click OK to start ink charging."));
		widget = lookup_widget (top, "cancel_button");
		gtk_widget_show (widget);
		widget = lookup_widget (top, "ok_button");
		gtk_widget_show (widget);
		break;

		/*
		 * 9-11 Ink charge
		 */
	case 9:
		_navi_info.npix = 1;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)R01B01);

		ink_move[4] = 0x80;
		nwrite = sizeof (ink_move);
		sock_write_abandon_reply (ink_move, &nwrite);
		display_message (GTK_TEXT(text), _("Please wait."));

		_navi_info.wait_timer = gtk_timeout_add (1000, wait_set_cartridge, NULL);

		sleep (5);
		break;

	case 10:
		_navi_info.npix = 1;
		_navi_info.pixmap[0] = gdk_pixmap_create_from_xpm_d (top->window, &_navi_info.mask[0], NULL, (gchar**)R1001);

		display_message (GTK_TEXT(text),
				 _("Ink charging in progress. Please wait."));

		_navi_info.wait_timer = gtk_timeout_add (1000, wait_charge, NULL);
		break;
      
	case 11:
		nwrite = sizeof (ink_end);
		sock_write_abandon_reply (ink_end, &nwrite);
		end_navi ();
		break;

	default:
		fprintf (stderr, "error page (%d).\n", page);
		end_navi ();
		break;
	}
	return;

}


static int
wait_set_cartridge (void* data)
{
	char buf[BUF_SIZE];
	int nwrite, nread;
  
	memset (buf, 0, BUF_SIZE);
  
	nwrite = sizeof (ink_position);
	sock_write (ink_position, &nwrite);
	nread = BUF_SIZE;
	sock_read (buf, &nread);

	if (strncmp (buf, "cx:00", 5) == 0)
	{
		if (_navi_info.status == 0 && _navi_info.error == 5)
		{
			GtkWidget* widget;
			int page;

			if (_navi_info.ink_select == INK_BLACK)
			{
				widget = CREATE_MSG_NO_BLACK;
				gtk_widget_show (widget);
				page = get_navi_page ();
				set_navi_page (page - 4);
			}
			else if (_navi_info.ink_select == INK_COLOR)
			{
				widget = CREATE_MSG_NO_COLOR;
				gtk_widget_show (widget);
				page = get_navi_page ();
				set_navi_page (page - 4);
			}
			if (_navi_info.ink_select == INK_ALL)
			{
				widget = CREATE_MSG_NO_INKALL;
				gtk_widget_show (widget);
				set_navi_page (1);
			}
			return 0;
		}
	}
	else if (_navi_info.status == 7)
	{
		int page;

		page = get_navi_page ();
		set_navi_page (page + 1); 
		return 0;
	}

	return 1;
}
  
  
static int
wait_charge (void* data)
{
	if (_navi_info.status != 7)
	{
		int page;

		page = get_navi_page ();
		set_navi_page (page + 1);
		return 0;
	}
	return 1;
}


static void
all_hide (GtkWidget *top)
{
	GtkWidget *widget;

	widget = lookup_widget (top, "align_label_1");
	gtk_widget_hide (widget);

	widget = lookup_widget (top, "align_label_2");
	gtk_widget_hide (widget);

	widget = lookup_widget (top, "align_label_3");
	gtk_widget_hide (widget);

	widget = lookup_widget (top, "align_label_4");
	gtk_widget_hide (widget);

	widget = lookup_widget (top, "align_label_5");
	gtk_widget_hide (widget);

	widget = lookup_widget (top, "align_combo_1");
	gtk_widget_hide (widget);

	widget = lookup_widget (top, "align_combo_2");
	gtk_widget_hide (widget);

	widget = lookup_widget (top, "align_combo_3");
	gtk_widget_hide (widget);

	widget = lookup_widget (top, "align_combo_4");
	gtk_widget_hide (widget);

	widget = lookup_widget (top, "align_combo_5");
	gtk_widget_hide (widget);

	widget = lookup_widget (top, "cancel_button");
	gtk_widget_hide (widget);

	widget = lookup_widget (top, "prev_button");
	gtk_widget_hide (widget);

	widget = lookup_widget (top, "ink_black_button");
	gtk_widget_hide (widget);

	widget = lookup_widget (top, "ink_color_button");
	gtk_widget_hide (widget);

	widget = lookup_widget (top, "retry_button");
	gtk_widget_hide (widget);

	widget = lookup_widget (top, "next_button");
	gtk_widget_hide (widget);

	widget = lookup_widget (top, "ok_button");
	gtk_widget_hide (widget);

	return;
}


static int
get_printer_status (void* data)
{
	char buf[BUF_SIZE];
	int nwrite, nread;
	char* point;
  
	memset (buf, 0, BUF_SIZE);

	nwrite = sizeof (get_st_com);
	sock_write (get_st_com, &nwrite);

	nread = BUF_SIZE;
	sock_read (buf, &nread);

	point = strstr (buf, "ST:");
	if (point == NULL && data == NULL)
	{
		GtkWidget* widget;

		widget = CREATE_MSG_NO_CONNECT;
		gtk_widget_show (widget);
		end_navi ();
		return 0;
	}

	if (point)
	{
		char st[3];
      
		memset (st, 0, 3);
		strncpy(st, point + 3, 2);
		_navi_info.status = atoi (st);
	}

	point = strstr (buf, "ER:");
	if (point)
	{
		char er[3];

		memset (er, 0, 3);
		strncpy(er, point + 3, 2);
		_navi_info.error = atoi (er);
	}

	if(_navi_info.npix > 1)
	{
		GtkWidget* widget;

		_navi_info.cpix ++;
		if(_navi_info.cpix >= _navi_info.npix)
			_navi_info.cpix = 0;

		widget = lookup_widget (_navi_info.top_dialog, "st_pix");
		gtk_pixmap_set(GTK_PIXMAP(widget),
			       _navi_info.pixmap[_navi_info.cpix],
			       _navi_info.mask[_navi_info.cpix]);
	}
	return 1;
}


/* BOX˾ܺپɽ                                           */
static void
display_message (GtkText *text, char *info)
{
	/* ֤Ƭˤ */
	gtk_text_set_point (text, 0);
  
  /* ξɽ򥯥ꥢ */
  /*  gtk_text_forward_delete(text, -1); */
	gtk_text_forward_delete (text, gtk_text_get_length (text));
  
	/* ܺپɽ */
	gtk_text_insert (text, NULL, NULL, NULL, info, -1);
  
	/* ưƬ᤹ᡢƬ֤˥ߡʸƺ */
	gtk_text_set_point (text, 0);
	gtk_text_insert (text, NULL, NULL, NULL, " ", -1);
	gtk_text_backward_delete (text, 1);
	return;
}
