# Copyright (C) SEIKO EPSON CORPORATION 2004.

%define PREFIX /usr
%define BINDIR %{PREFIX}/bin
%define ETCDIR /etc
%define VARDIR /var
%define LIBDIR %{PREFIX}/lib
%define KOWADIR %{PREFIX}/local/EPKowa
%define DEAMONDIR %{KOWADIR}/printer
%define DATADIR %{KOWADIR}/PXV500
%define LOCALEDIR %{PREFIX}/share/locale

%define CUPS_SERVER_DIR %{PREFIX}/lib/cups
%define CUPS_DATA_DIR %{PREFIX}/share/cups

Summary: Photo Image Print System for EPSON PX-V500 (i386)
Summary(ja): EPSON PX-V500 ѤPhoto Image Print System (i386)
Name: pipsv500
Version: 2.6.2
Release: 2
Copyright: Copyright (C) 2000-2004 EPSON KOWA Corporation. / Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
Group: System/Printer
Source0: %{name}-%{version}.tar.gz
Packager: EPSON KOWA Corporation
Vendor: EPSON KOWA Corporation <http://www.epkowa.co.jp/>
BuildRoot: /var/tmp/%{name}-%{version}

%description

%prep
[ "${RPM_BUILD_ROOT}" != "/" ] && rm -rf ${RPM_BUILD_ROOT}

%setup
./configure --prefix=/usr

%build
make CFLAGS="-g -O2" CXXFLAGS="-g -O2"

%install
make install-strip DESTDIR=${RPM_BUILD_ROOT}

%post
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi

DESTDIR=${RPM_BUILD_ROOT} %{DATADIR}/scripts/inst-lpr-post.sh install
ln -fs %{DATADIR}/scripts/setup-lpr.sh %{DATADIR}/setup

%preun
if [ "$1" = 0 ] ; then
	DESTDIR=${RPM_BUILD_ROOT} %{DATADIR}/scripts/inst-lpr-post.sh deinstall
	rm -f %{DATADIR}/setup
fi

%postun
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi

if [ "$1" = 0 ] ; then
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{DATADIR}/scripts
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{DATADIR}/rc.d
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{DATADIR}
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{DEAMONDIR}
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{KOWADIR}
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}/var/ekpd
fi

%files
%defattr(-,root,root)

%{BINDIR}/pipsv500
%{BINDIR}/ekpstm
%{LIBDIR}/libpxv500.so
#Delected
%{DEAMONDIR}/ekpd
%{DEAMONDIR}/gsconfig
%{DEAMONDIR}/dtrfilter
%{DEAMONDIR}/freset
%{DEAMONDIR}/paper_list.csv
%{DATADIR}/filterv500
%{ETCDIR}/ekpdrc
%{VARDIR}/ekpd/ekplp0
%{DATADIR}/readmev500
%{DATADIR}/libpxv500.readme
%{BINDIR}/ekpnavi
%{DATADIR}/scripts/inst-lpr-post.sh
%{DATADIR}/lang

%{LOCALEDIR}/ja/LC_MESSAGES/pipsv500.mo
%{LOCALEDIR}/de/LC_MESSAGES/pipsv500.mo
%{LOCALEDIR}/es/LC_MESSAGES/pipsv500.mo
%{LOCALEDIR}/fr/LC_MESSAGES/pipsv500.mo
%{LOCALEDIR}/it/LC_MESSAGES/pipsv500.mo
%{LOCALEDIR}/nl/LC_MESSAGES/pipsv500.mo
%{LOCALEDIR}/pt/LC_MESSAGES/pipsv500.mo
%{LOCALEDIR}/ko/LC_MESSAGES/pipsv500.mo
%{LOCALEDIR}/zh/LC_MESSAGES/pipsv500.mo
%{LOCALEDIR}/zh_TW/LC_MESSAGES/pipsv500.mo

%{DATADIR}/scripts/setup-lpr.sh
%{DATADIR}/scripts/en.lc
%{DATADIR}/scripts/ja.lc

%{DATADIR}/inst-rc_d.sh
%{DATADIR}/rc.d/ekpd.redhat
%{DATADIR}/rc.d/ekpd.debian
%{DATADIR}/rc.d/ekpd.slackware
%{DATADIR}/rc.d/ekpd.local.slackware

%{DATADIR}/BAND.PRN
%{DATADIR}/BAND.PRN.COLOR
%{DATADIR}/PATCH.PRN
%{DATADIR}/PATCH.PRN.COLOR

%doc AUTHORS
%doc README
%doc COPYING
%doc COPYING.LIB
%doc COPYING.KOWA
%doc COPYING.KOWA.ja
%doc ChangeLog


%package -n pipsv500-cups
Summary: Photo Image Print System for EPSON PX-V500 - CUPS version (i386)
Summary(ja): EPSON PX-V500 Ѥ Photo Image Print System - CUPSб (i386)
Group: System/Printer

#uncomment to remove dependency checks
AutoReqProv:   no
# Kondara requires
Requires: ld-linux.so.2
Requires: libX11.so.6
Requires: libXext.so.6
Requires: libXi.so.6
Requires: libc.so.6
Requires: libc.so.6(GLIBC_2.0)
Requires: libc.so.6(GLIBC_2.1)
Requires: libc.so.6(GLIBC_2.1.3)
#Requires: libcrypt.so.1
#Requires: libcrypto.so.0.9.6
Requires: libcups.so.2
Requires: libcupsimage.so.2
Requires: libdl.so.2
Requires: libdl.so.2(GLIBC_2.0)
Requires: libdl.so.2(GLIBC_2.1)
Requires: libgdk-1.2.so.0
Requires: libglib-1.2.so.0
Requires: libgmodule-1.2.so.0
Requires: libgtk-1.2.so.0
Requires: libjpeg.so.62
Requires: libm.so.6
Requires: libnsl.so.1
Requires: libpng.so.3
Requires: libpthread.so.0
Requires: libpthread.so.0(GLIBC_2.0)
Requires: libpthread.so.0(GLIBC_2.1)
#Requires: libssl.so.0.9.6
Requires: libtiff.so.3
Requires: libz.so.1

%description -n pipsv500-cups

%post -n pipsv500-cups
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi

DESTDIR=${RPM_BUILD_ROOT} %{DATADIR}/scripts/inst-cups-post.sh install
ln -fs %{DATADIR}/scripts/setup-cups.sh %{DATADIR}/setup

%preun -n pipsv500-cups
if [ "$1" = 0 ] ; then
	DESTDIR=${RPM_BUILD_ROOT} %{DATADIR}/scripts/inst-cups-post.sh deinstall
	rm -f %{DATADIR}/setup
fi

%postun -n pipsv500-cups
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi

if [ "$1" = 0 ] ; then
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{DATADIR}/scripts
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{DATADIR}/rc.d
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{DATADIR}
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{DEAMONDIR}
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{KOWADIR}
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}/var/ekpd
fi

%files -n pipsv500-cups
%defattr(-,root,root)

%{CUPS_SERVER_DIR}/filter/rastertopips
%{CUPS_SERVER_DIR}/filter/pipstoprinter
%{CUPS_SERVER_DIR}/backend/ekplp
%{CUPS_DATA_DIR}/model/ekpxv500.ppd
%{LIBDIR}/libpxv500.so
#Deleted
%{BINDIR}/ekpstm

%{DEAMONDIR}/ekpd
%{DEAMONDIR}/paper_list.csv
%{ETCDIR}/ekpdrc
%{VARDIR}/ekpd/ekplp0
%{DATADIR}/cupsopt.csv
%{DATADIR}/readmev500-cups
%{DATADIR}/libpxv500.readme
%{DATADIR}/scripts/inst-cups-post.sh

%{LOCALEDIR}/ja/LC_MESSAGES/pipsv500.mo
%{LOCALEDIR}/de/LC_MESSAGES/pipsv500.mo
%{LOCALEDIR}/es/LC_MESSAGES/pipsv500.mo
%{LOCALEDIR}/fr/LC_MESSAGES/pipsv500.mo
%{LOCALEDIR}/it/LC_MESSAGES/pipsv500.mo
%{LOCALEDIR}/nl/LC_MESSAGES/pipsv500.mo
%{LOCALEDIR}/pt/LC_MESSAGES/pipsv500.mo
%{LOCALEDIR}/ko/LC_MESSAGES/pipsv500.mo
%{LOCALEDIR}/zh/LC_MESSAGES/pipsv500.mo
%{LOCALEDIR}/zh_TW/LC_MESSAGES/pipsv500.mo

%{DATADIR}/scripts/setup-cups.sh
%{DATADIR}/scripts/en.lc
%{DATADIR}/scripts/ja.lc

%{DATADIR}/inst-rc_d.sh
%{DATADIR}/rc.d/ekpd.redhat
%{DATADIR}/rc.d/ekpd.debian
%{DATADIR}/rc.d/ekpd.slackware
%{DATADIR}/rc.d/ekpd.local.slackware

%doc AUTHORS
%doc README
%doc COPYING
%doc COPYING.LIB
%doc COPYING.KOWA
%doc COPYING.KOWA.ja
%doc ChangeLog
