#!/bin/sh
# 
# Photo Image Print System
# Copyright (C) 2001-2004 EPSON KOWA Corporation.
# Copyright (C) SEIKO EPSON CORPORATION 2001-2004.
# 
#  This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# 
PKG_PATH=/usr/local/EPKowa/PXV500
PRT_MODEL=PXV500
SCRIPT_PATH=$PKG_PATH/scripts
RC_D_PATH=$PKG_PATH/rc.d
PRT_MODEL_LOW=`echo $PRT_MODEL | tr '[A-Z]' '[a-z]'`

if [ -s /etc/ekpdrc ]; then
    DEF_PRT_NAME=`grep PrinterName /etc/ekpdrc | sed -e 's/ //g' -e 's/^.*=//' -e 's/#.*$//'`
    if [ -z $DEF_PRT_NAME ]; then
	DEF_PRT_NAME=$PRT_MODEL_LOW
    fi

    DEF_PRT_PATH=`grep PrinterDevicePath /etc/ekpdrc | sed -e 's/ //g' -e 's/^.*=//' -e 's/#.*$//'`
    if [ -z $DEF_PRT_PATH ]; then
	DEF_PRT_PATH=/dev/lp0
    fi
fi

. $SCRIPT_PATH/en.lc

trap 'echo; printf "$F_TXT"
    exit 1' 0

ID=`id | sed -e 's/uid=//' -e 's/(.*//'`

if [ $ID -ne 0 ]; then
    echo must run as root.
    exit 0;
fi

echo "-----------------------------------------------"
echo ""
echo "           Photo Image Print System"
echo ""
echo "                 Setup script"
echo ""
echo "-----------------------------------------------"

echo Please select locale to use.
echo Select : en ja #de es fr it ko nl pt zh zh_TW
echo -n '(english) > '

read SET_LANG
case $SET_LANG in
#    [Dd][Ee] ) . $SCRIPT_PATH/de.lc ;;
#    [Ee][Ss] ) . $SCRIPT_PATH/es.lc ;;
#    [Ff][Rr] ) . $SCRIPT_PATH/fr.lc ;;
#    [Ii][Tt] ) . $SCRIPT_PATH/it.lc ;;
    [Jj][Aa] ) . $SCRIPT_PATH/ja.lc ;;
#    [Kk][Oo] ) . $SCRIPT_PATH/ko.lc ;;
#    [Nn][Ll] ) . $SCRIPT_PATH/nl.lc ;;
#    [Pp][Tt] ) . $SCRIPT_PATH/pt.lc ;;
#    [Zz][Hh] ) . $SCRIPT_PATH/zh.lc ;;
#    [Zz][Hh]_[Tt][Ww] ) . $SCRIPT_PATH/zh_TW.lc ;;
    *);;
esac

printf "$A_TXT"
echo

while :
do
    printf "$B_TXT"
    echo -n "($DEF_PRT_PATH) > "
    
    read PRT_PATH

    if [ -z $PRT_PATH ]; then
	PRT_PATH=$DEF_PRT_PATH
    fi

    if [ -n $PRT_PATH -a -r $PRT_PATH -a -w $PRT_PATH ]; then
	break;
    fi
    echo "$PRT_PATH : No such file or directory."
done

while :
do
    printf "$C_TXT"
    echo -n "($DEF_PRT_NAME) > "
    
    read PRT_NAME

    if [ -x $PRT_NAME ]; then
	PRT_NAME=$DEF_PRT_NAME
    fi

    if [ -n $PRT_NAME ]; then
	break;
    fi
done

while :
do
    printf "$D_TXT"
    echo -n '(Yes/no) > '

    read ANSWER
    case $ANSWER in
	[Yy] | [Yy]es | YES ) break ;;
	[Nn] | [Nn]o | NO ) exit 0 ;;
	* ) echo ? ;;
    esac
done

trap 0
printf "$E1_TXT"
echo $PRT_NAME
printf "$E2_TXT"

#/etc/ekpdrc
if [ -s /etc/ekpdrc ]; then
    cp /etc/ekpdrc /etc/ekpdrc.bak
fi

cat <<EOF >/etc/ekpdrc
PrinterName = $PRT_NAME
PrinterDevicePath = $PRT_PATH
DummyDevicePath = /var/ekpd/ekplp0
CommandServerPort = 35586
EOF


# printer reset
DIST=`$PKG_PATH/inst-rc_d.sh checkdist`
$RC_D_PATH/ekpd.$DIST restart 2>&1 1>/dev/null

exit 0
