/*
 * Photo Image Print System
 * Copyright (C) SEIKO EPSON CORPORATION 2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifndef __PAPER_RSC__
#define __PAPER_RSC__

#include <string.h>
#include "paper.h"
#define LIST_END { NULL, -1, -1, -1, -1, -1, -1 }

/* 20mm Margin Paper : PX-V500ǻѤѻ極Τ߹ */

/* ASF */
PAPER_CONF paper_auto[] = {
/* A4 210 x 297 mm */             { "A4",      2976,   4209,   2892,   3884,   42,     42 },
/* B5 182 x 257 mm */             { "B5",      2580,   3643,   2496,   3318,   42,     42 },
/* A5 148 x 210 mm */             { "A5",      2098,   2976,   2014,   2651,   42,     42 },
/* A6 105 x 148 mm */             { "A6",      1488,   2098,   1404,   1773,   42,     42 },
/* ϥ 100 x 148 mm */         { "PC",      1417,   2098,   1333,   1773,   42,     42 },
/* ϥ 200 x 148 mm */     { "DPC",     2835,   2098,   2751,   1773,   42,     42 },
/* LȽ 89 x 127 mm */             { "L",       1260,   1800,   1176,   1475,   42,     42 },
/* 2LȽ 127 x 178 mm */           { "2L",      1800,   2522,   1716,   2197,   42,     42 },
/* Ĺ3 120 x 235 mm */    { "ENVC3",   1701,   3685,   1617,   3006,   42,    396 },
/* Ĺ4 90 x 205 mm */     { "ENVC4",   1276,   3161,   1192,   2581,   42,    297 },
/* η1 120 x 176 mm */    { "ENVY1",   1701,   2494,   1617,   2169,   42,     42 },
/* η2 114 x 162 mm */    { "ENVY2",   1616,   2296,   1532,   1971,   42,     42 },
/* η3 98 x 148 mm */     { "ENVY3",   1389,   2098,   1305,   1773,   42,     42 },
/* η4 105 x 235 mm */    { "ENVY4",   1488,   3331,   1404,   3006,   42,     42 },
/* Letter 8 1/2 x 11 in */        { "LT",      3060,   3960,   2976,   3635,   42,     42 },
/* Legal 8 1/2 x 14 in */         { "LGL",     3060,   5040,   2976,   4715,   42,     42 },
                                  LIST_END
};

/* Roll */                                                      
PAPER_CONF paper_roll[] = {
                                  LIST_END
};

/* Roll (trim) */
PAPER_CONF paper_roll_trim[] = {
                                  LIST_END
};

/* ASF (trim) */
PAPER_CONF paper_auto_trim[] = {
                                  LIST_END
};

/*  ASF (No Margin) */
PAPER_CONF paper_auto_trim_4[] = {
/* A4 210 x 297 mm */             { "A4",      2976,   4209,   3047,   4322,    0,      0 },
/* ϥ 100 x 148 mm */         { "PC",      1417,   2098,   1488,   2211,    0,      0 },
/* LȽ 89 x 127 mm */             { "L",       1261,   1800,   1332,   1913,    0,      0 },
/* 2LȽ 127 x 178 mm */           { "2L",      1800,   2522,   1871,   2635,    0,      0 },
                                  LIST_END
};

#endif /* __PAPER_RSC__ */
