/*
 * Photo Image Print System
 * Copyright (C) SEIKO EPSON CORPORATION 2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef __OPT_RSC__
#define __OPT_RSC__

#include "pipsDef.h"


/* Inset Defult */
#define	PIPS_INKSET_DEFAULT PIPS_INKSET_CMYK

#ifndef	_ONLY_NEED_DEFAULT_

/* Option Entry */
char *inkEntry[] = {
        "COLOR", "MONO",
        NULL
};

char *binEntry[] = {
        "AUTO", "T4AUTO",
        NULL
};

/* ASF */
char *mediaSizeEntry[] = {
        "A4",       "B5",      "A5",     "A6",
        "PC",       "DPC",     "L",      "2L", 
        "ENVC3",    "ENVC4",   "ENVY1",  "ENVY2", 
        "ENVY3",    "ENVY4",   "LT",     "LGL",
        NULL
};

/* ROLL */
char *mediaSizeEntry_R[] = {
        NULL
};

/* ROLL-Banner */
char *mediaSizeEntry_TR[] = {
        NULL
};

/* ASF-No Margin  */
char *mediaSizeEntry_NMA[] = {
	"A4", "PC", "L", "2L", 
 	NULL
};


char *resolutionEntry[] = {
        "120", "360", "720",
        NULL
};

// new media type PLAIN_SPEED 
char *mediaTypeEntry[] = {
        "PLAIN", "PLAIN_SPEED", "RPPC",  "IJPC", "ESF", "EPM", "ERC_S", "EGPP",
        NULL
};

char *colorModeEntry[] = {
       "PHOTO", "GRAPH", "NONE",
        NULL
};

char *halftoneEntry[] = {
        "ED",
        NULL
};

char *levelEntry[] = {
        "DRAFT", "STD","FINE", "SFINE", "PHOTO", "SPHOTO",
        NULL
};

char *multiPageEntry[] = {
        "1", "2", "4",
        NULL
};

char *autoCutEntry[] = {
        "NONE",
        NULL
};


/* pModeCol     :       Color
   pModeMono    :       Monochrome

   MediaNumber  :       see pipsDef.h
   Input        :       1:120/180, 2:360, 4:720
   Halftone     :       <or> 1:ED 2:DB
   MicroWave    :       0:OFF 1:ON 2:ON/OFF
   HighSpeed    :       0:OFF 1:ON 2:ON/OFF
   Quality      :       0xXXX
                          ||+---- at Input 1
                          |+----- at Input 2
                          +------ at Input 4

*/
short pModeCol[] = {
        /* mediaName            Input           MicroWeave      	   */
        /* & MediaNumber                Halftone        HighSpeed  Quality */
        /* PLAIN */
        PIPS_MED_PLAIN,         1,      1,      0,      1,      0x000,
        PIPS_MED_PLAIN,         2,      1,      2,      2,      0x010,
        PIPS_MED_PLAIN,         6,      1,      1,      2,      0x220,
        PIPS_MED_PLAIN,         4,      1,      1,      2,      0x300,
        PIPS_MED_PLAIN_SPEED,   2,      1,      2,      2,      0x010,
        /* RPPC */
        PIPS_MED_RPPC,          2,      1,      1,      2,      0x010,
        PIPS_MED_RPPC,          6,      1,      1,      2,      0x220,
        PIPS_MED_RPPC,          4,      1,      1,      2,      0x300,
        /* IJPC */
        PIPS_MED_IJPC,          6,      1,      1,      2,      0x220,
        PIPS_MED_IJPC,          6,      1,      1,      2,      0x330,
        PIPS_MED_IJPC,          4,      1,      1,      2,      0x400,
        /* ESF */
        PIPS_MED_ESF,           6,      1,      1,      2,      0x220,
        PIPS_MED_ESF,           6,      1,      1,      2,      0x330,
        PIPS_MED_ESF,           4,      1,      1,      2,      0x400,
        /* EPM */
        PIPS_MED_EPM,           6,      1,      1,      2,      0x220,
        PIPS_MED_EPM,           6,      1,      1,      2,      0x330,
        PIPS_MED_EPM,           4,      1,      1,      2,      0x400,
        /* ERC-S */
        PIPS_MED_ERC_S,         6,      1,      1,      2,      0x330,
        PIPS_MED_ERC_S,         4,      1,      1,      2,      0x400,
        PIPS_MED_ERC_S,         4,      1,      1,      2,      0x500,
        /* EPP-P */
        PIPS_MED_EGPP,          6,      1,      1,      2,      0x330,
        PIPS_MED_EGPP,          4,      1,      1,      2,      0x400,
        PIPS_MED_EGPP,          4,      1,      1,      2,      0x500,
	-1
};

short pModeMono[] = {
        /* mediaName            Input           MicroWeave      Quality */
        /* & MediaNumber                Halftone        HighSpeed       */
        PIPS_MED_PLAIN,         1,      1,      0,      1,      0x000,
        PIPS_MED_PLAIN,         2,      1,      2,      2,      0x010,
        PIPS_MED_PLAIN,         6,      1,      1,      2,      0x220,
        PIPS_MED_PLAIN,         4,      1,      1,      2,      0x300,
        PIPS_MED_PLAIN_SPEED,   2,      1,      2,      2,      0x010,
        /* RPPC */
        PIPS_MED_RPPC,          2,      1,      1,      2,      0x010,
        PIPS_MED_RPPC,          6,      1,      1,      2,      0x220,
        PIPS_MED_RPPC,          4,      1,      1,      2,      0x300,
        /* IJPC */
        PIPS_MED_IJPC,	        6,      1,      1,      2,      0x220,
        PIPS_MED_IJPC,	        6,      1,      1,      2,      0x330,
        PIPS_MED_IJPC,	        4,      1,      1,      0,      0x400,
        /* ESF */
        PIPS_MED_ESF,           6,      1,      1,      2,      0x220,
        PIPS_MED_ESF,           6,      1,      1,      2,      0x330,
        PIPS_MED_ESF,           4,      1,      1,      2,      0x400,	    
        /* EPM */
        PIPS_MED_EPM,           6,      1,      1,      2,      0x220,
        PIPS_MED_EPM,           6,      1,      1,      2,      0x330,
        PIPS_MED_EPM,           4,      1,      1,      0,      0x400,
        /* ERC-S */
        PIPS_MED_ERC_S,         6,      1,      1,      2,      0x330,
        PIPS_MED_ERC_S,         4,      1,      1,      2,      0x400,
        PIPS_MED_ERC_S,         4,      1,      1,      2,      0x500,
        /* EPP-P */
        PIPS_MED_EGPP,          6,      1,      1,      2,      0x330,
        PIPS_MED_EGPP,          4,      1,      1,      2,      0x400,
        PIPS_MED_EGPP,          4,      1,      1,      2,      0x500,
	-1
};

/* Bin="T4AUTO" ̵ˤʤ⡼ID (color,black )   */
/* t4ΤȤ_for_<̾>򳰤				*/ 
short de_param_mode_t4[] = {
	0, -1
};

#endif /* _ONLY_NEED_DEFAULT_ */

#endif /* __OPT_RSC__ */

