/*
 * Photo Image Print System
 * Copyright (C) 2000-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include "xMode.h"
#include "pipsError.h"
#include "ekpcom.h"

/* locale setting */
#include <stdlib.h>

void *options[EX_N_OPT];
void *opt_address[EX_N_OPT];
char *input_file;
char *output_file;
char *atinput_file;
int output_type;

GtkWidget *margin_frame_;
#if USE_GTK
UTIL_PACK pips_util_pack;

static void setDefaultOptions (SEP_INIT_PARAM*);
static void finButtonSave (GtkWidget*, gpointer);
static void finButtonOk (GtkWidget*, SEP_INIT_PARAM*);
static void finButtonCanncel (GtkWidget*, gpointer);
static GtkWidget* finButtonBoxNew (SEP_INIT_PARAM *);

static GtkWidget* makeIoFrame (char*);
static GtkWidget* makePaperFrame (char*);
static GtkWidget* makeColorManagementFrame (char*);
static GtkWidget* makeLayoutFrame (char*);
static GtkWidget* makeAdvancedFrame (char*);
static GtkWidget* makePropertyNotebook (void);
static GtkWidget* makeUtilFrame (char *);
static GtkWidget* makeConnectFrame (char*);
static GtkWidget* makeNoConnectFrame (char*);
#endif


char*  getRscName(int id, int value)
{
  int i, j;

  for(i = 0; opt_all[i].id != id; i++);
  for(j = 0; opt_all[i].data[j].value != END_ARRAY; j++)
    if(opt_all[i].data[j].value == value)
      return opt_all[i].data[j].rsc_name;
  return NULL;
}


#if USE_GTK

static void  setDefaultOptions(SEP_INIT_PARAM *sepip)
{
  int *val;

  val = (int*)options[P_SCALE];
  *val = sepip->mag;

  options[P_INK] = getRscName(P_INK, sepip->prt_format);
  options[P_MEDIA_SIZE] = getRscName(P_MEDIA_SIZE, sepip->paper_id);
  options[P_RESOLUTION] = getRscName(P_RESOLUTION, sepip->src_resolution.x);
  options[P_MEDIA_TYPE] = getRscName(P_MEDIA_TYPE, sepip->media_type);
  options[P_COLOR_MODE] = getRscName(P_COLOR_MODE, sepip->color_correction);

  val = (int*)options[P_BRIGHTNESS];
  *val = sepip->brightness;
  val = (int*)options[P_CONTRAST];
  *val = sepip->contrast;
  val = (int*)options[P_SATURATION];
  *val = sepip->saturation;

  options[P_HALF_TONE] = getRscName(P_HALF_TONE, sepip->halftone_type);
  
  options[P_MICRO_WEAVE] = getRscName(P_MICRO_WEAVE, sepip->mw_type );
  if(strcmp(options[P_MICRO_WEAVE], "ON")) options[P_MICRO_WEAVE] = NULL;

  options[P_HIGH_SPEED] = getRscName(P_HIGH_SPEED, sepip->high_speed);
  if(strcmp(options[P_HIGH_SPEED], "ON")) options[P_HIGH_SPEED] = NULL;

  val = (int*)options[P_STRENGTH_CYAN];
  *val = -(sepip->r_strength);
  val = (int*)options[P_STRENGTH_MAGENTA];
  *val= -(sepip->g_strength);
  val = (int*)options[P_STRENGTH_YELLOW];
  *val= -(sepip->b_strength);

  options[P_QUALITY_LEVEL] = getRscName(P_QUALITY_LEVEL, sepip->qlevel);
  options[P_BIN] = getRscName(P_BIN, sepip->bin_id);

#ifdef CONV_VERSION2
  val = (int*)options[P_MARGIN_X];
  *val = sepip->margin.x;
  val = (int*)options[P_MARGIN_Y];
  *val = sepip->margin.y;
#endif /* CONV_VERSION2 */
  options[P_FIT_PAGE] = getRscName(P_FIT_PAGE, sepip->fit_page);
  if(strcmp(options[P_FIT_PAGE], "ON")) options[P_FIT_PAGE] = NULL;

  options[P_MULTI_PAGE] = getRscName(P_MULTI_PAGE, sepip->multi_page);
  options[P_AUTO_CUT] = getRscName(P_AUTO_CUT, sepip->auto_cut);

#ifdef INK_CHANGE_SYSTEM
  options[P_INKSET] = getRscName(P_INKSET, sepip->inkset);
#endif /* INK_CHANGE_SYSTEM */

  return;
}

/*
 * fininish button box functions
 */

static void finButtonSave(GtkWidget *widget, gpointer data)
{
  saveRsc(options);
}


static void finButtonOk(GtkWidget *widget, SEP_INIT_PARAM *sepip)
{
#ifndef CONV_VERSION2
  FILE *outfp;
#endif

  if (getOptsForX (options, sepip))
    {
      return;
    }

#ifdef CONV_VERSION2
  if (output_type)
    /* lprľή̣. version2ǤϤεǽϺͽ */
    graphics_converter_version2 (sepip, input_file, ".", atinput_file); 
  else
    graphics_converter_version2 (sepip, input_file, output_file, atinput_file);
#else

  if (output_type) outfp = popen (SPOOLER_PATH, "w");
  else outfp = fopen (output_file, "wb");

  if (outfp == NULL)
    {
      if (output_type)
	pipsError ((char *)NULL, NOT_COMMUNICATE_LPR_ERROR);
      else
	pipsError (output_file, FAILED_FILE_ERROR);
      return;
    }
  
  printLoop (input_file, outfp, sepip);
  if (output_type) pclose (outfp);
  else fclose (outfp);
#endif
  return;
}



static void finButtonCanncel(GtkWidget *widget, gpointer data)
{
  gtk_main_quit();
}


static GtkWidget* finButtonBoxNew(SEP_INIT_PARAM *sepip)
{
  GtkWidget *hbox;
  GtkWidget *button;

  hbox =  gtk_hbox_new(TRUE, GTK_BORDER);
  
  button = gtk_button_new_with_label((char*)_(finishButtonLabels[0]));
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
		     GTK_SIGNAL_FUNC(finButtonSave), NULL);
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 5);
  gtk_widget_show(button);

  button = gtk_button_new_with_label((char*)_(finishButtonLabels[1]));
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
		     GTK_SIGNAL_FUNC(finButtonOk), sepip);
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 5);
  gtk_widget_show(button);

  button = gtk_button_new_with_label((char*)_(finishButtonLabels[2]));
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
		     GTK_SIGNAL_FUNC(finButtonCanncel), NULL);
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, GTK_BORDER);
  gtk_widget_show(button);

  return hbox;
}

/*
 * make frame functions
 */


static GtkWidget* makeIoFrame(char *title)
{
  GtkWidget *frame, *sub_frame;
  GtkWidget *vbox;

  frame = gtk_frame_new(title);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_IN);

  vbox = gtk_vbox_new(FALSE, GTK_BORDER);

  sub_frame = ioPackNew((char *)_(ioLabels[0]), INPUT);
  gtk_box_pack_start(GTK_BOX(vbox), sub_frame, FALSE, TRUE, 0);
  gtk_widget_show(sub_frame);
  
  sub_frame = ioPackNew((char *)_(ioLabels[1]), OUTPUT);
  gtk_box_pack_start(GTK_BOX(vbox), sub_frame, FALSE, TRUE, 0);
  gtk_widget_show(sub_frame);
  
  gtk_container_add(GTK_CONTAINER(frame), vbox);
  gtk_widget_show(vbox);

  gtk_container_set_border_width (GTK_CONTAINER (frame), GTK_BORDER);
  return frame;
}



static GtkWidget* makePaperFrame(char *title)
{
  GtkWidget *frame;
  GtkWidget *vbox;
  GtkWidget *hbox;

  frame = gtk_frame_new(title);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_IN);

  vbox = gtk_vbox_new(FALSE, GTK_BORDER);

  hbox = selectPackNew(NULL, (char**)mediaSizeEntry, P_MEDIA_SIZE);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show(hbox);

  hbox = selectPackNew(NULL, (char**)binEntry, P_BIN);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show(hbox);

  hbox = selectPackNew(NULL, (char**)autoCutEntry, P_AUTO_CUT);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show(hbox);

  gtk_container_add(GTK_CONTAINER(frame), vbox);
  gtk_widget_show(vbox);

  gtk_container_set_border_width (GTK_CONTAINER (frame), GTK_BORDER);
  return frame;
}


static GtkWidget* makeLayoutFrame (char *title)
{
  GtkWidget *frame, *frame2;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *button;
  double param_scale[] = { 10.0, 400.0, 10.0, 100.0, 0.0 };

#ifdef CONV_VERSION2
  GtkWidget *hbox2;
  double param_margin[] = {0.0, 1000.0, 1.0, 100.0, 0.0 };
#endif /* CONV_VERSION2 */

  frame = gtk_frame_new(title);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_IN);

  vbox = gtk_vbox_new(FALSE, GTK_BORDER);

  /* Fit to Page setup */
  hbox = checkPackNew(NULL, P_FIT_PAGE);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show(hbox);

  /* Scale setup */
  hbox = spinPackNew(NULL, P_SCALE, param_scale);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show(hbox);

  /* Margin setup */
#ifdef CONV_VERSION2
  frame2 = gtk_frame_new(commonLabelCall(P_MARGIN, NULL));
  gtk_frame_set_shadow_type(GTK_FRAME(frame2), GTK_SHADOW_ETCHED_IN);

  margin_frame_ = frame2; /* add Thu Oct 18 2001 */

  hbox = gtk_hbox_new(TRUE, GTK_BORDER);

  hbox2 = spinPackNew (NULL, P_MARGIN_X, param_margin);
  gtk_box_pack_start(GTK_BOX(hbox), hbox2, FALSE, TRUE, 0);
  gtk_widget_show(hbox2);

  hbox2 = spinPackNew(NULL, P_MARGIN_Y, param_margin);
  gtk_box_pack_start(GTK_BOX(hbox), hbox2, FALSE, TRUE, 0);
  gtk_widget_show(hbox2);

  button = margin_default_set_button ();
  gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, TRUE, 0);
  gtk_widget_show(button);

  gtk_container_add(GTK_CONTAINER(frame2), hbox);
  gtk_widget_show(hbox);

  gtk_box_pack_start(GTK_BOX(vbox), frame2, FALSE, TRUE, 0);
  gtk_widget_show(frame2);
#endif /* CONV_VERSION2 */

/* Multi Page setup */
  frame2 = radioPackNew(NULL, (char**)multiPageEntry, P_MULTI_PAGE);
  gtk_box_pack_start(GTK_BOX(vbox), frame2, FALSE, TRUE, 0);
  gtk_widget_show(frame2);

  gtk_container_add(GTK_CONTAINER(frame), vbox);
  gtk_widget_show(vbox);

  gtk_container_set_border_width (GTK_CONTAINER (frame), GTK_BORDER);
  return frame;
}

static GtkWidget* makeAdvancedFrame(char *title)
{
  GtkWidget *frame, *sub_frame;
  GtkWidget *table, *hbox;

  frame = gtk_frame_new(title);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_IN);

  table = gtk_table_new (6, 2, FALSE);

  hbox = selectPackNew(NULL, (char**)mediaTypeEntry, P_MEDIA_TYPE);
  gtk_table_attach (GTK_TABLE(table), hbox, 0, 2, 0, 1, GTK_FILL | GTK_SHRINK | GTK_EXPAND, GTK_FILL | GTK_SHRINK | GTK_EXPAND, 0, 0); 
  gtk_widget_show(hbox);
  
  hbox = selectPackNew(NULL, (char**)halftoneEntry, P_HALF_TONE);
  gtk_table_attach (GTK_TABLE(table), hbox, 0, 2, 1, 2, GTK_FILL | GTK_SHRINK | GTK_EXPAND, GTK_FILL | GTK_SHRINK | GTK_EXPAND, 0, 0); 
  gtk_widget_show(hbox);

  hbox = selectPackNew(NULL, (char**)resolutionEntry, P_RESOLUTION);
  gtk_table_attach (GTK_TABLE(table), hbox, 0, 2, 2, 3, GTK_FILL | GTK_SHRINK | GTK_EXPAND, GTK_FILL | GTK_SHRINK | GTK_EXPAND, 0, 0); 
  gtk_widget_show(hbox);

  hbox = selectPackNew(NULL, (char**)levelEntry, P_QUALITY_LEVEL);
  gtk_table_attach (GTK_TABLE(table), hbox, 0, 2, 3, 4, GTK_FILL | GTK_SHRINK | GTK_EXPAND, GTK_FILL | GTK_SHRINK | GTK_EXPAND, 0, 0); 
  gtk_widget_show(hbox);

  hbox = checkPackNew(NULL, P_MICRO_WEAVE);
  gtk_table_attach (GTK_TABLE(table), hbox, 0, 1, 4, 5, GTK_FILL | GTK_SHRINK | GTK_EXPAND, GTK_FILL | GTK_SHRINK | GTK_EXPAND, 0, 0); 
  gtk_widget_show(hbox);

  hbox = checkPackNew(NULL, P_HIGH_SPEED);
  gtk_table_attach (GTK_TABLE(table), hbox, 0, 1, 5, 6, GTK_FILL | GTK_SHRINK | GTK_EXPAND, GTK_FILL | GTK_SHRINK | GTK_EXPAND, 0, 0); 
  gtk_widget_show(hbox);

  sub_frame = radioPackNew(NULL, (char**)inkEntry, P_INK);
  gtk_table_attach (GTK_TABLE(table), sub_frame, 1, 2, 4, 6, GTK_FILL | GTK_SHRINK | GTK_EXPAND, GTK_FILL | GTK_SHRINK | GTK_EXPAND, 0, 0); 
  gtk_widget_show(sub_frame);

  gtk_container_add(GTK_CONTAINER(frame), table);
  gtk_widget_show(table);

  gtk_container_set_border_width (GTK_CONTAINER (frame), GTK_BORDER);
  return frame;
}


static GtkWidget* makeColorManagementFrame(char *title)
{
  GtkWidget *frame;
  GtkWidget *vbox;
  GtkWidget *hbox;
  int i;
  double param[] = { -50.0, 50.0, 1.0, 10.0, 0.0 };

  frame = gtk_frame_new(title);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_IN);

  vbox = gtk_vbox_new(FALSE, GTK_BORDER);

  hbox = selectPackNew(NULL, (char**)colorModeEntry, P_COLOR_MODE);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show(hbox);  
  
  for(i = 0; i < 3; i++){
    hbox = adjustmentPackNew(NULL, P_BRIGHTNESS + i, param);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);
    gtk_widget_show(hbox);
  }

  for(i = 0; i < 3; i++){
    hbox = adjustmentPackNew(NULL, P_STRENGTH_CYAN + i, param);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);
    gtk_widget_show(hbox);
  }

  gtk_container_add(GTK_CONTAINER(frame), vbox);
  gtk_widget_show(vbox);

  gtk_container_set_border_width (GTK_CONTAINER (frame), GTK_BORDER);
  return frame;
}

 
static GtkWidget* makePropertyNotebook(void)
{
  GtkWidget *notebook;
  GtkWidget *label;
  GtkWidget *page;
  char *name;
  int i;

  notebook = gtk_notebook_new();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK(notebook), GTK_POS_TOP);
  for(i = 1; i < 7; i++){
    name = (char *)_(highRanckLabels[i]);
    label = gtk_label_new(name);
    switch(i){
    case 1: page = makeIoFrame (name); break;
    case 2: page = makePaperFrame (name); break;
    case 3: page = makeLayoutFrame (name); break;
    case 4: page = makeAdvancedFrame (name); break;
    case 5: page = makeColorManagementFrame (name); break;
    case 6: page = makeUtilFrame (name); break;
    default: return NULL;
    }
    gtk_widget_show(label);
    gtk_widget_show(page);
    gtk_notebook_append_page( GTK_NOTEBOOK(notebook), page, label);

  }
  return notebook;
}
 
 
/*
 * configuration window function
 */


void confWinInit(int *argc, char **argv[], char *filename, SEP_INIT_PARAM *sepip, PIPS_INIT_PARAM *pip)
{
  int i;
  FILE *fp;

  gtk_set_locale();
  gtk_init(argc, argv);
  gtk_rc_parse("gtkrc");

  bindtextdomain (PACKAGE, LOCALE_PATH);
  textdomain (PACKAGE);

  /* locale setting */
  fp = fopen (DATA_PATH "/lang", "w");
  if (fp != NULL)
    {
      char buf[1024];
      char *env;

      env = getenv("LANG");
      if (env != NULL && strncmp (env, "(null)", strlen (env)))
	{
	  sprintf (buf, "export LANG=%s\n", env);
	  fwrite (buf, sizeof (char), strlen (buf), fp);
	}

      env = getenv("LANGUAGE");
      if (env != NULL && strncmp (env, "(null)", strlen (env)))
	{
	  sprintf (buf, "export LANGUAGE=%s\n", env);
	  fwrite (buf, sizeof (char), strlen (buf), fp);
	}

      fclose (fp);
    }

  for(i = 0; i < EX_N_OPT; i++){
    opt_address[i] = NULL;
    switch(i){
    case P_SCALE:
    case P_BRIGHTNESS:
    case P_CONTRAST:
    case P_SATURATION:
    case P_STRENGTH_CYAN:
    case P_STRENGTH_MAGENTA:
    case P_STRENGTH_YELLOW:
    case P_MARGIN_X:
    case P_MARGIN_Y:
#ifdef INK_CHANGE_SYSTEM
    case P_INKSET:
#endif /* INK_CHANGE_SYSTEM */
      options[i] = (int *)malloc(sizeof(int)); break;
    default:  options[i] = NULL; break;
    }
  }

  input_file = (char *)calloc(1024, sizeof(char));
  strcpy(input_file, filename);

  output_file = (char *)calloc(1024, sizeof(char));
  strcpy(output_file, "Output.prn");

  if (pip->atbmp_fifo_path)
  {
	  atinput_file = (char *)calloc(1024, sizeof(char));
	  strcpy(atinput_file, pip->atbmp_fifo_path);
  }
  else
  {
	  atinput_file = NULL;
  }

  output_type = 1;
  setDefaultOptions(sepip);

  memset (&pips_util_pack, 0, sizeof (UTIL_PACK));
  pips_util_pack.inkbox_xpm = inkbox_xpm_new ();
  pips_util_pack.timer = gtk_timeout_add (1000, getInkStatus, NULL);
  return;
}


void confWinFinalize(void)
{
  int i;
  
  for(i = 0; i < EX_N_OPT; i++){
    switch(i){
    case P_SCALE:
    case P_BRIGHTNESS:
    case P_CONTRAST:
    case P_SATURATION:
    case P_STRENGTH_CYAN:
    case P_STRENGTH_MAGENTA:
    case P_STRENGTH_YELLOW: free(options[i]);

    case P_BIN:
    case P_INK:
    case P_MEDIA_SIZE:
    case P_RESOLUTION:
    case P_MEDIA_TYPE:
    case P_COLOR_MODE:
    case P_HALF_TONE:
    case P_HIGH_SPEED:
    case P_QUALITY_LEVEL:
    case P_OUTPUT_EX:
    case P_FIT_PAGE:
    case P_MULTI_PAGE:
    case P_AUTO_CUT:
	    free(opt_address[i]);
    default: break;
    }
  }
  free(input_file);
  free(output_file);

  inkbox_xpm_ref (pips_util_pack.inkbox_xpm);
  gtk_timeout_remove (pips_util_pack.timer);
  return;
}



int confWinShow(SEP_INIT_PARAM *sepip, const char *wtitle)
{
  GtkWidget *window;
  GtkWidget *vbox;
  GtkWidget *container;
  GtkWidget *hbox;
  char app_title[1024];

  memset(app_title, '\0', 1024);
  sprintf(app_title, "Photo Image Print System ( %s )", wtitle);
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), app_title);
  gtk_signal_connect(GTK_OBJECT(window), "delete_event", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
  pips_util_pack.main_widget = window;
  vbox = gtk_vbox_new(FALSE, 5);

  container = makePropertyNotebook();
  gtk_box_pack_start(GTK_BOX(vbox), container, FALSE, FALSE, 0);
  gtk_widget_show(container);
  hbox = finButtonBoxNew(sepip);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show(hbox);

  gtk_container_add(GTK_CONTAINER(window), vbox);
  gtk_widget_show(vbox);

  commonSetOptionsSensitive();
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, TRUE, FALSE);
  gtk_widget_show(window);

  gtk_main();
  return 0;
}

static
GtkWidget* makeUtilFrame (char *title)
{
  GtkWidget *frame, *core_frame, *vbox;

  frame = gtk_frame_new(title);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_IN);
  vbox = gtk_vbox_new(TRUE, GTK_BORDER);

  core_frame = makeConnectFrame (NULL);
  gtk_box_pack_start (GTK_BOX(vbox), core_frame, FALSE, TRUE, 0);
  pips_util_pack.connect_frame = core_frame;

  core_frame = makeNoConnectFrame (NULL);
  gtk_box_pack_start (GTK_BOX(vbox), core_frame, FALSE, TRUE, 0);
  pips_util_pack.no_connect_frame = core_frame;

  gtk_container_add (GTK_CONTAINER(frame), vbox);
  gtk_widget_show (vbox);

  /*getInkStatus (NULL);*/

  return frame;
}

static
GtkWidget* makeConnectFrame(char *title)
{
  GtkWidget *frame, *vbox, *hbox, *prog_frame, *prog_vbox;


  frame = gtk_frame_new(title);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_NONE);

  vbox = gtk_vbox_new(FALSE, GTK_BORDER);

  hbox = commandButtonNew ((char *)_(Status_Monitor));
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show(hbox);

  hbox = commandButtonNew ((char *)_(Nozzle_Check));
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show(hbox);

  hbox = commandButtonNew ((char *)_(Head_Cleaning));
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show(hbox);

  hbox = commandButtonNew ((char *)_(Print_Head_Alignment));
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show(hbox);

  hbox = commandButtonNew ((char *)_(Auto_Cutter_Adjustment));
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);
#ifdef USE_AUTO_CUT
  gtk_widget_show(hbox);
#endif /* USE_AUTO_CUT */

  prog_frame = gtk_frame_new((char *)_(Ink_Volume));
  prog_vbox = gtk_vbox_new(FALSE, GTK_BORDER);

#if (USE_INKBOX)
  hbox = inkboxPackNew ();
  gtk_box_pack_start(GTK_BOX(prog_vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show(hbox);
#else
  hbox = progressPackNew ((char *)_(Ink_Black));
  gtk_box_pack_start(GTK_BOX(prog_vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show(hbox);

  hbox = progressPackNew ((char *)_(Ink_Color));
  gtk_box_pack_start(GTK_BOX(prog_vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show(hbox);
#endif

#if CL700 || SC480 || SC580
  hbox = commandButtonNew ((char *)_(Ink_Chenge));
  gtk_box_pack_start(GTK_BOX(prog_vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show(hbox);
#endif

  gtk_container_add(GTK_CONTAINER(prog_frame), prog_vbox);
  gtk_widget_show(prog_vbox);
  gtk_box_pack_start(GTK_BOX(vbox), prog_frame, FALSE, TRUE, 0);
  gtk_widget_show(prog_frame);

  gtk_container_add(GTK_CONTAINER(frame), vbox);
  gtk_widget_show(vbox);

  gtk_container_set_border_width (GTK_CONTAINER (frame), GTK_BORDER);
  return frame;
}

static
GtkWidget* makeNoConnectFrame(char *title)
{
  GtkWidget *frame, *label;

  frame = gtk_frame_new(title);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_NONE);

  label = gtk_label_new ((char *)_(No_Connect_Message));
  gtk_container_add(GTK_CONTAINER(frame), label);
  gtk_widget_show(label);
  return frame;
}
#endif
