/***************************************************************************
                          auth_mem.h  -  authoritative zones from memory
                             -------------------
    begin                : do jan 2 2003
    copyright            : (C) 2003 by Meilof
    email                : meilof@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __POSADIS_AUTH_MEM_H
#define __POSADIS_AUTH_MEM_H

#include "zones.h"
#include "stdquery.h"

_auth_ret auth_mem_lookup(pending_query *q, domainname &qname,
                          int QTYPE, domainname &znroot, DnsMessage *a,
                          ZoneDomain *rootdomain);

bool auth_mem_additional_lookup(domainname &qname, uint16_t qtype,
                                stl_list(DnsRR)& section,
                                domainname &znroot, ZoneDomain *rootdomain,
                                pending_query *qinfo);


class AuthMemZone: public Zone {
 public:
  AuthMemZone();
  ~AuthMemZone();
  _auth_ret stdquery_lookup(pending_query *q, domainname &qname,
                          uint16_t QTYPE, domainname &znroot, DnsMessage *a);
  virtual bool additional_lookup(domainname &qname, uint16_t qtype,
                                 stl_list(DnsRR)& section,
                                 domainname &znroot, pending_query *qinfo);
  bool auth_feed_setting(const char *name, const char *val);
  virtual void end_setting();
  ZoneDomain *rootdomain;
  bool zone_is_loaded;
  uint32_t serial;
  /* config settings */
  stl_slist(_addr) slaves;
  enum _allow_xfr { any, slaves_only, none };
  _allow_xfr allow_xfr;
  stl_slist(addrrange) allow_xfr_to;
  void start_notification();
};
                                                                
#endif /* __POSADIS_AUTH_MEM_H */
