/***************************************************************************
                          cacheapply.cpp  -  description
                             -------------------
    begin                : zo dec 29 2002
    copyright            : (C) 2002 by Meilof
    email                : meilof@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cacheapply.h"
#include "recursive.h"
#include "zones.h"
#include "stdquery.h"
#include "resolver.h"

void flag_section(char *bitmask, stl_list(DnsRR) &section, domainname &dom) {
  stl_list(DnsRR)::iterator it = section.begin();
  int x = -1;
  while (it != section.end()) {
    x++;
    if ((it->TYPE == DNS_TYPE_A || it->TYPE == DNS_TYPE_AAAA) && it->NAME == dom)
      bitset(bitmask, x);
    it++;
  }
}


void cache_section(char *bitmask, stl_list(DnsRR) &section) {
  stl_list(DnsRR)::iterator it = section.begin(), it2;
  ZoneDomain *dom;
  bool create;
  RrSet *set;
  int x = 0, y;
  char *blans2 = (char *)calloc(1, (section.size()+7) / 8);
  time_t tm = time(NULL);

  while (it != section.end()) {
//    printf("Consider adding [%s,%d] (and next-to-kins) to cache...\n", it->NAME.tocstr(), it->TYPE);
    if (!bitisset(blans2, x) && bitisset(bitmask, x)) {
//      printf("Adding [%s,%d] (and next-to-kins) to cache...\n", it->NAME.tocstr(), it->TYPE);
      it2 = it;
      dom = create_domainname(cache_root_domain, root_domain_name, it->NAME);
      set = dom->get_rrset(it->TYPE);
      if (set && set->ttl < TTL_MAX_AUTHORITIVE) create = false; else create = true;
      if (create) {
        dom->remove_rrset(it->TYPE);
        set = dom->create_rrset(it->TYPE);
      }
      y = x;
      while (it2 != section.end()) {
        if (it2->TYPE == it->TYPE && it2->NAME == it->NAME/* && it->TTL > 0*/) {
          if (create) set->add_rr(tm + it2->TTL, it2->RDLENGTH, it2->RDATA);
          bitset(blans2, y);
        }
        it2++;
        y++;
      }
      if (set->rrs.count == 0) {
        /* the set has no items */
        dom->remove_rrset(set->type);
      }
    }
    x++;
    it++;
  }
  free(blans2);
}

void flag_from_rdata(DnsMessage *msg, uint16_t rrtype, char *rdata, char *bladd, domainname &znroot) {
  rr_type *rrinfo;
  char *prop;
  domainname tmp;

  rrinfo = rrtype_getinfo(rrtype);
  if (rrinfo && (rrinfo->flags & R_ASP)) {
    prop = rrinfo->properties;
    while (*prop) {
      if (*prop == 'd') {
        tmp = rr_getdomain(rdata, rrtype, prop - rrinfo->properties);
        if (tmp >= znroot) {
          flag_section(bladd, msg->additional, tmp);
        }
      }
      prop++;
    }
  }
}

void apply_answer_to_cache(DnsMessage *msg, domainname qname, uint16_t qtype, domainname &znroot, bool is_referral) {
  stl_list(DnsRR)::iterator it = msg->answers.begin();
  char *blans = (char *)calloc(1, (msg->answers.size()+7) / 8);
  char *blauth = (char *)calloc(1, (msg->authority.size()+7) / 8);
  char *bladd = (char *)calloc(1, (msg->additional.size()+7) / 8);
  int x = -1;
  domainname next;
  bool found = false;
  bool is_soa;

start:
  next = "";
  is_soa = false;

  /* check for valid answers */
  while (it != msg->answers.end()) {
    x++;
    if (answers_qtype(it->TYPE, qtype) && it->NAME == qname) {
      bitset(blans, x);
      /* found an answer. check for domains we'll allow in additional section */
//      printf("Found RRset answering query: [%s,%d]\n", it->NAME.tocstr(), it->TYPE);
      flag_from_rdata(msg, it->TYPE, it->RDATA, bladd, znroot);
      found = true;
    } else if (it->TYPE == DNS_TYPE_CNAME && it->NAME == qname) {
      /* check for CNAME */
      next = domainname(true, it->RDATA);
      bitset(blans, x);
//      printf("The answer is a cname: %s points to %s\n", it->NAME.tocstr(), next.tocstr());
      is_soa = true;
      break;
    }
    it++;
  }

  if (is_soa) {
    qname = next;
    if (qname >= znroot) goto start;
  } else {
    ZoneDomain *dom;
    DnsRR *rr;
    RrSet *set;

    if (!found && !is_referral) {
      /* cache NODATA/NXDOMAIN */
      if (msg->RCODE == RCODE_NXDOMAIN) {
#ifdef DEBUG
        printf("Attempting to cache NXDOMAIN for %s\n", qname.tocstr());
#endif
        rr = get_soa_rr(qname, msg->authority);
        if (rr) {
#ifdef DEBUG
          printf("  -> using supplied SOA rr\n");
#endif
          dom = create_domainname(cache_root_domain, root_domain_name, qname);
          dom->rrsets.destroy();
          dom->ext.ncache_time = time(NULL) + rr_getlong(rr->RDATA, DNS_TYPE_SOA, 6);
        } //else printf("  -> but no SOA given\n");
      } else if (msg->RCODE == RCODE_NOERROR && is_common_rr(qtype)) {
#ifdef DEBUG
        printf("Attempting to cache NODATA for %s\n", qname.tocstr());
#endif
        rr = get_soa_rr(qname, msg->authority);
        if (rr) {
          dom = create_domainname(cache_root_domain, root_domain_name, qname);
          dom->remove_rrset(qtype);
          set = dom->create_rrset(qtype);
          set->ttl = time(NULL) + rr_getlong(rr->RDATA, DNS_TYPE_SOA, 6);
        } //else printf("  -> but no SOA given\n");
      }
    }
  }    

  /* check for valid NS/SOA records. we'll allow anything inside znroot */
  it = msg->authority.begin();
  x = -1;
  while (it != msg->authority.end()) {
    x++;
    if ((it->TYPE == DNS_TYPE_NS || it->TYPE == DNS_TYPE_SOA) && it->NAME >= znroot) {
//      printf("Accepted record[%s,%d] (and next-to-kins) from authority\n", it->NAME.tocstr(), it->TYPE);
      bitset(blauth, x);
      /* found an answer. check for domains we'll allow in additional section */
      flag_from_rdata(msg, it->TYPE, it->RDATA, bladd, znroot);
    }
    it++;
  }

//  printf("Calling cache_section\n");
  cache_section(blans, msg->answers);
  cache_section(blauth, msg->authority);
  cache_section(bladd, msg->additional);

  free(blans);
  free(blauth);
  free(bladd);
}
