/***************************************************************************
                          configuration.h  -  server configuration
                             -------------------
    begin                : wo dec 25 2002
    copyright            : (C) 2002 by Meilof
    email                : meilof@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __POSADIS_CONFIGURATION_H
#define __POSADIS_CONFIGURATION_H

#include <poslib/poslib.h>
#include "zones.h"
#include "posadisrc.h"

#ifdef WIN32
#define SEP '\\'
#else
#define SEP '/'
#endif

extern bool cmd_logfile;
extern char *logfile; /* PATH_MAX */
extern bool logfile_per_day;

extern char *confdir; /* PATH_MAX */
extern char *datadir; /* PATH_MAX */

extern int max_cache_items;
extern int max_cname_recursion;
extern int resolv_patience;

extern int update_ttl;

#ifndef _WIN32
extern bool cmd_username, cmd_groupname;
extern char username[128], groupname[128];
#endif

extern bool do_query_logging;
extern bool omit_ns_records;

extern bool cache_statistics;

extern stl_list(stl_string) cachefiles;

void config_init();

void config_init();

bool provide_recursion(_addr *a);
bool conf_feed_setting(const char *set, const char *value);
void conf_end_setting();
bool our_allow_tcp_connection(_addr *a, int ntcp);

bool recursive_zone_end_setting(void *null, char *name, Zone *root);

#define is_whitespace(c) ( (c) == ' ' || (c) == '\t' )
#define skip_whitespace(buff, ptr) { ptr = buff; while (*ptr == ' ' || *ptr == '\t') ptr++; }


#endif /* __POSADIS_CONFIGURATION_H */
