/*
 * fam_w32.cpp - FAM implementation for Win32
 * Copyright (C) 2003 Meilof Veeningen <meilof@myrealbox.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef _WIN32

#include <windows.h>
#include <poslib/poslib.h>

extern int FAMErrno;

class file_info {
 public:
  bool operator<(file_info &inf);
  stl_string fname;
  time_t writetime;
  bool used;
};

class FAMEvent;

enum FAMChangeCode { FAMExists, FAMDeleted, FAMCreated, FAMChanged };

class FAMConnection {
 public:
  stl_list(FAMEvent) pending_events;
};

class FAMRequest {
 public:
  HANDLE changehandle;
  stl_list(file_info) filelist;
  stl_string dirname;
};

class FAMEvent {
 public:
  FAMEvent();
  FAMEvent(const FAMEvent& ev);
  ~FAMEvent();
  FAMEvent& operator=(FAMEvent& ev);
  const char *filename;
  FAMChangeCode code;
};

int FAMOpen2(FAMConnection *conn, const char *appname); // return 0 on success
int FAMMonitorDirectory(FAMConnection *conn, const char *dir, FAMRequest *req,
                        void *nulldata); // return 0 on success
void FAMClose(FAMConnection *conn);
void FAMCancelMonitor(FAMConnection *conn, FAMRequest *req);
int FAMWait(FAMConnection *conn, FAMRequest *req, struct timeval *tv); // return <0 on failure
bool FAMIsData(FAMConnection *conn);
int FAMNextEvent(FAMConnection *conn, FAMEvent *event); // return <0 on failure
int FAMPending(FAMConnection *conn); // return 1 on pending

#define FAMselect(conn,req,fs,set,timeval) (FAMWait(conn,req,timeval))
#define FAM_FD_ISSET(a,b,c) (FAMIsData(a))
#else /* _WIN32 */
#include <fam.h>
#define FAMselect(conn,req,fd,set,tv) (select(fd,set,NULL,NULL,tv))
#define FAM_FD_ISSET(a,b,c) (FD_ISSET(b,c))
#endif /* _WIN32 */

