/***************************************************************************
                          forward.cpp  -  forwarding support
                             -------------------
    begin                : zo dec 29 2002
    copyright            : (C) 2002 by Meilof
    email                : meilof@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <poslib/poslib.h>
 
#include "zones.h"
#include "resolver.h"
#include "stdquery.h"

void copy_and_cache_section(stl_list(DnsRR) &ret, stl_list(DnsRR) &src) {
  stl_list(DnsRR)::iterator it = src.begin(), it2;
  ZoneDomain *dom;
  RrSet *set;
  time_t tm = time(NULL);
  bool create;
  while (it != src.end()) {
    it2 = it;
    dom = create_domainname(cache_root_domain, root_domain_name, it->NAME);
    set = dom->get_rrset(it->TYPE);
    if (set && set->ttl < TTL_MAX_AUTHORITIVE) create = false; else create = true;
    if (create) {
      dom->remove_rrset(it->TYPE);
      set = dom->create_rrset(it->TYPE);
    }
    while (it2 != src.end() && it2->TYPE == it->TYPE && it2->NAME == it->NAME) {
      ret.push_back(*it2);
      if (create) set->add_rr(tm + it2->TTL, it2->RDLENGTH, it2->RDATA);
      it2++;
    }
    it = it2;
  }
}

void handle_forwarded_answer(DnsMessage *ra, DnsMessage *a, domainname qname, uint16_t qtype) {
  int reclevel = MAX_RECURSION;
  stl_list(DnsRR)::iterator it;
  DnsRR *rr;
  RrSet *set;
  ZoneDomain *dom;

start:
  if (--reclevel < 0) goto ready;

  it = a->answers.begin();
  while (it != a->answers.end()) {
    if (it->NAME == qname) {
      if (answers_qtype(it->TYPE, qtype)) {
        /* it is an answer */
        goto ready;
      } else if (it->TYPE == DNS_TYPE_CNAME) {
        qname = domainname(true, it->RDATA);
        goto start;
      }
    }
    it++;
  }

  /* our quest comes to an end! */
  if (a->RCODE == RCODE_NXDOMAIN) {
    /* cache this nxdomain */
    rr = get_soa_rr(qname, a->authority);
    if (rr) {
      dom = create_domainname(cache_root_domain, root_domain_name, qname);
      dom->rrsets.destroy();
      dom->ext.ncache_time = time(NULL) + rr_getlong(rr->RDATA, DNS_TYPE_SOA, 6);
    }
  } else if (is_common_rr(qtype)) {
    /* cache this nodata */
    rr = get_soa_rr(qname, a->authority);
    if (rr) {
      dom = create_domainname(cache_root_domain, root_domain_name, qname);
      dom->remove_rrset(qtype);
      set = dom->create_rrset(qtype);
      set->ttl = time(NULL) + rr_getlong(rr->RDATA, DNS_TYPE_SOA, 6);
    }
  }

ready:
  /* now, copy the message */
  ra->RCODE = a->RCODE;
  copy_and_cache_section(ra->answers, a->answers);
  copy_and_cache_section(ra->authority, a->authority);
  copy_and_cache_section(ra->additional, a->additional);
}

void forward_query(DnsMessage *a, domainname &quest, uint16_t rrtype, stl_slist(_addr) *forwarders) {
  DnsMessage *qq = NULL, *qa = NULL;
  pos_cliresolver cli;
  try {
    qq = new DnsMessage();
    qq->RD = true;
    qq->questions.push_front(DnsQuestion(quest, rrtype));
    pthread_mutex_unlock(&m_cache);
    pthread_mutex_unlock(&m_auth_zones);
    try {
      cli.query(qq, qa, *forwarders);
    } catch (PException p) {
      pthread_mutex_lock(&m_auth_zones);
      pthread_mutex_lock(&m_cache);
      throw p;
    } 
    pthread_mutex_lock(&m_auth_zones);
    pthread_mutex_lock(&m_cache);
    handle_forwarded_answer(a, qa, quest, rrtype);
  } catch (PException p) {
    if (qq) delete qq;
    if (qa) delete qa;
    a->RCODE = RCODE_SRVFAIL;
    return;
  }
  if (qq) delete qq;
  if (qa) delete qa;
}
