/***************************************************************************
                          lib.cpp  -  library loader
                             -------------------
    begin                : do jan 2 2003
    copyright            : (C) 2003 by Meilof
    email                : meilof@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <posadis-config.h>
#include "lib.h"
#include <ltdl.h>
#include <poslib/poslib.h>
#include "configuration.h"
#include "zones.h"
#include "primary.h"
#include "secondary.h"

#ifdef _WIN32
char aPLUGINDIR[PATH_MAX] = "";
char *plugin_dir = aPLUGINDIR;
#else
char *plugin_dir = PLUGINDIR;
#endif

bool inited;
stl_slist(library) libraries;
stl_slist(getdynzone_fn) getdynzone_functions;
stl_slist(feed_setting_fn) feed_setting_functions;
stl_slist(end_setting_fn) end_setting_functions;

class _static_lib_init {
 public:
  _static_lib_init() {
    int ret;
    if ((ret = lt_dlinit()) == 0) {
      inited = true;
    } else {
      printf("Error: %s\n", lt_dlerror());
      inited = false;
    }
  }
  ~_static_lib_init() {
    if (inited) lt_dlexit();
  }
} __static_lib_init;

typedef zone_entry *(*getzonefn)(void);

void lib_init() {
  lt_dlsetsearchpath("");
}

void add_libdir(const char *dir) {
  lt_dladdsearchdir(dir);
}
 
void load_library(const char *lib) {
  library libr;
  lt_dlhandle handle;
  getzonefn getzones;
  getdynzone_fn getdynzones;
  feed_setting_fn feedsetting;
  end_setting_fn endsetting;
  if (inited) {
    if (strlen(lib) > 31) throw PException(true, "Library name too long", lib);
    strcpy(libr.name, lib);
    handle = lt_dlopenext(lib);
    if (!handle) throw PException(true, "Could not load library %s: %s", lib, lt_dlerror());
    /* lookup get_zones */
    getzones = (getzonefn)lt_dlsym(handle, "get_zones");
    if (getzones)
      libr.zones = getzones();
    else
      libr.zones = NULL;
    libraries.push_front(libr);
    /* lookup get_dynzones() */
    getdynzones = (getdynzone_fn)lt_dlsym(handle, "get_dyn_zones");
    if (getdynzones)
      getdynzone_functions.push_front(getdynzones);
    /* lookup feed_setting() */
    feedsetting = (feed_setting_fn)lt_dlsym(handle, "lib_feed_setting");
    if (feedsetting)
      feed_setting_functions.push_front(feedsetting);
    /* lookup end_setting() */
    endsetting = (end_setting_fn)lt_dlsym(handle, "lib_end_setting");
    if (endsetting)
      end_setting_functions.push_front(endsetting);    
  } else throw PException("Library loader not available");
}

Zone *create_zone(const char *type) {
  stl_slist(library)::iterator it = libraries.begin();
  zone_entry *ptr;
  while (it != libraries.end()) {
    ptr = it->zones;
    if (ptr) {
      while (ptr->name[0]) {
        if (strcmpi(ptr->name, type) == 0) {
          return ptr->create_fn();
        }
        ptr++;
      }
    }
    it++;
  }

  if (strcmpi(type, "primary") == 0) return new PrimaryZone();
  if (strcmpi(type, "secondary") == 0) return new SecondaryZone();

  throw PException(true, "Unknown zone type %s", type);
}

Zone *lookup_dyn_zone(domainname &dom, domainname *ret) {
  stl_slist(getdynzone_fn)::iterator it = getdynzone_functions.begin();
  Zone *retzn = NULL, *tmp;
  int nl = 0;
  domainname rett;
  while (it != getdynzone_functions.end()) {
    tmp = (*it)(dom, &rett);
    if (rett.nlabels() > nl) {
      *ret = rett;
      retzn = tmp;
    }
    it++;
  }
  return retzn;
}

bool feed_setting(const char *setting, const char *arguments) {
  stl_slist(feed_setting_fn)::iterator it = feed_setting_functions.begin();
  while (it != feed_setting_functions.end()) {
    if ((*it)(setting, arguments)) return true;
    it++;
  }
  return (conf_feed_setting(setting, arguments));
}

void end_setting() {
  conf_end_setting();
  stl_slist(end_setting_fn)::iterator it = end_setting_functions.begin();
  while (it != end_setting_functions.end()) {
    (*it)();
    it++;
  }
}
