/***************************************************************************
                          lib.h  -  library loader
                             -------------------
    begin                : do jan 2 2003
    copyright            : (C) 2003 by Meilof
    email                : meilof@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __POSADIS_LIB_H
#define __POSADIS_LIB_H

#include <poslib/sysstl.h>
#include "zones.h"

struct zone_entry {
  char name[32];
  Zone *(*create_fn)(void);
};

struct library {
  char name[32];
  zone_entry *zones;
};

extern stl_slist(library) libraries;
extern char *plugin_dir;

void lib_init();
void add_libdir(const char *dir);
void load_library(const char *lib);

Zone *create_zone(const char *type);

typedef Zone *(*getdynzone_fn)(domainname &dom, domainname *ret);
extern stl_slist(getdynzone_fn) getdynzone_functions;
Zone *lookup_dyn_zone(domainname &dom, domainname *ret);

typedef bool(*feed_setting_fn)(const char *setting, const char *arguments);
extern stl_slist(feed_setting_fn) feed_setting_functions;
bool feed_setting(const char *setting, const char *arguments);

typedef void(*end_setting_fn)(void);
extern stl_slist(end_setting_fn) end_setting_functions;
void end_setting();

#endif /* __POSADIS_LIB_H */
