/***************************************************************************
                          localhost.cpp  -  returns IP address of caller
                             -------------------
    begin                : wo jan 8 2003
    copyright            : (C) 2003 by Meilof
    email                : meilof@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <poslib-config.h>
#include <zones.h>
#include <lib.h>

void delete_localhost_zone(Zone *zn);

class LocalhostZone : public Zone {
 public:
  LocalhostZone() {
    ttl = 7200;
    is_placeholder = false;
    deletefn = (deletefn_t)delete_localhost_zone;
  }
  
  void feed_setting(const char *name, const char *val) {
    if (strcmpi(name, "ttl") == 0) {
      ttl = txt_to_int(val);
    } else if (strcmpi(name, "nslist") == 0) {
      nslist.push_front(domainname(val));
    } else {
      throw PException(true, "Unknown setting %s\n", val);
    }
  }
  
  void add_a(stl_list(DnsRR) &section, domainname &dom, _addr *querier) {
    if (sock_is_ipv4(querier)) {
      section.push_back(DnsRR(dom, DNS_TYPE_A, CLASS_IN, ttl, 4, get_ipv4_ptr(querier)));
#ifdef HAVE_IPV6
    } else if (sock_is_ipv6(querier)) {
      section.push_back(DnsRR(dom, DNS_TYPE_AAAA, CLASS_IN, ttl, 16, get_ipv6_ptr(querier)));
#endif
    }
  }   
  
  void add_ns(stl_list(DnsRR) &sect, domainname &dom) {
    stl_slist(domainname)::iterator it = nslist.begin();
    while (it != nslist.end()) {
      sect.push_back(DnsRR(dom, DNS_TYPE_NS, CLASS_IN, ttl,
                                 it->len(), it->c_str()));
      it++;
    }
  }
  
  _auth_ret stdquery_lookup(pending_query *q, domainname &qname,
                          uint16_t QTYPE, domainname &znroot, DnsMessage *a) {
    if (qname != znroot) {
      a->RCODE = RCODE_NXDOMAIN;
      return step6;
    }
    
    if (QTYPE == DNS_TYPE_NS || QTYPE == QTYPE_ANY) {
      add_ns(a->answers, znroot);
    } else {
      add_ns(a->authority, znroot);
    }

    if (QTYPE == QTYPE_ANY ||
#ifdef HAVE_IPV6
        (sock_is_ipv6(&q->querier) && QTYPE == DNS_TYPE_AAAA) ||
#endif
        (sock_is_ipv4(&q->querier) && QTYPE == DNS_TYPE_A)) {
      add_a(a->answers, qname, &q->querier);
    }

    return step6;
  }
  
  virtual bool additional_lookup(domainname &qname, uint16_t QTYPE,
                                 stl_list(DnsRR)& section,
                                 domainname &znroot, pending_query *qinfo) {
    if (qname != znroot) return true;

    if (QTYPE == DNS_TYPE_NS || QTYPE == QTYPE_ANY) {
      add_ns(section, znroot);
    }

    if (QTYPE == QTYPE_ANY ||
#ifdef HAVE_IPV6
        (sock_is_ipv6(&qinfo->querier) && QTYPE == DNS_TYPE_AAAA) ||
#endif
        (sock_is_ipv4(&qinfo->querier) && QTYPE == DNS_TYPE_A)) {
      add_a(section, znroot, &qinfo->querier);
    }

    return true;
  }
  
  stl_slist(domainname) nslist;
  uint32_t ttl;
 private:
};

void delete_localhost_zone(Zone *zn) {
  delete zn;
}

Zone *create_localhost_zone() {
  return new LocalhostZone();
}

zone_entry localhost_entries[] = {
  { "localhost", create_localhost_zone },
  { "", NULL }
};

extern "C" zone_entry* /*localhost_LTX_*/get_zones() { return localhost_entries; }
