/***************************************************************************
                          primary.cpp  -  primary zones
                             -------------------
    begin                : Tue Dec 24 2002
    copyright            : (C) 2002 by Meilof
    email                : meilof@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "primary.h"
#include "auth_mem.h"
#include "masterfile.h"
#include "configuration.h"
#include "updates.h"
#include "secondary.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

PrimaryZone::PrimaryZone() : AuthMemZone() {
  type = Z_PRIMARY;
  checksum = 0;
  last_ftime = 0;
}

PrimaryZone::~PrimaryZone() {

}

//void start_primaryzone_update(domainname dom, PrimaryZone *zn);

void PrimaryZone::feed_setting(const char *name, const char *val) {
  char fname[PATH_MAX];
  if (strcmpi(name, "reset") == 0) {
    auth_feed_setting("reset", "");
    update_list_unregister(this);
    return;
  } else if (strcmpi(name, "reload") == 0) {
    update_list_unregister(this);
    start_zone_update(getfqdn(), this);
//    start_primaryzone_update(getfqdn(), this);
  }    
  if (auth_feed_setting(name, val)) return;
  if (strcmpi(name, "file") == 0) {
    if (strlen(val) + 1 >= PATH_MAX) throw PException("Master file path too long");
    /* check whether to append mf path */
#ifdef _WIN32
    if (!(strlen(val) >= 3 &&
           ( (val[1] == ':' && val[2] == '\\') || val[1] == '\\' ) )) {
#else
    if (val[0] != '/') {
#endif
      if (strlen(confdir) + strlen(val) + 1 > PATH_MAX) throw PException("Master file path too long");
      strcpy(fname, confdir);
      strcat(fname, val);
    } else strcpy(fname, val);
    zonefile = fname;
  } else {
    throw PException(true, "Unknown option %s", name);
  }
}


void PrimaryZone::end_setting() {
  struct stat statstr;

  if (zonefile.length() == 0) {
    pos_log(context_zonedata, log_error, "Primary zone %s does not have master file attached and thus will not work!", getfqdn().tocstr());
  } else {
//    bool was_loaded = zone_is_loaded;
    uint32_t oldserial = serial;
    domainname dom = getfqdn();

    try {
      if (rootdomain) delete rootdomain;
      rootdomain = new ZoneDomain(NULL, "");
          
      if (stat(zonefile.c_str(), &statstr) == 0 && S_ISREG(statstr.st_mode)) last_ftime = statstr.st_mtime;
      load_master_file(this, dom, zonefile.c_str());

      zone_is_loaded = true;
      
      if (oldserial != serial) start_notification();
    } catch (PException p) {
      zone_is_loaded = false;
      pos_log(context_zonedata, log_error, "primary %s: %s", dom.tocstr(), p.message);
    }
  }

  AuthMemZone::end_setting();
}
