/***************************************************************************
                          recursive.cpp  -  recursive queries
                             -------------------
    begin                : za dec 28 2002
    copyright            : (C) 2002 by Meilof
    email                : meilof@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "recursive.h"
#include "stdquery.h"
#include "cacheapply.h"

#ifdef DEBUG
#ifdef _WIN32
#include <winbase.h>
#else
pthread_t GetCurrentThreadId() { return pthread_self(); }
#endif
void tmpprintf(const char *format, ...) {
  char buff[1024] = "";
  va_list args;
  va_start(args, format);
  vsnprintf(&buff[strlen(buff)], sizeof(buff) - strlen(buff) - 1, format, args);
  va_end(args);
  FILE *f = fopen("log.txt", "a");
  if (!f) return;
  fprintf(f, "(%d):%s", (int)GetCurrentThreadId(), buff);
  fclose(f);
  printf(buff);
}
#endif


void find_closest_nameservers(domainname &dname, domainname &nsdname, RrSet*& nsset) {
  int nl = dname.nlabels(), t;
  stl_string label;
  ZoneDomain *dom = cache_root_domain;
  RrSet *set;

  nsset = dom->get_rrset(DNS_TYPE_NS);

  for (t = nl - 2; t >= 0; t--) {
    label = dname.label(t);
    dom = dom->subitems.get_item(label.c_str());
    if (!dom) break;
    if ((set = dom->get_rrset(DNS_TYPE_NS)) != NULL && set->rrs.count) {
      nsset = set;
      nsdname = dname.from(t);
    }
  }
}

class sysqueryinfo {
 public:
  pending_query q;
  domainname qname;
  uint16_t qtype;
  int patience;
};

void *sysquery_thread(void *_info) {
  sysqueryinfo *info = (sysqueryinfo *)_info;
  try {
    pthread_mutex_lock(&m_auth_zones);
    pthread_mutex_lock(&m_cache);
    sysquery(&info->q, info->qname, info->qtype, info->patience);
  } catch (PException p) { }
  pthread_mutex_unlock(&m_cache);
  pthread_mutex_unlock(&m_auth_zones);
  delete info;
  return NULL;
}

void start_sysquery_thread(pending_query *q, domainname &qname, uint16_t &qtype, int &patience) {
  pthread_t tr;
  sysqueryinfo *info = new sysqueryinfo();
  info->qname = qname;
  info->qtype = qtype;
  info->patience = patience;
  memcpy(&info->q.querier, &q->querier, sizeof(_addr));
  info->q.transport = q->transport;
  posthread_create(&tr, sysquery_thread, info);
}

void start_a_nsquery(pending_query *query, stl_slist(domainname)& lst, int patience) {
  uint16_t qtype = DNS_TYPE_A;

  if (lst.empty()) return;

  stl_slist(domainname)::iterator it = lst.begin();
  int r = possimplerandom() % lst.size();
  while (r) { it++; r--; }
#ifdef DEBUG
    tmpprintf("Starting a NSQUERY for %s:NS\n", (*lst.begin()).tocstr());
#endif
  start_sysquery_thread(query, *it, qtype, patience);
}

_sysquery_result sysquery(pending_query *queryinfo, domainname qname, uint16_t qtype, int &patience) {
  domainname znroot;
  RrSet *rrset;

  /*
   * this is a bit of a hack: if the previous answer we received was a referral, but no
   * addresses are available, we do _not_ want to remove the NS record as we would if
   * it was a referral from our cache (see the comment about removal below)
   *
   * i don't know exactly about the theoretical correctness of this code, and I should
   * probably think that over, but I think this ought to work for most cases
   */
  bool previously_had_a_referral;

sysquery_start:
  previously_had_a_referral = false;
  /* decrement patience pointer */
#ifdef DEBUG
    tmpprintf("Entering sysquery[%s:%d]: patience %d\n", qname.tocstr(), qtype, patience);
#endif
  if (--patience <= 0) {
#ifdef DEBUG
    tmpprintf("Ran out of patience!\n");
#endif
    return srvfail;
  }

  /* step 1: find the NS records */
  find_closest_nameservers(qname, znroot, rrset);
#ifdef DEBUG
  tmpprintf("Found closest nameservers [%s:%s]\n", qname.tocstr(), znroot.tocstr());
  tmpprintf("Rrset: %p\n", rrset);
  tmpprintf("Rrset size: %d\n", rrset->rrs.count);
#endif

  /* check sanity of adresses */
  int n_glue_missing = 0, n_normal_missing = 0;
  domainname nsname;
  stl_slist(_addr) locservers;
  stl_slist(domainname) missing;

  for (int x = 0; x < rrset->rrs.count; x++) {
    nsname = domainname(true, rrset->rrs[x]->rdata);
#ifdef DEBUG
//    tmpprintf("Finding addresses for nameserver %s\n", nsname.tocstr());
#endif
    if (!lookup_adresses_from_local_data(queryinfo, nsname, locservers)) {
      if (nsname >= znroot) n_glue_missing++; else n_normal_missing++;
      missing.push_front(nsname);
    }
  }

  /* check what to do next */
  if (!locservers.empty()) {
    /* addresses available! */
    pos_cliresolver res;
    DnsMessage *q = NULL, *a = NULL;
    _answer_type type;
    try {
#ifndef DEBUG
      start_a_nsquery(queryinfo, missing, max(patience,10));
#endif
      q = create_query(qname, qtype, false);
      pthread_mutex_unlock(&m_cache);
      pthread_mutex_unlock(&m_auth_zones);
      try {
#ifdef DEBUG
        tmpprintf("Querying [start: %s, n=%d]\n", addr_to_string(&*locservers.begin()).c_str(), locservers.size());
#endif      
        res.query(q, a, locservers);
#ifdef DEBUG
        tmpprintf("...done\n");
#endif
      } catch (PException p) {
//stl_slist(_addr)::iterator it = locservers.begin();
//printf("*** Start for %s\n", qname.tocstr());
//while (it != locservers.end()) { printf("- %s\n", addr_to_string(&*it).c_str()); it++; }
//printf("*** Failed: [%s]%s\n", qname.tocstr(), p.message);
#ifdef DEBUG
        printf("query raised an exception[%s]: %s\n", qname.tocstr(), p.message);
#endif
        pthread_mutex_lock(&m_auth_zones);
        pthread_mutex_lock(&m_cache);
        throw p;
      }
      pthread_mutex_lock(&m_auth_zones);
      pthread_mutex_lock(&m_cache);
      type = check_answer_type(a, qname, qtype);
#ifdef DEBUG
      tmpprintf("Answer was %d\n", (int)type);
#endif
      switch (type) {
        case A_ERROR:
          return srvfail;
        case A_CNAME:
          apply_answer_to_cache(a, qname, qtype, znroot, false);
          return cname;        
        case A_ANSWER:
          apply_answer_to_cache(a, qname, qtype, znroot, false);
          return answer;
        case A_REFERRAL:
#ifdef DEBUG
          tmpprintf("The answer was a referral! Let's restart this query!\n");
#endif
          apply_answer_to_cache(a, qname, qtype, znroot, true);
          previously_had_a_referral = true;
          goto sysquery_start;
        case A_NODATA:
#ifdef DEBUG
          tmpprintf("Dealing with a NODATA!\n");
#endif
        case A_NXDOMAIN:
          apply_answer_to_cache(a, qname, qtype, znroot, false);
#ifdef DEBUG
          tmpprintf("Cacheapply succeeded!\n");
#endif
          return noanswer;
      }
    } catch (PException p) {
#ifdef DEBUG
      tmpprintf("Query failed: %s\n", p.message);
#endif
      return srvfail;
    }
  } else {
#ifdef DEBUG
    tmpprintf("No addresses available for the %s nameservers!\n", nsname.tocstr());
#endif

    domainname qdom;

    /* remove the NS for which no information is available
       this is to make sure we don't get stuck with a faulty cache. a real-life
       situation is this:
         com nameservers: *.gtld-servers.net
         gtld-servers.net nameservers: *.nstld.com
       in this case, if the gtld-servers get discarded (which is not likely, but
       it's possible anyway), and the nstld ones as well, we can get a query looping
       between those two if we don't do this. it's at the expense of some extra
       queries, but it should be worth it */       
    if (!previously_had_a_referral) {
      ZoneDomain *ns_dom = lookup_domainname(cache_root_domain, root_domain_name, znroot);
#ifdef DEBUG
      printf("Removing {%s,NS}(%p,%d)\n", znroot.tocstr(),ns_dom,ns_dom->rrsets.count);
#endif
      if (ns_dom) ns_dom->remove_rrset(DNS_TYPE_NS);
    }
#ifdef DEBUG
    else printf("Domain name %s is spared: previously a referral\n", znroot.tocstr());
#endif

    if (n_glue_missing > 0) {
      /* there is glue delegation missing. do a sysquery() for the missing glue */
      sysquery(queryinfo, znroot, DNS_TYPE_NS, patience);
#ifdef DEBUG
      tmpprintf("Sysquery() returned for internal glue for %s.\n", znroot.tocstr());
#endif
      goto sysquery_start;
    } else {
      /* there is no missing glue. initiate a sysquery() for address information of a nameserver */
      stl_slist(domainname)::iterator it = missing.begin();
      int r = possimplerandom() % missing.size();
#ifdef DEBUG
     tmpprintf("Random: %d[%d]\n", r, missing.size());
#endif
      while (r) { it++; r--; }
      qdom = *it;
      sysquery(queryinfo, qdom, DNS_TYPE_A, patience);
#ifdef DEBUG
      tmpprintf("Sysquery() returned for external NS %s.\n", qdom.tocstr());
#endif
      goto sysquery_start;
    }
  }
  return srvfail;
}
