/***************************************************************************
                          resolver.h  -  resolver functions
                             -------------------
    begin                : do dec 26 2002
    copyright            : (C) 2002 by Meilof
    email                : meilof@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __POSADIS_RESOLVER_H
#define __POSADIS_RESOLVER_H

#include <poslib/poslib.h>
#include <poslib/server/server.h>
#include "zones.h"

/* cache statistics */
extern int n_cache_doms, delta_n_cache_doms,
           n_cache_hits, delta_n_cache_hits,
           n_cache_misses, delta_n_cache_misses;

/* cache cleanup (called by scheduler) */
void cache_cleanup();

/* add glue information from authoritative zone to the cache */
void add_glue_to_cache(domainname &root, ZoneDomain *zdom);

/* add delegation information from cache */
void add_cache_delegation(domainname &dom, DnsMessage *msg, uint16_t type = DNS_TYPE_NS);

/* adds a rr set to a dns message */
void add_set_to_message(domainname &dname, RrSet *set, stl_list(DnsRR) &section, bool check = false);
void add_sets_to_message(domainname &dom, ZoneDomain *zdom, uint16_t type, stl_list(DnsRR) &sec);

/* looks up data for the additional section from local data */
//ZoneDomain *lookup_domain_from_local_data(domainname &dom, uint16_t rrtype);
bool lookup_adresses_from_local_data(pending_query *qinfo, domainname &dom, stl_slist(_addr)& addresses);
void lookup_from_local_data(domainname &dom, uint16_t qtype, stl_list(DnsRR) &section, pending_query *qinfo);

/* which zone has the longest dname (both may be NULL) */
Zone *best_zone(Zone *zn, domainname &znroot, Zone *zn2, domainname &dom2);

DnsRR *get_soa_rr(domainname &dom, stl_list(DnsRR) &ls);

enum _cache_ret { RET_NOINFO, RET_CNAME, RET_NOERROR };
_cache_ret query_cache(domainname &quest, uint16_t rrtype, DnsMessage *a, RrSet **ret = NULL);

/* returns true if a CNAME was encountered */
bool cache_lookup(pending_query *queryinfo, DnsMessage *a, domainname &quest, uint16_t rrtype);

#endif /* __POSADIS_RESOLVER_H */
