/***************************************************************************
                          formap.cpp  -  forward mapping
                             -------------------
    begin                : do jan 2 2003
    copyright            : (C) 2003 by Meilof
    email                : meilof@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <poslib/poslib.h>
#include "formap.h"

void delete_formap_zone(FormapZone *zn) {
  delete zn;
}

FormapZone::FormapZone() : Zone() {
  ttl = 7200;
  is_placeholder = false;
  deletefn = (deletefn_t)delete_formap_zone;
}

void FormapZone::feed_setting(const char *name, const char *val) {
  if (strcmpi(name, "ttl") == 0) {
    ttl = txt_to_int(val);
  } else if (strcmpi(name, "nslist") == 0) {
    nslist.push_front(domainname(val));
  } else {
    throw PException(true, "Unknown setting %s\n", name);
  }
}

void FormapZone::add_ns(stl_list(DnsRR) &section, domainname &dom) {
  stl_slist(domainname)::iterator it = nslist.begin();
  while (it != nslist.end()) {
    section.push_back(DnsRR(dom, DNS_TYPE_NS, CLASS_IN, ttl,
                               it->len(), it->c_str()));
    it++;
  }
}

#define hexint(a) ( (a >= 'a' && a <= 'f') ? a - 'a' + 10 : a - '0' )
#define hexip(a, b) ( (hexint(a) * 16) + hexint(b) )

void FormapZone::add_a(stl_list(DnsRR) &section, domainname &znroot, domainname &query) {
  stl_string label = query.label(0);
  
  if (label.size() == 8) {
    const char *ptr = label.c_str();
    char ip[4];
    ip[0] = hexip(ptr[0], ptr[1]);
    ip[1] = hexip(ptr[2], ptr[3]);
    ip[2] = hexip(ptr[4], ptr[5]);
    ip[3] = hexip(ptr[6], ptr[7]);

    section.push_back(DnsRR(query, DNS_TYPE_A, CLASS_IN, ttl, 4, ip));
  }
}

void FormapZone::add_aaaa(stl_list(DnsRR) &section, domainname &znroot, domainname &query) {
#ifdef HAVE_IPV6
  stl_string label = query.label(0);

  if (label.size() == 32) {
    const char *ptr = label.c_str();
    char ip6[16];
    for (int t = 0; t < 16; t++) ip6[t] = hexip(ptr[t*2], ptr[t*2+1]);
    section.push_back(DnsRR(query, DNS_TYPE_AAAA, CLASS_IN, ttl, 16, ip6));
  }
#endif /* HAVE_IPV6 */
}

_auth_ret FormapZone::stdquery_lookup(pending_query *q, domainname &qname,
                          uint16_t QTYPE, domainname &znroot, DnsMessage *a) {
  if ((QTYPE == DNS_TYPE_NS || QTYPE == QTYPE_ANY) && qname == znroot) {
    add_ns(a->answers, znroot);
  } else {
    add_ns(a->authority, znroot);
  }

  if (QTYPE == QTYPE_ANY || QTYPE == DNS_TYPE_A) {
    add_a(a->answers, znroot, qname);
  }

  if (QTYPE == QTYPE_ANY || QTYPE == DNS_TYPE_AAAA) {
    add_aaaa(a->answers, znroot, qname);
  }

  return step6;
}

bool FormapZone::additional_lookup(domainname &qname, uint16_t QTYPE,
                                 stl_list(DnsRR)& section,
                                 domainname &znroot, pending_query *qinfo) {
  if ((QTYPE == DNS_TYPE_NS || QTYPE == QTYPE_ANY) && qname == znroot) {
    add_ns(section, znroot);
  }

  if (QTYPE == QTYPE_ANY || QTYPE == DNS_TYPE_A) {
    add_a(section, znroot, qname);
  }

  if (QTYPE == QTYPE_ANY || QTYPE == DNS_TYPE_AAAA) {
    add_aaaa(section, znroot, qname);
  }

  return true;
}
