/***************************************************************************
                          revmap.cpp  -  reverse mapping zone
                             -------------------
    begin                : do jan 2 2003
    copyright            : (C) 2003 by Meilof
    email                : meilof@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <poslib/poslib.h>
#include "revmap.h"

void delete_revmap_zone(RevmapZone *zn) {
  delete zn;
}

RevmapZone::RevmapZone() : Zone() {
  ttl = 7200;
  is_placeholder = false;
  deletefn = (deletefn_t)delete_revmap_zone;
}

void RevmapZone::feed_setting(const char *name, const char *val) {
  if (strcmpi(name, "prefix") == 0) {
    prefix = domainname(val);
  } else if (strcmpi(name, "nslist") == 0) {
    nslist.push_front(domainname(val));
  } else if (strcmpi(name, "ttl") == 0) {
    ttl = txt_to_int(val);
  } else {
    throw PException(true, "Unknown option %s\n", name);
  }
}

void RevmapZone::add_ns(stl_list(DnsRR) &section, domainname &dom) {
  stl_slist(domainname)::iterator it = nslist.begin();
  while (it != nslist.end()) {
    section.push_back(DnsRR(dom, DNS_TYPE_NS, CLASS_IN, ttl,
                               it->len(), it->c_str()));
    it++;
  }
}

void RevmapZone::add_ptr(stl_list(DnsRR) &section, domainname &znroot, domainname &query) {
  if (query.nlabels() == 7) {
    char ip[4];
    char label[20];
    domainname ret;
    try {
      ip[0] = txt_to_int(query.label(3).c_str());
      ip[1] = txt_to_int(query.label(2).c_str());
      ip[2] = txt_to_int(query.label(1).c_str());
      ip[3] = txt_to_int(query.label(0).c_str());
      sprintf(label, "%02x%02x%02x%02x", ip[0], ip[1], ip[2], ip[3]);
      ret = domainname(label) + prefix;
      section.push_back(DnsRR(query, DNS_TYPE_PTR, CLASS_IN, ttl,
                              ret.len(), ret.c_str()));
    } catch (PException p) {
      return;
    }
#ifdef HAVE_IPV6
  } else if (query.nlabels() == 35) {
    char label[33];
    label[32] = 0;
    for (int t = 31; t >= 0; t--) {
      label[31 - t] = query.label(t).c_str()[0];
    }
    domainname ret = domainname(label) + prefix;
    section.push_back(DnsRR(query, DNS_TYPE_PTR, CLASS_IN, ttl,
                            ret.len(), ret.c_str()));
#endif
  }
}

_auth_ret RevmapZone::stdquery_lookup(pending_query *q, domainname &qname,
                          uint16_t QTYPE, domainname &znroot, DnsMessage *a) {
  if ((QTYPE == DNS_TYPE_NS || QTYPE == QTYPE_ANY) && qname == znroot) {
    add_ns(a->answers, znroot);
  } else {
    add_ns(a->authority, znroot);
  }

  if (QTYPE == QTYPE_ANY || QTYPE == DNS_TYPE_PTR) {
    add_ptr(a->answers, znroot, qname);
  }

  return step6;
}

bool RevmapZone::additional_lookup(domainname &qname, uint16_t QTYPE,
                                 stl_list(DnsRR)& section,
                                 domainname &znroot, pending_query *qinfo) {
  if ((QTYPE == DNS_TYPE_NS || QTYPE == QTYPE_ANY) && qname == znroot) {
    add_ns(section, znroot);
  }

  if (QTYPE == QTYPE_ANY || QTYPE == DNS_TYPE_PTR) {
    add_ptr(section, znroot, qname);
  }

  return true;
}

