/***************************************************************************
                          revmap.h  -  reverse-mapping zone
                             -------------------
    begin                : do jan 2 2003
    copyright            : (C) 2003 by Meilof
    email                : meilof@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __REVMAP_H
#define __REVMAP_H

#include "zones.h"

class RevmapZone : public Zone {
 public:
  RevmapZone();
  _auth_ret stdquery_lookup(pending_query *q, domainname &qname,
                          uint16_t QTYPE, domainname &znroot, DnsMessage *a);
  virtual bool additional_lookup(domainname &qname, uint16_t qtype,
                                 stl_list(DnsRR)& section,
                                 domainname &znroot, pending_query *qinfo);
  void feed_setting(const char *name, const char *val);
  domainname prefix;
  stl_slist(domainname) nslist;
  uint32_t ttl;
 private:
  void add_ptr(stl_list(DnsRR) &section, domainname &znroot, domainname &query);
  void add_ns(stl_list(DnsRR) &sect, domainname &dom);
};


#endif /* __REVMAP_H */
