/***************************************************************************
                          secondary.h  -  secondary dns
                             -------------------
    begin                : wo mei 14 2003
    copyright            : (C) 2003 by Meilof
    email                : meilof@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __POSADIS_SECONDARY_H
#define __POSADIS_SECONDARY_H

#include "auth_mem.h"

class SecondaryZone: public AuthMemZone {
 public:
  SecondaryZone();
  ~SecondaryZone();

  virtual void feed_setting(const char *name, const char *val);
  virtual void end_setting();

  postime_t loadtime;

  stl_slist(_addr) masters;
  stl_slist(addrrange) allow_notify_from;

  bool update_busy;
  stl_list(_addr) pending_updates;
};

void start_secondaryzone_update(domainname znroot, SecondaryZone *data);
void start_secondaryzone_update_thread(domainname znroot, SecondaryZone *zn);

DnsMessage *answer_notify(pending_query *q);
bool zone_is_valid(domainname &znroot, Zone *zn);

#endif /* __POSADIS_SECONDARY_H */
