/***************************************************************************
                          stdquery.cpp  -  standard queries
                             -------------------
    begin                : wo dec 25 2002
    copyright            : (C) 2002 by Meilof
    email                : meilof@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#include "configuration.h"
#include "query.h"
#include "stdquery.h"
#include "zones.h"
#include "resolver.h"
#include "lib.h"

void do_asp(DnsMessage *a, stl_list(DnsRR) &rrs, pending_query *qinfo);

DnsMessage *answer_stdquery(pending_query *q) {
  Zone *zn, *zn2, *zn3;
  DnsQuestion *quest = &*q->message->questions.begin();
  DnsMessage *a = new DnsMessage();
  a->questions.push_front(*quest);
  a->ID = q->message->ID;
  domainname znroot, dom2;
  domainname qname;
  int rec_level = max_cname_recursion;
  _auth_ret ret;
  bool bret;
  
  if (quest->QCLASS != CLASS_IN) return srvfail(q->message, a, RCODE_NOTIMP);

  /* allright, now our RFC-compilant (well, mostly anyway) lookup */

//   1. Set or clear the value of recursion available in the response
//      depending on whether the name server is willing to provide
//      recursive service.  If recursive service is available and
//      requested via the RD bit in the query, go to step 5,
//      otherwise step 2.
  /* in our algorithm, both are handled in step 4 */
  a->RD = q->message->RD;
  if (provide_recursion(&q->querier)) a->RA = true;

  qname = quest->QNAME;
  pthread_mutex_lock(&m_auth_zones);

query_step_1:
  if (--rec_level <= 0) {
    a->RCODE = RCODE_SRVFAIL;
    pthread_mutex_unlock(&m_auth_zones);
    goto query_step_6;
  }
  
//   2. Search the available zones for the zone which is the nearest
//      ancestor to QNAME.  If such a zone is found, go to step 3,
//      otherwise step 4.
  zn = lookup_authoritative_zone(qname, &znroot, false);
  zn2 = lookup_dyn_zone(qname, &dom2);
  zn3 = best_zone(zn, znroot, zn2, dom2);
  if (!zn3) goto query_step_4;
  if (zn3 == zn2) znroot = dom2;

  a->AA = true;
  try {
    ret = zn3->stdquery_lookup(q, qname, quest->QTYPE, znroot, a);
  } catch (PException p) {
    if (zn2) delete zn2;
    throw p;
  }
  if (zn2) delete zn2;

  switch (ret) {
    case step1: /* cname: start again */
      goto query_step_1;
    case step4: /* referral: look in cache */
      goto query_step_4;
    case step6: /* done: additional section processing */
      goto query_step_6;
  }
  
query_step_4:
//   4. Start matching down in the cache.  If QNAME is found in the
//      cache, copy all RRs attached to it that match QTYPE into the
//      answer section. Go to step 6. If there was no delegation from
//      authoritative data, look for the best one from the cache, and
//      put it in the authority section.
//   5. Using the local resolver or a copy of its algorithm (see
//      resolver section of this memo) to answer the query.  Store
//      the results, including any intermediate CNAMEs, in the answer
//      section of the response.
  bret = false;
  pthread_mutex_lock(&m_cache);
  try { bret = cache_lookup(q, a, qname, quest->QTYPE); }
  catch (PException p) { }
  pthread_mutex_unlock(&m_cache);
  if (bret == true) {
    /* apparently a CNAME */
#ifdef DEBUG
    printf("Got CNAME for %s\n", qname.tocstr());
#endif
    stl_list(DnsRR)::iterator it = a->answers.end();
    it--;
    qname = domainname(true, it->RDATA);
#ifdef DEBUG
    printf("New qname %s\n", qname.tocstr());
#endif
    goto query_step_1;
  }
  if (a->RD == true && a->RCODE == RCODE_SRVFAIL) {
    /* if we have an error in the resolving process, don't answer at all.
       the rationale behind this is that if the only dns server posadis
       has an address from at one point causes a failure (like we saw
       with citysoftware.com.au), posadis will not finalize the query
       by sending a SRVFAIL, but rather wait for the client to retry */
    delete a;
    a = NULL;
  }
  if (!a || a->RCODE != RCODE_NOERROR) goto query_exit;
query_step_6:
//   6. Using local data only, attempt to add other RRs which may be
//      useful to the additional section of the query.  Exit.  
  pthread_mutex_lock(&m_cache);
  do_asp(a, a->answers, q);
  do_asp(a, a->authority, q);    
  pthread_mutex_unlock(&m_cache);
query_exit:
  pthread_mutex_unlock(&m_auth_zones);
  return a;
}

/* additional section processing courtesy of Posadis SANS (posadis.org/sans/) */

void do_asp(DnsMessage *a, stl_list(DnsRR) &rrs, pending_query *qinfo) {
  rr_type *rrinfo;
  char *prop;
  stl_list(DnsRR)::iterator it;
  domainname tmp;

  it = rrs.begin();
  while (it != rrs.end()) {
    rrinfo = rrtype_getinfo(it->TYPE);
    if (rrinfo && (rrinfo->flags & R_ASP)) {
      prop = rrinfo->properties;
      while (*prop) {
        if (*prop == 'd') {
          tmp = rr_getdomain(it->RDATA, it->TYPE, prop - rrinfo->properties);
          if (!has_rrset(a->additional, tmp, DNS_TYPE_A) &&
              !has_rrset(a->additional, tmp, DNS_TYPE_AAAA) &&
              !has_rrset(a->additional, tmp, DNS_TYPE_A6)) {
            lookup_from_local_data(tmp, DNS_TYPE_A, a->additional, qinfo);
            lookup_from_local_data(tmp, DNS_TYPE_AAAA, a->additional, qinfo);
            lookup_from_local_data(tmp, DNS_TYPE_A6, a->additional, qinfo);
          }
        }
        prop++;
      }
    }
    it++;
  }
}
