/***************************************************************************
                          updates.h  -  update scheduler
                             -------------------
    begin                : vr mei 16 2003
    copyright            : (C) 2003 by Meilof
    email                : meilof@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __POSADIS_UPDATES_H
#define __POSADIS_UPDATES_H

#include <poslib/poslib.h>
#include "zones.h"

#ifdef _WIN32
#include <windows.h>
extern HANDLE logfile_fd;
#endif

void open_new_logfile();
 
typedef void(*update_function)(domainname dom, void *data);

/* both require m_auth_zones lock */
void update_list_unregister(Zone *z);
void enqueue_update(postime_t when, domainname &dom, Zone *z, update_function fn);

void my_cleanup();

void start_zone_update(domainname dom, Zone *zn);

#endif /* __POSADIS_UPDATES_H */

