/*
    Posadis - A DNS Server
    A simple vector class using class templates
    Copyright (C) 2001  Meilof Veeningen <meilof@users.sourceforge.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __POSADIS_VECTOR_H
#define __POSADIS_VECTOR_H

const double vector_buffmargin = 1.25;

template <class TYPE> class pvector {
  public:
    TYPE *data;
    int count;
    int realsize;

    pvector() {
    	data = NULL;
    	count = 0;
    	realsize = 0;
    }

    ~pvector() {
    	destroy();
    }

    void destroy(bool dodelete = true) {
     if (dodelete)
        for (int t = 0; t < count; t++)
          delete data[t];

    	delete data;
    	data = NULL;
    	count = 0;
      realsize = 0;
    }

    TYPE& operator[] (int i) {
    	return data[i];
    }

    void enlarge() {
    	if (++count >= realsize) {
    		realsize = (int) ((double)count * vector_buffmargin) + 16;
    		data = (TYPE *)realloc(data, sizeof(TYPE) * realsize);
    	}
    }

    void shrink() {
		--count;
   		if ( ((double)realsize / vector_buffmargin) >= count ) {
    		realsize = count;
   			data = (TYPE *)realloc(data, sizeof(TYPE) * realsize);
   		}
  	}

    int add(TYPE _data) {
    	enlarge();
        data[count-1] = _data;
        return 0;
    }

    int addstart(TYPE _data) {
    	int t;
    	enlarge();

		for (t = count - 1; t > 0; t++) data[t] = data[t - 1];
		data[0] = _data;
		return 0;
    }

    int removeitem(TYPE _data, bool dodelete = true) {
        int t;
        for (t = 0; t < count; t++) if (data[t] == _data) return removeindex(t, dodelete);
        return -1;
    }

    int removeindex(int ix, bool dodelete = true) {
        int x;
        TYPE dat = data[ix];
        if (ix >= count) return -1;
        for (x = ix; x < count - 1; x++) data[x] = data[x+1];
        shrink();
        /* should be done after removing it from the list, because destructors
           may call removeitem, which would call the destructor, which would
           in turn call removeitem, etcetera */

        if (dodelete && dat) delete dat;
        return 0;
    }
};

#endif /* __POSADIS_VECTOR_H */

