/***************************************************************************
                          zones.h  -  zones
                             -------------------
    begin                : Sun Dec 22 2002
    copyright            : (C) 2002 by Meilof
    email                : meilof@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __POSADIS_ZONES_H
#define __POSADIS_ZONES_H

#include <poslib/poslib.h>
#include <poslib/server/server.h>
#include "hashvector.h"
#include "vector.h"

#define TTL_MAX_AUTHORITIVE 499999999
#define TTL_NOVAL           500000000

class RrData {
 public:
  RrData();
  RrData(RrData *dat); // copies the argument
  RrData(uint16_t _rdlength, const char *_rdata); // copies the argument
  ~RrData();
  uint16_t rdlength;
  char *rdata;
};

class RrSet {
 public:
  RrSet(uint16_t type);
  void clean();
  void add_rr(uint32_t _ttl, uint16_t _rdlength, const char *_rdata);
  bool expired();
  uint16_t type;
  uint32_t ttl;
  pvector<RrData *> rrs;
};

class ZoneDomain {
 public:
  ZoneDomain(ZoneDomain *parent, const char *name);
  ~ZoneDomain();
  char *name;
  hashvector<ZoneDomain *> subitems;
  pvector<RrSet *> rrsets;
  union {
    uint32_t ncache_time; /* expiration time for domain names with no rr sets*/
  } ext;

  ZoneDomain *parent;
  
  /* caching status: 0=nothing yet, 1=never remove, 2=can be removed */
  char registered;
  union {
    struct {
      ZoneDomain *prev;
      ZoneDomain *next;
    } cache;
  } i;

  void cache_register();
  void cache_unreg();
  void cache_top();
  void cache_bottom();
  void cache_donotremove();

  void removeme();

  RrSet *get_rrset(uint16_t type);
  RrSet *create_rrset(uint16_t type);
  void remove_rrset(uint16_t type);
  void remove_old_rrsets();

  domainname getfqdn();
};

/* base zone for both cache and authoritative zones */
class BaseZone {
 public:
  BaseZone();
  BaseZone(const char *name);
  virtual ~BaseZone();
  BaseZone *parent;
  domainname getfqdn();
  char *name;
  hashvector<BaseZone *> subitems;
  bool is_placeholder;
};

void remove_base_zone(domainname &dom, BaseZone ** root);
BaseZone *lookup_base_zone(domainname &dom, domainname *ret, BaseZone *root, bool may_be_placeholder);
void add_base_zone(domainname &dom, BaseZone *z, BaseZone** root);

/* authoritative zone types */
enum ZoneType { Z_NONE, Z_PRIMARY, Z_SECONDARY };
enum _auth_ret { step1, step4, step6 };

class Zone;
typedef void(*deletefn_t)(Zone *z);

class Zone : public BaseZone {
 public:
  Zone();
  Zone(const char *name);
  virtual ~Zone();
  ZoneType type;
  virtual _auth_ret stdquery_lookup(pending_query *q, domainname &qname,
                          uint16_t QTYPE, domainname &znroot, DnsMessage *a);
  virtual bool additional_lookup(domainname &qname, uint16_t qtype,
                                 stl_list(DnsRR)& section,
                                 domainname &znroot, pending_query *qinfo);
  virtual void feed_setting(const char *name, const char *val);
  virtual void end_setting();
  deletefn_t deletefn;

  time_t last_ftime;
  stl_string zonefile;
};

void delete_zone(Zone *z);

extern pthread_mutex_t m_auth_zones;
extern Zone *auth_root_zone;

/* zone maintenance */
Zone *lookup_authoritative_zone(domainname &dom, domainname *ret, bool may_be_placeholder);
void add_authoritative_zone(domainname &dom, Zone *z);

/* cache zone type */

class CacheZone : public BaseZone {
 public:
  CacheZone();
  CacheZone(const char *name);
  virtual ~CacheZone();
  stl_slist(_addr) *forwarders;
};

/* cache zone maintenance */

CacheZone *lookup_cache_zone(domainname &dom, domainname *ret, bool may_be_placeholder);
void add_cache_zone(domainname &dom, CacheZone *z);

extern pthread_mutex_t m_cache;
extern CacheZone *cache_root_zone;
extern ZoneDomain *cache_root_domain;
extern domainname root_domain_name;
extern ZoneDomain *zd_first;
extern ZoneDomain *zd_last;

/* domain name maintenance */
#define ZF_MUSTCREATE 1
#define ZF_DONOTREMOVE 2
ZoneDomain *create_domainname(ZoneDomain *zdom, const domainname &root, domainname &dom, int flags = 0);
ZoneDomain *lookup_domainname(ZoneDomain *zdom, const domainname &root, domainname &dom);

void *zones_reload(void *data); /* thread to reload all auth zones */

void zones_init();


#endif /* __POSADIS_ZONES_H */
