/***************************************************************************
                          poshost.cpp  -  basic query program
                             -------------------
    begin                : di jul 29 2003
    copyright            : (C) 2003 by Meilof
    email                : meilof@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <poslib/poslib.h>
#include <posadis-config.h>
#include "answertostring.cpp"
#include "getdnsservers.cpp"

#include <stdio.h>


int main(int argc, char **argv) {
  DnsMessage *q = NULL, *a = NULL;
  domainname qname;
  uint16_t qtype = 0;
  stl_slist(_addr) servers;
  _addr tmp;
  bool s_given = false;
  int x = 0;
  pos_cliresolver res;

  try {
    for (int t = 1; t < argc; t++) {
      if (argv[t][0] == '@') {
        txt_to_addr(&tmp, argv[t] + 1);
        servers.push_front(tmp);
        s_given = true;
      } else if (argv[t][0] == '-' && argv[t][1] == '-') {
        if (strcmpi(argv[t], "--help") == 0) {
          printf("poshost - Basic query program\n\n"
                 "Usage:\n"
                 "  poshost [@server] [domainname] [querytype]\n\n"
                 "'server' is the server to query, which is the system resolver (unix)\n"
                 "or localhost (windows) by default. 'domainname' is the domain name to\n"
                 "query, where 'querytype' is a RR type or query type such as 'any'.\n"
                 "By default, poshost does a query for {.,NS}.\n");
          return 0;
        } else if (strcmpi(argv[t], "--version") == 0) {
          printf("poshost - $Revision $\n");
          return 0;
        } else {
          throw PException(true, "Command-line option %s not supported! Use poshost --help for more information.", argv[t]);
        }
      } else {
        if (++x == 1) {
          /* qname */
          qname = argv[t];
        } else if (x == 2) {
          /* qtype */
          qtype = qtype_getcode(argv[t]);
        } else {
          throw PException("No more command-line arguments (%s) expected! Use poshost --help for more information.", argv[t]);
        }
      }
    }
    if (x == 0) {
      qname = ".";
      qtype = DNS_TYPE_NS;
    } else if (x == 1) {
      if (qname >= "in-addr.arpa" || qname >= "ip6.int" || qname >= "ip6.arpa")
        qtype = DNS_TYPE_PTR;
      else
        qtype = DNS_TYPE_A;
    }

    if (!s_given) {
      try {
        servers = get_os_dns_servers();
      } catch(PException p) {
        _addr tmp;
        txt_to_addr(&tmp, "127.0.0.1", DNS_PORT);
        servers.clear();
        servers.push_front(tmp);

        printf("*** Error: %s. Falling back to 127.0.0.1.\n", p.message);
      }
    } else servers.reverse();


    /* do query */
    printf("Querying %s for {%s,%s}\n", addrs_to_string(servers).c_str(), qname.tocstr(), str_qtype(qtype).c_str());
    q = create_query(qname, qtype, true);
    res.query(q, a, servers);
    
    /* print it out */
    printf("\n");
    stl_list(stl_string) answer = answer_to_simple_string(a, addrs_to_string(servers).c_str());
    stl_list(stl_string)::iterator it = answer.begin();
    
    while (it != answer.end()) {
      printf("%s\n", it->c_str());
      it++;
    }

    return 0;
  } catch (PException p) {
    printf("*** Query failed: %s\n", p.message);
    if (q) delete q;
    if (a) delete a;
    return 1;
  }
  if (q) delete q;
  if (a) delete a;
}
