/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml;

import com.gentleware.jboogie.layout.LayoutableElement;
import com.gentleware.jboogie.model_management.DiAccessory;
import com.gentleware.openapi.configuration.Configuration;
import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.poseidon.generator.ui.DialogController;
import com.gentleware.poseidon.model_management.DocumentationManager;
import com.gentleware.poseidon.uml.UmlProject;
import com.gentleware.poseidon.uml.model_management.Uml1SmAccessory;
import com.gentleware.poseidon.uml.ui.documentation.D;
import com.gentleware.poseidon.uml.ui.documentation.JavaDocTagProvider;
import com.gentleware.poseidon.uml.ui.documentation.docEditor.kernel.DocEditorUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jmi.reflect.RefObject;
import org.apache.log4j.Logger;
import org.netbeans.jmiimpl.omg.uml.foundation.core.CommentImpl;
import org.netbeans.jmiimpl.omg.uml2.diagraminterchange.DiagramImpl;
import org.omg.uml.foundation.core.Attribute;
import org.omg.uml.foundation.core.Comment;
import org.omg.uml.foundation.core.ModelElement;
import org.omg.uml.foundation.core.Operation;
import org.omg.uml.foundation.core.Parameter;
import org.omg.uml.foundation.datatypes.ParameterDirectionKindEnum;
import org.omg.uml2.core2.Type;
import org.omg.uml2.diagraminterchange.Diagram;

public class UmlDocumentationManager
extends DocumentationManager {
    private static final Logger D = Logger.getLogger("com.gentleware.poseidon.uml.UmlDocumentationManager");
    public static final String umlNoteOpenerPre = "<ID=\"UML note. note-id=[";
    public static final String umlNoteOpenerPost = "] \">";
    public static final String umlNoteCloser = "<BR></ID>";
    public static final String umlConstraintOpenerPre = "<ID=\"UML constraint. constraint-id=[";
    public static final String umlConstraintOpenerPost = "] \">";
    public static final String umlConstraintOpener = "<ID=\"UML constraint. Changes will be overwritten.\">";
    public static final String umlConstraintCloser = "<BR></ID>";
    private final UmlProject C;
    public static final String TagUUID = "element.uuid";
    public static final String TAG_DOCUMENTATION = "documentation";
    private static final String A = "\n@poseidon-type ";
    private static final String B = "\n";

    public UmlDocumentationManager(UmlProject umlProject) {
        this.C = umlProject;
    }

    protected UmlProject getProject() {
        return this.C;
    }

    public static boolean documentAuthors() {
        Configuration configuration = Services.getInstance().getConfiguration();
        return configuration.getBoolean(DialogController.DOCUMENT_AUTHORS, true);
    }

    public String getHTMLDocs(Object object, String string) {
        return this.getHTMLDocs(object, true, string);
    }

    public String getHTMLDocs(Object object, boolean bl, String string) {
        String string2;
        String string3 = "";
        this.getProject().getDiAccessory();
        if (!DiAccessory.isModelElementStillValid((RefObject)((RefObject)object))) {
            return string3;
        }
        if (object instanceof ModelElement || object instanceof Diagram) {
            string3 = this.getDocsOrNull(object);
            string2 = DocEditorUtils.changeHomePathToTheReal(string3);
            if (string3 != null && !string3.equals(string2)) {
                DocEditorUtils.prepareDocumentationUpdateCommand(this.getProject(), DocEditorUtils.changeImageSrcPathToFictitious(string3), (RefObject)object);
                string3 = string2;
            }
            if (string3 != null) {
                if (!string3.startsWith("<p")) {
                    string3 = this.checkHTMLFormat(string3);
                }
                D.debug("[DocumentationManager.getHTMLDocs].retval=" + string3);
                if (string3.indexOf("*/") > -1) {
                    string3 = this.freeOfDocEnds(string3);
                }
            } else {
                string3 = this.defaultHTMLFor(object);
            }
        }
        string2 = "";
        if (bl) {
            string2 = this.getHTMLJavaDocTags(object);
        }
        String string4 = string3 + string2;
        if (string != null) {
            String string5 = A + string + B;
            string4 = string4 + string5;
        }
        return string4;
    }

    public String getHTMLJavaDocTags(Object object) {
        String string = this.getFormattedParamTags(object);
        String string2 = this.getFormattedJavaDocTags(object);
        return B + string + string2;
    }

    public String getFormattedParamTags(Object object) {
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof Operation) {
            object2 = (Operation)object;
            Iterator iterator = object2.getParameter().iterator();
            while (iterator.hasNext()) {
                Parameter parameter = (Parameter)iterator.next();
                Type type = parameter.getType();
                if (type == null || "void".equals(type.getName())) continue;
                String string = this.getProject().getUml1SmAccessory().getTaggedValue(parameter, TAG_DOCUMENTATION);
                String string2 = "param " + parameter.getName();
                if (parameter.getKind() == ParameterDirectionKindEnum.PDK_RETURN) {
                    this.C.getUml1SmAccessory();
                    boolean bl = Uml1SmAccessory.isConstructor((Operation)object2);
                    if (bl) continue;
                    string2 = "return";
                }
                stringBuffer.append(this.B(string2, UmlDocumentationManager.stripHTMLIntroAndExtro(string)));
            }
        }
        object2 = new String(stringBuffer);
        return object2;
    }

    public String getFormattedJavaDocTags(Object object) {
        List list;
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof ModelElement && (list = JavaDocTagProvider.getPureJavaDocTags()) != null) {
            D d2 = new D(list);
            d2.A(this.getProject().getUml1SmAccessory());
            d2.B((ModelElement)object);
            for (int i2 = 0; i2 < d2.size(); ++i2) {
                String string = d2.C(i2);
                String string2 = d2.B(i2);
                stringBuffer.append(this.B(string, string2));
            }
        }
        return new String(stringBuffer);
    }

    private String B(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        return new String("\n@" + string + " " + string2);
    }

    public static String stripHTMLIntroAndExtro(String string) {
        Matcher matcher;
        Pattern pattern = Pattern.compile("^(?:<p>[\n]*)+(.*?)(?:[\n]*</p>)++[\n]*$", 32);
        String string2 = null;
        if (string != null && (matcher = pattern.matcher(string)).matches()) {
            try {
                string2 = matcher.group(1);
            }
            catch (IllegalStateException illegalStateException) {
                D.info("[UmlDocumentationManager]: No Match: " + pattern.pattern() + " - " + string);
                string2 = null;
            }
        }
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public String getDocsOrNull(Object object) {
        String string;
        Object object2;
        if (object instanceof ModelElement) {
            this.getProject().getDiAccessory();
            if (DiAccessory.isModelElementStillValid((RefObject)((RefObject)object))) {
                object2 = (ModelElement)object;
                string = null;
                try {
                    string = this.C.getUml1SmAccessory().getTaggedValue((ModelElement)object2, TAG_DOCUMENTATION);
                }
                catch (NullPointerException nullPointerException) {
                    D.error("Tagged value read error: model element " + object2.getName() + " id " + object2.refMofId());
                }
                if (string != null) {
                    return string;
                }
            }
        }
        if (object instanceof Diagram) {
            object2 = (DiagramImpl)object;
            string = this.getProject().getStyle().getDocumentation().get((LayoutableElement)object2);
            return string;
        }
        return null;
    }

    public void setDocs(Object object, String string) {
        if (string == null) {
            return;
        }
        String string2 = this.getFormattedDocumentation(string);
        if (object instanceof Diagram) {
            DiagramImpl diagramImpl = (DiagramImpl)object;
            diagramImpl.setProperty((Project)this.C, TAG_DOCUMENTATION, string2);
        } else {
            ModelElement modelElement = (ModelElement)object;
            this.C.getUml1SmHelpers().setTaggedValue(modelElement, TAG_DOCUMENTATION, string2);
        }
    }

    public String getFormattedDocumentation(String string) {
        if (null == string) {
            return "";
        }
        if (string.indexOf("/**") >= 0) {
            string = UmlDocumentationManager.stripBodyEnclosure((String)UmlDocumentationManager.stripLeadingAsterisks((String)string));
        }
        string = this.B(string);
        String string2 = this.removeConstraints(this.removeNotes(this.removeObjectID(string)));
        return string2;
    }

    private String B(String string) {
        if (string == null) {
            return null;
        }
        int n2 = B.length();
        int n3 = string.indexOf(A);
        if (n3 == -1) {
            return string;
        }
        String string2 = string.substring(0, n3);
        int n4 = string.indexOf(B, n3 + 3);
        if (n4 == -1) {
            return string2;
        }
        int n5 = n4 + n2;
        String string3 = string.substring(n5);
        String string4 = string2 + string3;
        return string4;
    }

    private String B(String string, String string2, String string3, String string4) {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(string2);
        int n3 = string.indexOf(string3, n2 + string2.length());
        int n4 = string.indexOf(string4, n3 + string3.length()) + string4.length();
        if (n2 == -1 || n3 == -1 || n4 < string4.length()) {
            return string;
        }
        if (n4 + 2 < string.length() && string.charAt(n4 + 1) == '\n') {
            ++n4;
        }
        String string5 = string.substring(0, n2);
        String string6 = string.substring(n4);
        return this.B(string5 + string6, string2, string3, string4);
    }

    protected String removeNotes(String string) {
        return this.B(string, umlNoteOpenerPre, "] \">", "<BR></ID>");
    }

    protected String removeConstraints(String string) {
        return this.B(string, umlConstraintOpenerPre, "] \">", "<BR></ID>");
    }

    protected List javadocToConstraintsVector(String string) {
        List list = CollectionFactory.createArrayList();
        int n2 = 0;
        int n3 = string.indexOf("] \">", 0);
        while (n3 > -1) {
            int n4 = string.indexOf("<BR></ID>", n2);
            if (n4 > n3) {
                String string2 = string.substring(n3 + "] \">".length(), n4);
                list.add(string2);
            }
            n2 = n4 + "<BR></ID>".length();
            n3 = string.indexOf("] \">", n2);
        }
        return list;
    }

    protected String defaultHTMLFor(Object object) {
        return this.defaultBodyFor(object);
    }

    protected String defaultBodyFor(Object object) {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer("");
        if (object instanceof Attribute) {
            stringBuffer.append("Represents ...");
        }
        if (object instanceof Operation) {
            stringBuffer.append("Does ...");
        }
        if (stringBuffer.length() != 0) {
            return new String("<p>" + stringBuffer + "</p>");
        }
        return new String(stringBuffer);
    }

    protected String getBareNotes(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof ModelElement) {
            Collection collection = ((ModelElement)object).getComment();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                CommentImpl commentImpl = (CommentImpl)iterator.next();
                boolean bl = commentImpl.hasStereotype("gentleware-source-code-comment") || commentImpl.hasStereotype("gentleware-source-file-comment");
                if (bl) continue;
                this.getBareNotesHook(stringBuffer, commentImpl);
            }
        }
        if (stringBuffer.length() == 0) {
            return "";
        }
        return stringBuffer.toString();
    }

    protected void getBareNotesHook(StringBuffer stringBuffer, Comment comment) {
        if (comment.getBody() != null) {
            stringBuffer.append(comment.getBody()).append(B);
        } else {
            stringBuffer.append(B);
        }
    }
}

