/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.generator;

import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.poseidon.ProfileJava;
import com.gentleware.poseidon.generator.PreparationException;
import com.gentleware.poseidon.uml.UmlProject;
import com.gentleware.poseidon.uml.generator.ModelElementPreparator;
import com.gentleware.poseidon.uml.generator.PreparedFeature;
import com.gentleware.poseidon.uml.generator.PreparedParameter;
import com.gentleware.poseidon.uml.model_management.Uml1SmAccessory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.omg.uml.behavioralelements.commonbehavior.UmlException;
import org.omg.uml.foundation.core.Attribute;
import org.omg.uml.foundation.core.Namespace;
import org.omg.uml.foundation.core.Operation;
import org.omg.uml.foundation.core.Parameter;
import org.omg.uml.foundation.datatypes.CallConcurrencyKindEnum;
import org.omg.uml.foundation.datatypes.ScopeKindEnum;

public class PreparedOperation
extends PreparedFeature {
    private static final Logger m = Logger.getLogger("com.gentleware.poseidon.uml.generator.PreparedOperation");
    public static final String STEREOTYPE_INITIALIZER = "initializer";
    public static final String ABSTRACT_STRING = "abstract ";
    public static final String FINAL_STRING = "final ";
    public static final String STATIC_STRING = "static ";
    public static final String SYNCHRONIZED_STRING = "synchronized ";
    public static final String THROWS_STRING = " throws ";
    public static final String NULL_STRING = "null";
    public static final String VOID_STRING = "void";
    protected static final String COMMA_SEPARATOR = ", ";
    private List j;
    private PreparedParameter l;
    private List n = CollectionFactory.createArrayList();
    private static final Map k = CollectionFactory.createHashMap();

    public void init(Operation operation, ModelElementPreparator modelElementPreparator) {
        try {
            super.init(operation, modelElementPreparator);
            if (!this.isAbstract()) {
                this.j = this.K();
            }
            this.J();
        }
        catch (PreparationException preparationException) {
            m.error("Exception caught while preparing operation!", preparationException);
        }
    }

    public List getPreparedParameters() {
        return this.n;
    }

    public boolean isAbstract() {
        if (!(this.getElement() instanceof Operation)) {
            return false;
        }
        return ((Operation)this.getElement()).isAbstract();
    }

    public boolean isNative() {
        String string;
        if (!(this.getElement() instanceof Operation)) {
            return false;
        }
        try {
            string = this.getTaggedValue("native");
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return string != null && "true".equals(string.toLowerCase());
    }

    public String getAbstractAsString() {
        if (this.isAbstract()) {
            return ABSTRACT_STRING;
        }
        return "";
    }

    public String getNativeAsString() {
        String string = null;
        try {
            string = this.getTaggedValue("native");
        }
        catch (NullPointerException nullPointerException) {
            m.error("Tagged value read error: operation " + this.getNameAsString());
        }
        if (string == null) {
            return "";
        }
        if ("true".equals(string)) {
            return "native ";
        }
        return "";
    }

    public String getStrictfpAsString() {
        String string = null;
        try {
            string = this.getTaggedValue("strictfp");
        }
        catch (NullPointerException nullPointerException) {
            m.error("Tagged value read error: operation " + this.getNameAsString());
        }
        if (string == null) {
            return "";
        }
        if ("true".equals(string)) {
            return "strictfp ";
        }
        return "";
    }

    public boolean isLeaf() {
        if (!(this.getElement() instanceof Operation)) {
            return false;
        }
        return ((Operation)this.getElement()).isLeaf();
    }

    public String getLeafAsString() {
        if (this.isLeaf()) {
            return FINAL_STRING;
        }
        return "";
    }

    public String getOwnerScopeAsString() {
        if (!(this.getElement() instanceof Operation)) {
            return "";
        }
        if (ScopeKindEnum.SK_CLASSIFIER == ((Operation)this.getElement()).getOwnerScope()) {
            return STATIC_STRING;
        }
        return "";
    }

    public String getConcurrencyAsString() {
        if (!(this.getElement() instanceof Operation)) {
            return "";
        }
        if (CallConcurrencyKindEnum.CCK_GUARDED.equals(((Operation)this.getElement()).getConcurrency())) {
            return SYNCHRONIZED_STRING;
        }
        return "";
    }

    public boolean isInitializer() {
        Object object = this.getElement();
        if (!(object instanceof Operation)) {
            return false;
        }
        Operation operation = (Operation)object;
        return Uml1SmAccessory.hasStereotype(operation, STEREOTYPE_INITIALIZER);
    }

    public String getThrownExceptionsSignature() {
        if (!(this.getElement() instanceof Operation)) {
            return "";
        }
        Operation operation = (Operation)this.getElement();
        List list = Uml1SmAccessory.getThrownExceptions(operation);
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getNameOfElementAsString(operation.getOwner());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string2;
            UmlException umlException = (UmlException)list.get(i2);
            boolean bl = !Uml1SmAccessory.hasStereotype(umlException, "gentleware-type-unqualified");
            Namespace namespace = umlException.getNamespace();
            if (namespace == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(COMMA_SEPARATOR);
            }
            if ((string2 = this.getNameOfElementAsString(namespace, bl)).startsWith(string + ".")) {
                string2 = string2.substring(string.length() + 1);
            }
            stringBuffer.append(string2);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, THROWS_STRING);
        }
        return stringBuffer.toString();
    }

    public List getPreparedInOutParameters() {
        List list = CollectionFactory.createArrayList((Collection)this.n);
        if (this.l != null) {
            list.remove((Object)this.l);
        }
        return list;
    }

    protected PreparedParameter getReturnParameter() {
        return this.l;
    }

    public String getReturnParameterSignature() {
        if (this.l != null && !this.isConstructor()) {
            if (this.getElement() instanceof Operation) {
                Operation operation = (Operation)this.getElement();
                String string = this.getNameOfElementAsString(operation.getOwner());
                return this.l.getSignature(string);
            }
            return this.l.getSignature();
        }
        return "";
    }

    public String getParametersSignature() {
        String string = this.getNameOfElementAsString(((Operation)this.getElement()).getOwner());
        List list = this.getPreparedInOutParameters();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (i2 > 0) {
                stringBuffer.append(COMMA_SEPARATOR);
            }
            PreparedParameter preparedParameter = (PreparedParameter)((Object)list.get(i2));
            String string2 = preparedParameter.getSignature(string);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String getParameterTypes() {
        List list = this.getPreparedInOutParameters();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (i2 > 0) {
                stringBuffer.append(COMMA_SEPARATOR);
            }
            PreparedParameter preparedParameter = (PreparedParameter)((Object)list.get(i2));
            stringBuffer.append(preparedParameter.getElementType());
        }
        return stringBuffer.toString();
    }

    public String getParameterNames() {
        List list = this.getPreparedInOutParameters();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            PreparedParameter preparedParameter = (PreparedParameter)((Object)list.get(i2));
            if (i2 > 0) {
                stringBuffer.append(COMMA_SEPARATOR);
            }
            stringBuffer.append(preparedParameter.getNameAsString());
        }
        return stringBuffer.toString();
    }

    public List getMethodBody() {
        return this.j;
    }

    public String getDefaultReturnValue() {
        String string = "";
        if (this.hasReturnType()) {
            String string2 = this.getReturnParameter().getElementType();
            string = (String)PreparedOperation.getJavaDefaultReturnValues().get(string2);
            if (string == null) {
                string = NULL_STRING;
            }
        }
        return string;
    }

    public boolean isConstructor() {
        Object object = this.getElement();
        if (!(object instanceof Operation)) {
            return false;
        }
        Operation operation = (Operation)object;
        UmlProject umlProject = this.getProject();
        Uml1SmAccessory uml1SmAccessory = umlProject.getUml1SmAccessory();
        return Uml1SmAccessory.isConstructor(operation);
    }

    public boolean isDestructor() {
        Object object = this.getElement();
        if (!(object instanceof Operation)) {
            return false;
        }
        Operation operation = (Operation)object;
        UmlProject umlProject = this.getProject();
        Uml1SmAccessory uml1SmAccessory = umlProject.getUml1SmAccessory();
        return Uml1SmAccessory.isDestructor(operation);
    }

    public boolean hasReturnType() {
        String string;
        return !this.isConstructor() && this.l != null && !"".equals(string = this.l.getSignature()) && !string.equals(VOID_STRING);
    }

    public boolean isAccessorFor(String string) {
        if (string == null) {
            return false;
        }
        Attribute attribute = this.getProject().getAccessorMethodsHelper().getAccessedAttribute((Operation)this.getElement());
        if (attribute == null) {
            return false;
        }
        return string.equals(attribute.getName());
    }

    public PreparedParameter getPreparedReturnParameter() {
        return this.l;
    }

    protected void addPreparedParameter(PreparedParameter preparedParameter) {
        this.n.add(preparedParameter);
    }

    protected void setPreparedReturnParameter(PreparedParameter preparedParameter) {
        this.l = preparedParameter;
    }

    private void J() throws PreparationException {
        List list = ((Operation)this.getElement()).getParameter();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (parameter == null) continue;
            PreparedParameter preparedParameter = (PreparedParameter)this.getPreparator().prepare((Object)parameter);
            if (preparedParameter.isReturnParameter()) {
                this.setPreparedReturnParameter(preparedParameter);
            }
            this.n.add(preparedParameter);
        }
    }

    private List K() {
        List list = CollectionFactory.createArrayList();
        if (!(this.getElement() instanceof Operation)) {
            return list;
        }
        String string = this.getProject().getUml1SmAccessory().getMethodBody((Operation)this.getElement(), this.getLanguageKey());
        String string2 = "\n\r";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            boolean bl = "".equals(string3.trim()) && !stringTokenizer.hasMoreElements();
            if (bl) continue;
            list.add(string3);
        }
        return list;
    }

    protected String getLanguageKey() {
        return ProfileJava.getJavaLowercase();
    }

    public static Map getJavaDefaultReturnValues() {
        if (k.isEmpty()) {
            k.put("int", "0");
            k.put("char", "\"\"");
            k.put("boolean", "false");
            k.put("byte", "0");
            k.put("long", "0");
            k.put("float", "0.0");
            k.put("double", "0.0");
        }
        return k;
    }
}

