/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.generator;

import com.gentleware.poseidon.generator.PreparationException;
import com.gentleware.poseidon.uml.generator.ModelElementPreparator;
import com.gentleware.poseidon.uml.generator.PreparedClassifier;
import com.gentleware.poseidon.uml.generator.PreparedModelElement;
import com.gentleware.poseidon.uml.model_management.Uml1SmAccessory;
import org.apache.log4j.Logger;
import org.omg.uml.foundation.core.BehavioralFeature;
import org.omg.uml.foundation.core.Classifier;
import org.omg.uml.foundation.core.Parameter;
import org.omg.uml.foundation.datatypes.ParameterDirectionKindEnum;
import org.omg.uml2.core2.Type;

public class PreparedParameter
extends PreparedModelElement {
    private static final Logger Z = Logger.getLogger("com.gentleware.poseidon.uml.generator.PreparedParameter");

    public void init(Parameter parameter, ModelElementPreparator modelElementPreparator) throws PreparationException {
        super.init(parameter, modelElementPreparator);
    }

    public String getElementType() {
        return this.getTypeAsString();
    }

    public boolean isFinal() {
        if (!(this.getElement() instanceof Parameter)) {
            return false;
        }
        String string = "";
        try {
            string = this.getProject().getUml1SmAccessory().getTaggedValue((Parameter)this.getElement(), "final");
        }
        catch (NullPointerException nullPointerException) {
            Z.error("Tagged value read error: parameter " + this.getNameAsString());
        }
        return "true".equals(string);
    }

    public String getFinalAsString() {
        if (this.isFinal()) {
            return "final ";
        }
        return "";
    }

    public boolean isReturnParameter() {
        if (!(this.getElement() instanceof Parameter)) {
            return false;
        }
        return ParameterDirectionKindEnum.PDK_RETURN.equals(((Parameter)this.getElement()).getKind());
    }

    public String getSignature() {
        if (!this.isReturnParameter()) {
            return this.getFinalAsString() + this.getElementType() + " " + this.getNameAsString();
        }
        return this.getElementType();
    }

    public String getSignature(String string) {
        String string2 = this.getElementType();
        if (string2.startsWith(string + ".")) {
            string2 = string2.substring(string.length() + 1);
        }
        if (!this.isReturnParameter()) {
            return this.getFinalAsString() + string2 + " " + this.getNameAsString();
        }
        return string2;
    }

    public boolean isTypePreparedModelElement() {
        return true;
    }

    public PreparedClassifier getPreparedType() {
        if (!(this.getElement() instanceof Parameter)) {
            return null;
        }
        Type type = ((Parameter)this.getElement()).getType();
        if (type == null) {
            return null;
        }
        return (PreparedClassifier)this.getPreparator().getPreparedElement((Object)type);
    }

    public String check() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.check());
        stringBuffer.append(this.checkType());
        return stringBuffer.toString();
    }

    public String checkVisibility() {
        return "";
    }

    protected String checkType() {
        if (!(this.getElement() instanceof Parameter)) {
            return "";
        }
        String string = "";
        Parameter parameter = (Parameter)this.getElement();
        if (!this.isReturnParameter() && (parameter.getType() == null || parameter.getType().getName() == null || "".equals(parameter.getType().getName().trim()))) {
            string = "Illegal type or type name of parameter " + parameter + "\n";
        }
        return string;
    }

    public String getTypeAsString() {
        if (!(this.getElement() instanceof Parameter)) {
            return "";
        }
        Type type = ((Parameter)this.getElement()).getType();
        if (type != null) {
            Classifier classifier;
            String string;
            Parameter parameter = (Parameter)this.getElement();
            boolean bl = !Uml1SmAccessory.hasStereotype(parameter, "gentleware-type-unqualified");
            String string2 = this.getNameOfElementAsString(type, bl);
            BehavioralFeature behavioralFeature = parameter.getBehavioralFeature();
            if (behavioralFeature != null && string2.startsWith((string = this.getNameOfElementAsString((classifier = behavioralFeature.getOwner()).getName())) + ".")) {
                string2 = string2.substring(string.length() + 1);
            }
            return string2;
        }
        return "";
    }
}

