/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.merging;

import com.gentleware.jboogie.kernel.JBoogie;
import com.gentleware.jboogie.kernel.ProjectMember;
import com.gentleware.jboogie.kernel.ProjectMemberReaderWriter;
import com.gentleware.jboogie.util.JBoogieUtils;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.util.ProductVersion;
import com.gentleware.openapi.util.Strings;
import com.gentleware.openapi.util.Utils;
import com.gentleware.poseidon.ProjectConverter;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.merging.LoadException;
import com.gentleware.poseidon.merging.ProjectReaderWriter;
import com.gentleware.poseidon.ui.CoreResourceBundle;
import com.gentleware.poseidon.uml.D;
import com.gentleware.poseidon.uml.UmlProject;
import com.gentleware.poseidon.uml.model_conversion.ProjectConverterImpl;
import com.gentleware.poseidon.uml.xml.XmiLoader;
import com.gentleware.swingx.ProgressDialog;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import javax.jmi.reflect.RefObject;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.netbeans.api.xmi.XMIReader;
import org.omg.uml.modelmanagement.Model;
import org.omg.uml.modelmanagement.ModelClass;

public class XmiProjectReaderWriter
implements ProjectReaderWriter {
    private static final Logger A = Logger.getLogger("com.gentleware.poseidon.uml.merging.XmiProjectReaderWriter");
    protected static final String ARGO_TEE = "/com/gentleware/poseidon/xml/dtd/proj.tee";

    public PoseidonProject createProject() {
        PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getProjectOfType("Uml1");
        return poseidonProject;
    }

    public PoseidonProject loadProject(URL uRL, ProgressDialog progressDialog) throws LoadException {
        PoseidonProject poseidonProject = this.loadProjectIntern(uRL, progressDialog);
        try {
            poseidonProject = ((ProjectConverterImpl)ProjectConverter.get()).convertProjectIfNecessary(poseidonProject, progressDialog);
        }
        catch (IOException iOException) {
            throw new LoadException((Throwable)iOException);
        }
        catch (DocumentException documentException) {
            throw new LoadException((Throwable)documentException);
        }
        return poseidonProject;
    }

    public PoseidonProject loadProjectIntern(URL uRL, ProgressDialog progressDialog) {
        InputStream inputStream = null;
        try {
            PoseidonProject poseidonProject = this.createProject();
            poseidonProject.setUrl(uRL);
            PoseidonProject.fireProjectChanged(null, (PoseidonProject)poseidonProject, (String)"LoadingPrepared");
            poseidonProject.preLoad();
            inputStream = new BufferedInputStream(uRL.openStream());
            this.A((UmlProject)poseidonProject, uRL, inputStream, progressDialog);
            poseidonProject.postLoad();
            String string = uRL.toExternalForm();
            if ("xmi".equalsIgnoreCase(Strings.getSuffix((String)string))) {
                string = Strings.stripSuffix((String)string) + ".zuml";
                uRL = new URL(string);
            }
            PoseidonProject poseidonProject2 = poseidonProject;
            return poseidonProject2;
        }
        catch (PropertyVetoException propertyVetoException) {
            A.warn("Url for project could not be set: " + uRL.toString());
            throw new IllegalArgumentException("Could not set url for project: " + uRL.toString());
        }
        catch (Exception exception) {
            A.info("problem while loading " + uRL, exception);
            throw new RuntimeException(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    A.info("Could not close inputstream for " + uRL, iOException);
                }
            }
        }
    }

    private void A(UmlProject umlProject, URL uRL, InputStream inputStream, ProgressDialog progressDialog) throws PropertyVetoException {
        Collection collection;
        String string = Utils.getFilenameFromUrl((URL)uRL, (int)-1, (boolean)true, (String)Localizer.localize((ResourceId)CoreResourceBundle.Untitled));
        JBoogieUtils.updateProgressDialog((ProgressDialog)progressDialog, (String)string);
        umlProject.preLoad();
        umlProject.removeModel(0);
        umlProject.setWaitForLoading(true);
        try {
            this.loadXmiFile(inputStream, UmlProject.LOAD_MDR, false, (Project)umlProject, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                inputStream.close();
                inputStream = new BufferedInputStream(uRL.openStream());
                this.loadXmiFile(inputStream, UmlProject.LOAD_NOVOSOFT, false, (Project)umlProject, null);
                collection = umlProject.getPasteHelper();
                collection.convertModelInformation();
                collection.postProcessModelInformation();
            }
            catch (Exception exception) {
                A.error("Loading of xmi file not possible. It is neither xmi 1.0 nor 1.2!");
                throw new IllegalStateException("File is neither xmi 1.0 nor 1.2. Loading failed!");
            }
        }
        ModelClass modelClass = umlProject.getUml1SmFactory().getModelManagementPackage().getModel();
        collection = modelClass.refAllOfClass();
        Model model = (Model)collection.iterator().next();
        umlProject.addModelMember(model);
        umlProject.postLoad();
    }

    public void mergeProjects(PoseidonProject poseidonProject, URL uRL, ProgressDialog progressDialog) {
        Object object;
        try {
            object = (ProjectConverterImpl)ProjectConverter.get();
            if (((ProjectConverterImpl)((Object)object)).isConversionNecessary(uRL)) {
                ((ProjectConverterImpl)((Object)object)).showNeedToOpenMessage(uRL);
                return;
            }
        }
        catch (IOException iOException) {
            A.error("Caught Exception", iOException);
            return;
        }
        A.debug("[ProjectHandler]: merging projects");
        object = uRL.toString();
        int n2 = ((String)object).lastIndexOf(".");
        String string = "";
        if (n2 >= 0) {
            string = ((String)object).substring(n2).toLowerCase();
        }
        if (!(poseidonProject instanceof UmlProject)) {
            throw new IllegalArgumentException("Only uml projects can be merged");
        }
        UmlProject umlProject = (UmlProject)poseidonProject;
        try {
            if (!string.equals(".xmi")) {
                throw new IllegalArgumentException("Wrong type of file for merging: " + (String)object);
            }
            umlProject.preLoad();
            this.A(umlProject, uRL, progressDialog);
            umlProject.postLoad();
        }
        catch (Exception exception) {
            A.warn("Oops, something went wrong in [ProjectHandler.mergeProjects] ", exception);
        }
    }

    private void A(UmlProject umlProject, URL uRL, ProgressDialog progressDialog) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            String string = Utils.getFilenameFromUrl((URL)uRL, (int)-1, (boolean)true, (String)Localizer.localize((ResourceId)CoreResourceBundle.Untitled));
            JBoogieUtils.updateProgressDialog((ProgressDialog)progressDialog, (String)string);
            Model model = (Model)umlProject.getModel(0);
            umlProject.removeModel(0);
            try {
                this.loadXmiFile(bufferedInputStream, UmlProject.LOAD_MDR, false, (Project)umlProject, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    ((InputStream)bufferedInputStream).close();
                    bufferedInputStream = new BufferedInputStream(uRL.openStream());
                    this.loadXmiFile(bufferedInputStream, UmlProject.LOAD_NOVOSOFT, false, (Project)umlProject, null);
                }
                catch (Exception exception) {
                    A.error("Loading of xmi file not possible. It is neither xmi 1.0 nor 1.2!");
                    throw exception;
                }
            }
            umlProject.getPasteHelper().convertModelInformation();
            Map map = umlProject.getPasteHelper().mergeModelsForProject((RefObject)model);
            umlProject.getPasteHelper().mergeDiagramsIntoProject(map);
            Model model2 = (Model)umlProject.getModel(1);
            umlProject.removeModel(1);
            model2.refDelete();
        }
        catch (Exception exception) {
            A.warn("Oops, something went wrong in [UMLProject.loadProject] ", exception);
        }
    }

    public void exportProjectToXmi(String string, OutputStream outputStream, PoseidonProject poseidonProject, boolean bl) {
        D d2 = new D(poseidonProject.getName(), (UmlProject)poseidonProject);
        ProjectMemberReaderWriter projectMemberReaderWriter = (ProjectMemberReaderWriter)JBoogie.getInstance().getProjectMemberManager().getProjectMemberReaderWriters().get(d2.getType());
        if (bl) {
            projectMemberReaderWriter.save((ProjectMember)d2, string, outputStream);
        } else {
            d2.A(string, false, outputStream);
        }
    }

    public ProductVersion loadXmiFile(InputStream inputStream, int n2, boolean bl, Project project, XMIReader xMIReader) {
        UmlProject umlProject = (UmlProject)project;
        XmiLoader xmiLoader = new XmiLoader(umlProject, bl);
        try {
            ProductVersion productVersion = xmiLoader.load(inputStream, umlProject.getMetamodel(), n2, null);
            return productVersion;
        }
        catch (Exception exception) {
            A.info(exception);
            String string = n2 == UmlProject.LOAD_MDR ? "MDR" : "NSUML";
            A.info("File is not " + string + " compliant!");
            throw new IllegalArgumentException("loader incorrect");
        }
    }
}

