/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.ui.documentation.docEditor.kernel;

import com.gentleware.jboogie.kernel.JBoogie;
import com.gentleware.jboogie.kernel.ProjectMemberManager;
import com.gentleware.jboogie.kernel.ProjectMemberReaderWriter;
import com.gentleware.openapi.configuration.Configuration;
import com.gentleware.openapi.jboogie.Command;
import com.gentleware.openapi.jboogie.DiId;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.util.Files;
import com.gentleware.openapi.util.Strings;
import com.gentleware.openapi.util.Utils;
import com.gentleware.poseidon.kernel.PoseidonProjectMemberManager;
import com.gentleware.poseidon.uml.UmlDocumentationManager;
import com.gentleware.poseidon.uml.UmlProject;
import com.realobjects.eop.bean.EditorBean;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jmi.reflect.RefObject;
import org.apache.log4j.Logger;
import org.omg.uml2.diagraminterchange.Diagram;

public class DocEditorUtils {
    private static final Logger A = Logger.getLogger("com.gentleware.poseidon.uml.ui.documentation.docEditor.kernel.DocEditorUtils");
    public static final String INDEX_SEPERATOR = "_";
    public static final Configuration configuration = DocEditorUtils.A().getConfiguration();
    public static String IMAGES_COUNT = "imagesCount";
    private static Pattern C = Pattern.compile("<\\s*img\\s*(?:(?:\\b\\w+\\b\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*'|[^\"'<> ]+)\\s*)?)*)/?\\s*>", 8);
    private static Pattern B = Pattern.compile("(\\b\\w+\\b)\\s*=\\s*(\"[^\"]*\"|'[^']*'|[^\"'<> ]+\\s*)+");

    public static ProjectMemberManager getProjectMemberManager() {
        return JBoogie.getInstance().getProjectMemberManager();
    }

    private static UmlProject A() {
        return (UmlProject)JBoogie.getInstance().getCurrentProject();
    }

    public static void registryProjectMemberForFile(String string) {
        String string2 = string.substring(0, string.indexOf("."));
        String string3 = string.substring(string.indexOf(".") + 1, string.length());
        ProjectMemberReaderWriter projectMemberReaderWriter = (ProjectMemberReaderWriter)DocEditorUtils.getProjectMemberManager().getProjectMemberReaderWriters().get(string3);
        try {
            projectMemberReaderWriter.loadMember(string2, null, (Project)DocEditorUtils.A());
        }
        catch (Exception exception) {
            A.error("Cannot load member Image" + string + " to project");
        }
        DocEditorUtils.A().setNeedsSave(true);
    }

    public static File copyImageAndInsertToEditorBean(Map map, File file, String string, EditorBean editorBean, int n2) {
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        String string3 = string.replaceAll(string2, string2.toLowerCase());
        String string4 = Utils.getProjectCachesDir().toString() + File.separator + "Images" + File.separator + string3;
        File file2 = new File(string4);
        try {
            if (file2.exists()) {
                byte[] byArray = DocEditorUtils.A(file);
                byte[] byArray2 = DocEditorUtils.A(file2);
                if (new String(byArray2).equals(new String(byArray))) {
                    if (map != null) {
                        DocEditorUtils.A(Utils.fileToUrl((File)file2), map, editorBean);
                    }
                    DocEditorUtils.A(string3);
                    return file2;
                }
            } else {
                Files.checkExistenceOrCreateFolder((String)file2.getParent());
                Files.copyFileContent((File)file, (File)file2);
                DocEditorUtils.registryProjectMemberForFile(string3);
                if (map != null) {
                    DocEditorUtils.A(Utils.fileToUrl((File)file2), map, editorBean);
                }
                DocEditorUtils.A(string3);
                return file2;
            }
            String string5 = file.getName();
            String string6 = DocEditorUtils.A(string5.substring(0, string5.length() - 4), n2++);
            DocEditorUtils.copyImageAndInsertToEditorBean(map, file, string6 + string5.substring(string5.length() - 4), editorBean, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static void A(String string) {
        String string2 = configuration.makeKey(IMAGES_COUNT, Strings.replaceAll((String)string, (String)" ", (String)INDEX_SEPERATOR));
        if (!configuration.containsKey(string2)) {
            configuration.putInteger(string2, 1);
        } else {
            int n2 = configuration.getInteger(string2);
            configuration.putInteger(string2, ++n2);
        }
    }

    private static String A(String string, int n2) {
        return string + DocEditorUtils.A(n2);
    }

    private static String A(int n2) {
        return INDEX_SEPERATOR + String.valueOf(n2);
    }

    private static void A(URL uRL, Map map, EditorBean editorBean) {
        String string = Strings.replaceAll((String)uRL.toString(), (String)"%20", (String)" ");
        String string2 = "<img height=\"" + map.get("height") + "\" border=\"" + map.get("border") + "\" width=\"" + map.get("width") + "\" alt=\"" + map.get("alt") + "\" src=\"" + string + "\" ";
        string2 = !map.get("align").equals("") ? string2 + "align =\"" + map.get("align") + "\" />" : string2 + "/>";
        editorBean.insertHTMLData(string2);
    }

    private static byte[] A(File file) throws Exception {
        int n2;
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[1024];
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        do {
            if ((n2 = ((InputStream)fileInputStream).read(byArray)) <= 0) continue;
            messageDigest.update(byArray, 0, n2);
        } while (n2 != -1);
        ((InputStream)fileInputStream).close();
        return messageDigest.digest();
    }

    public static String changeHomePathToTheReal(String string) {
        if (string != null) {
            Matcher matcher = C.matcher(string);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                File file;
                URL uRL;
                String string2 = matcher.group();
                String string3 = Utils.filenameToUri((String)Utils.getProjectCachesDir().toString());
                String string4 = string2.replaceAll("\\{home\\}", string3 = string3.replaceAll("%20", " "));
                if (string4.equals(string2)) {
                    try {
                        uRL = new URL(DocEditorUtils.getURLFromImageTeg(string2));
                        file = Utils.urlToFile((URL)uRL);
                        if (file.exists()) {
                            File file2 = DocEditorUtils.copyImageAndInsertToEditorBean(null, file, file.getName(), null, 0);
                            string4 = string2.replaceAll(uRL.toString(), Utils.fileToUrl((File)file2).toString());
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        A.error("Error can't get URL to Images source !!");
                    }
                    catch (IOException iOException) {
                        A.error("Can't finde or write file !!");
                    }
                } else {
                    try {
                        uRL = new URL(DocEditorUtils.getURLFromImageTeg(string4));
                        file = Utils.urlToFile((URL)uRL);
                        if (!file.exists()) {
                            DocEditorUtils.A(file.getName(), file);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        A.error("Can't convert URL from ImageTeg to File for EditorBean !!!");
                    }
                }
                matcher.appendReplacement(stringBuffer, string4);
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return null;
    }

    public static String getURLFromImageTeg(String string) {
        Matcher matcher = B.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group();
            if (!string2.startsWith("src")) continue;
            String string3 = string2.substring(string2.indexOf("file"), string2.length() - 1);
            return string3;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void A(String string, File file) {
        BufferedInputStream bufferedInputStream = null;
        ProjectMemberManager projectMemberManager = DocEditorUtils.getProjectMemberManager();
        try {
            String string2 = string.substring(0, string.lastIndexOf("."));
            String string3 = string.substring(string.lastIndexOf(".") + 1);
            bufferedInputStream = ((PoseidonProjectMemberManager)projectMemberManager).getMemberContentFromProjectFile(string2, string3);
            if (null == bufferedInputStream) {
                A.error("Error copy image: " + string + " from zipped project file");
            }
            Files.copyToFile((InputStream)bufferedInputStream, (File)file);
        }
        catch (Exception exception) {
            A.error("Cannot unmarshall object from file:", exception);
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                A.error("Some errors occured while accessing file " + string, iOException);
            }
        }
    }

    public static void prepareDocumentationUpdateCommand(UmlProject umlProject, String string, RefObject refObject) {
        A.debug("[DocHtmlEditorComponentPanel.parseText()] toBeSavedText:\n" + string);
        if (string != null && (umlProject.isModelClassInstance(refObject) || refObject instanceof Diagram)) {
            if (refObject instanceof Diagram) {
                UmlDocumentationManager umlDocumentationManager = (UmlDocumentationManager)umlProject.getDocumentationManager();
                String string2 = umlDocumentationManager.getFormattedDocumentation(string);
                Diagram diagram = (Diagram)refObject;
                DiId diId = umlProject.getDiId((RefObject)diagram);
                Command command = umlProject.getDiCommandFactory().makeDiagramDocumentationCommand(diId, string2);
                command.execute();
            } else {
                Command command = umlProject.getUml1SmCommandFactory().makeCommandSetDocumentation(umlProject.getSmId(refObject), string);
                command.execute();
            }
        }
    }

    public static String changeImageSrcPathToFictitious(String string) {
        if (string != null) {
            Matcher matcher = C.matcher(string);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                String string2 = matcher.group();
                String string3 = Utils.filenameToUri((String)Utils.getProjectCachesDir().toString());
                string3 = string3.replaceAll("%20", " ");
                string2 = string2.replaceAll("%20", " ");
                string2 = string2.replaceAll(string3, "{home}");
                matcher.appendReplacement(stringBuffer, string2);
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return null;
    }
}

