/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.ui.documentation.util;

import com.gentleware.poseidon.uml.generator.PreparedModelElement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DocumentationExpander {
    private static final Pattern A = Pattern.compile("(?:[^=|\"|']?)((?:https?\\:\\/\\/|ftps?\\:\\/\\/|mailto\\:)(?:(?:[\\w\\d\\-_\\+\\.]+\\:)?(?:[\\w\\d\\-_\\+\\.]+)?\\@)?(?:[\\w\\d][\\d_\\-\\w\\.]+\\w){2,}?\\.[\\dA-Za-z]{2,7})([\\:\\/]\\S*)?", 32);
    private static final Pattern B = Pattern.compile("\\{@link\\s+([^\\}]*)}", 32);

    public final String expandLinks(String string) {
        Matcher matcher = A.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group(0);
            if (string2.indexOf("href") != 0) continue;
            matcher.appendReplacement(stringBuffer, "<a href=\"" + string2 + "\">" + string2 + "</a>");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public final String expandInlineTags(String string, PreparedModelElement preparedModelElement) {
        String string2 = string;
        Matcher matcher = Pattern.compile(".*\\{\\@link.*", 32).matcher(string);
        if (matcher.matches()) {
            string2 = this.expandLinkTags(string, preparedModelElement);
        }
        return string2;
    }

    public final String expandLinkTags(String string, PreparedModelElement preparedModelElement) {
        Matcher matcher = B.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, this.expandJavaDocNameAndLabel(matcher.group(1), preparedModelElement));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public final String expandJavaDocNameAndLabel(String string, PreparedModelElement preparedModelElement) {
        String[] stringArray = string.split(" ");
        String string2 = stringArray.length > 1 ? stringArray[1] : stringArray[0];
        String string3 = stringArray[0];
        string3 = string3.replaceAll("\\.", "/");
        if ((string3 = string3.replaceAll("#", ".html#")).indexOf("#") < 0) {
            string3 = string3 + ".html";
        }
        String string4 = preparedModelElement != null ? preparedModelElement.getRelativePathToModel(false, false, "/") : "";
        return "<a href=\"" + string4 + string3 + "\">" + string2 + "</a>";
    }

    public static void main(String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string;
            String string2 = string = stringArray[i2];
            DocumentationExpander documentationExpander = new DocumentationExpander();
            System.out.println("Original: " + string2);
            System.out.println("Neu     : " + documentationExpander.expandLinkTags(string2, null));
        }
    }
}

