/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.util;

import com.gentleware.jboogie.kernel.Id;
import com.gentleware.jboogie.kernel.IdMap;
import com.gentleware.openapi.configuration.Configuration;
import com.gentleware.openapi.jboogie.SmId;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.poseidon.kernel.settings.CustomJavaRoundtripSettings;
import com.gentleware.poseidon.uml.UmlProject;
import com.gentleware.poseidon.uml.util.ClassifierHistoryEntry;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.RefObject;
import org.apache.log4j.Logger;
import org.omg.uml.foundation.core.Classifier;

public class ClassifierHistory {
    private static final Logger A = Logger.getLogger("com.gentleware.poseidon.uml.util.ClassifierHistory");
    public static final String CLASSIFIER_HISTORY_KEY_PREFIX = "classifier_history/";
    private Map C;
    private UmlProject B;

    public ClassifierHistory(UmlProject umlProject) {
        this.B = umlProject;
        this.C = CollectionFactory.createHashMap();
    }

    public boolean restoreHistoryFromProjectSettings() {
        Configuration configuration = this.B.getConfiguration();
        return this.restoreHistoryFromProjectSettings(configuration);
    }

    public boolean restoreHistoryFromProjectSettings(Configuration configuration) {
        boolean bl;
        Map map = configuration.getAllEntriesMatching(CLASSIFIER_HISTORY_KEY_PREFIX);
        Set set = map.keySet();
        boolean bl2 = bl = set.size() == 0;
        if (!bl) {
            this.C = this.restoreHistoryFromProject(configuration);
        }
        return !bl;
    }

    public void clear() {
        this.C.clear();
        Configuration configuration = this.B.getConfiguration();
        if (configuration != null) {
            Map map = configuration.getAllEntriesMatching(CLASSIFIER_HISTORY_KEY_PREFIX);
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                configuration.removeKey(string);
            }
        }
    }

    public Map getEntryMap() {
        return this.C;
    }

    public ClassifierHistoryEntry getEntryFor(SmId smId) {
        String string = smId.getXmiId();
        ClassifierHistoryEntry classifierHistoryEntry = this.getEntryFor(string);
        return classifierHistoryEntry;
    }

    public ClassifierHistoryEntry getEntryFor(String string) {
        Object v2 = this.C.get(string);
        ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)v2;
        return classifierHistoryEntry;
    }

    public Collection getElementsChangedSince(long l2) {
        Collection collection = this.A(l2, false);
        return collection;
    }

    public Collection getNamesOfDeletedElements() {
        Collection collection = this.C.values();
        List list = CollectionFactory.createArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)iterator.next();
            boolean bl = classifierHistoryEntry.isDeleted();
            if (!bl) continue;
            String string = classifierHistoryEntry.getFullyQualifiedNameForDeletedElement();
            list.add(string);
        }
        return list;
    }

    public Collection getEntriesOfDeletedElements() {
        Collection collection = this.C.values();
        List list = CollectionFactory.createArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)iterator.next();
            boolean bl = classifierHistoryEntry.isDeleted();
            if (!bl) continue;
            list.add(classifierHistoryEntry);
        }
        return list;
    }

    public Collection getElementsModifiedAfterLastGeneration() {
        Collection collection = this.C.values();
        List list = CollectionFactory.createArrayList();
        IdMap idMap = this.B.getSmIdMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)iterator.next();
            boolean bl = classifierHistoryEntry.isDeleted();
            boolean bl2 = classifierHistoryEntry.isModifiedAfterLastGeneration();
            if (bl || !bl2) continue;
            String string = classifierHistoryEntry.getXmiId();
            Id id = idMap.getIdWithXmiid(string);
            if (id == null) {
                A.error("Classifier history contains element with xmi id= " + string + ". without element.");
                continue;
            }
            list.add(id.getElement());
        }
        return list;
    }

    public Collection getNotGeneratedOuterClassifiers() {
        Collection collection = this.C.values();
        List list = CollectionFactory.createArrayList();
        IdMap idMap = this.B.getSmIdMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)iterator.next();
            boolean bl = classifierHistoryEntry.isDeleted();
            if (bl || classifierHistoryEntry.isGenerated()) continue;
            String string = classifierHistoryEntry.getXmiId();
            Id id = idMap.getIdWithXmiid(string);
            if (id == null) {
                A.error("Classifier history contains element with xmi id= " + string + ". without element.");
                continue;
            }
            Classifier classifier = (Classifier)id.getElement();
            if (classifier.getNamespace() instanceof Classifier) continue;
            list.add(classifier);
        }
        return list;
    }

    public Collection getXmiIdsDeleted() {
        Collection collection = this.C.values();
        List list = CollectionFactory.createArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)iterator.next();
            boolean bl = classifierHistoryEntry.isDeleted();
            if (!bl) continue;
            String string = classifierHistoryEntry.getXmiId();
            list.add(string);
        }
        return list;
    }

    public Collection getSmIdsChangedSince(long l2) {
        Collection collection = this.A(l2, true);
        return collection;
    }

    private Collection A(long l2, boolean bl) {
        if (l2 == (long)CustomJavaRoundtripSettings.NOT_SPECIFIED_TIMESTAMP) {
            Collection collection = this.B.getSmAccessory().getAllClassesAndInterfaces(this.B.getFirstModel());
            if (bl) {
                List list = CollectionFactory.createArrayList();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    RefObject refObject = (RefObject)iterator.next();
                    SmId smId = this.B.getSmId(refObject);
                    list.add(smId);
                }
                return list;
            }
            return collection;
        }
        Collection collection = this.C.values();
        List list = CollectionFactory.createArrayList();
        IdMap idMap = this.B.getSmIdMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)iterator.next();
            long l3 = classifierHistoryEntry.getLastModifiedTimestamp();
            boolean bl2 = classifierHistoryEntry.isDeleted();
            if (l3 <= l2 || bl2) continue;
            String string = classifierHistoryEntry.getXmiId();
            Id id = idMap.getIdWithXmiid(string);
            if (id == null) {
                A.error("Classifier history contains element with xmi id= " + string + ". without element.");
                continue;
            }
            Classifier classifier = (Classifier)id.getElement();
            boolean bl3 = classifier.getNamespace() instanceof Classifier;
            if (bl3) continue;
            if (bl) {
                list.add(id);
                continue;
            }
            list.add(classifier);
        }
        return list;
    }

    public void postImport(List list, List list2) {
        this.A(list, true);
        this.removeEntries(list2);
    }

    public void setSmIdsModifiedNow(Collection collection) {
        this.A(collection, false);
    }

    public void forceAllElementsModifiedAt(long l2) {
        Collection collection = this.C.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)iterator.next();
            classifierHistoryEntry.setLastModifiedTimestamp(l2);
        }
    }

    public void forceAllElementsLastGeneratedAt(long l2) {
        Collection collection = this.C.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)iterator.next();
            classifierHistoryEntry.setLastGeneratedTimestamp(l2);
        }
    }

    public void forceAllElementsModifiedNow() {
        long l2 = System.currentTimeMillis();
        this.forceAllElementsModifiedAt(l2);
    }

    private void A(Collection collection, boolean bl) {
        long l2 = System.currentTimeMillis();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SmId smId = (SmId)iterator.next();
            String string = smId.getXmiId();
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)this.C.get(string);
            if (classifierHistoryEntry != null) {
                if (classifierHistoryEntry.isDeleted() && bl) {
                    classifierHistoryEntry.undoDeletion();
                }
                classifierHistoryEntry.setLastModifiedTimestamp(l2);
                continue;
            }
            Configuration configuration = this.B.getConfiguration();
            ClassifierHistoryEntry classifierHistoryEntry2 = new ClassifierHistoryEntry(configuration, string, l2);
            this.C.put(string, classifierHistoryEntry2);
        }
    }

    public void setGeneratedSmIds(Collection collection) {
        long l2 = System.currentTimeMillis();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SmId smId = (SmId)iterator.next();
            String string = smId.getXmiId();
            ClassifierHistoryEntry classifierHistoryEntry = (ClassifierHistoryEntry)this.C.get(string);
            if (classifierHistoryEntry != null) {
                classifierHistoryEntry.setLastGeneratedTimestamp(l2);
                continue;
            }
            A.error("TRYING TO SET A LASTGENERATION-TIMESTAMP FOR UNKNOWN ELEMENT IN ELEMENTHISTORY! " + smId);
            Configuration configuration = this.B.getConfiguration();
            ClassifierHistoryEntry classifierHistoryEntry2 = new ClassifierHistoryEntry(configuration, string, l2);
            classifierHistoryEntry2.setLastGeneratedTimestamp(l2);
            this.C.put(string, classifierHistoryEntry2);
        }
    }

    public void initializeFromLegacyProject(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SmId smId = (SmId)iterator.next();
            String string = smId.getXmiId();
            Configuration configuration = this.B.getConfiguration();
            ClassifierHistoryEntry classifierHistoryEntry = new ClassifierHistoryEntry(configuration, string, System.currentTimeMillis());
            this.C.put(string, classifierHistoryEntry);
        }
    }

    public void setSmIdsDeleted(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SmId smId = (SmId)iterator.next();
            ClassifierHistoryEntry classifierHistoryEntry = this.getEntryFor(smId);
            Classifier classifier = (Classifier)smId.getElement();
            String string = this.B.getUml1SmAccessory().generateFullyQualifiedJavaName(classifier);
            classifierHistoryEntry.setDeleted();
            classifierHistoryEntry.setFullyQualifiedNameForDeletedElement(string);
        }
    }

    public Map restoreHistoryFromProject(Configuration configuration) {
        Object object;
        String string;
        Map map = CollectionFactory.createHashMap();
        Map map2 = configuration.getAllEntriesMatching(CLASSIFIER_HISTORY_KEY_PREFIX);
        Set set = map2.keySet();
        Set set2 = CollectionFactory.createHashSet();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = string.substring(CLASSIFIER_HISTORY_KEY_PREFIX.length());
            int n2 = ((String)object).indexOf(47);
            Object object2 = n2 > -1 ? ((String)object).substring(0, n2) : object;
            set2.add(object2);
        }
        iterator = set2.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = new ClassifierHistoryEntry(configuration, string);
            map.put(string, object);
        }
        return map;
    }

    public void removeDeletedEntry(String string) {
        ClassifierHistoryEntry classifierHistoryEntry = this.getEntryFor(string);
        if (classifierHistoryEntry != null && classifierHistoryEntry.isDeleted()) {
            this.C.remove(string);
            classifierHistoryEntry.removeFromConfiguration();
        }
    }

    public void removeAllDeletedEntries() {
        Set set = CollectionFactory.createHashSet(this.C.keySet());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.removeDeletedEntry(string);
        }
    }

    public void removeEntries(List list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SmId smId = (SmId)list.get(i2);
            this.C.remove(smId.getXmiId());
        }
    }
}

