/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.util;

import com.gentleware.openapi.configuration.Configuration;
import com.gentleware.poseidon.kernel.settings.CustomJavaRoundtripSettings;
import java.util.Set;

public class ClassifierHistoryEntry {
    public static final String LAST_GENERATED_TIMESTAMP_KEY = "last_generated_timestamp";
    public static final String LAST_MODIFIED_TIMESTAMP_KEY = "last_modified_timestamp";
    public static final String IS_DELETED_KEY = "is_deleted";
    public static final String FULLY_QUALIFIED_NAME_FOR_DELETED_ELEMENT_KEY = "fully_qualified_name";
    private Configuration C;
    private String A;
    private String B;

    public ClassifierHistoryEntry(Configuration configuration, String string) {
        this.C = configuration;
        this.A = string;
        this.B = "classifier_history/" + string + "/";
    }

    public ClassifierHistoryEntry(Configuration configuration, String string, long l2) {
        this(configuration, string);
        this.C.putLong(this.B + LAST_MODIFIED_TIMESTAMP_KEY, l2);
    }

    public void removeFromConfiguration() {
        Set set = this.C.getAllEntriesMatching(this.B).keySet();
        Object object = set.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            this.C.removeKey(string);
        }
        object = this.B.substring(0, this.B.length() - 1);
        this.C.removeKey((String)object);
    }

    public String getXmiId() {
        return this.A;
    }

    public long getLastGeneratedTimestamp() {
        return this.C.getLong(this.B + LAST_GENERATED_TIMESTAMP_KEY, (long)CustomJavaRoundtripSettings.NOT_SPECIFIED_TIMESTAMP);
    }

    public long getLastModifiedTimestamp() {
        return this.C.getLong(this.B + LAST_MODIFIED_TIMESTAMP_KEY, (long)CustomJavaRoundtripSettings.NOT_SPECIFIED_TIMESTAMP);
    }

    public boolean isDeleted() {
        return this.C.getBoolean(this.B + IS_DELETED_KEY, false);
    }

    public void setLastGeneratedTimestamp(long l2) {
        this.C.putLong(this.B + LAST_GENERATED_TIMESTAMP_KEY, l2);
    }

    public void setLastModifiedTimestamp(long l2) {
        if (!this.isDeleted()) {
            this.C.putLong(this.B + LAST_MODIFIED_TIMESTAMP_KEY, l2);
        }
    }

    public void undoDeletion() {
        if (!this.isDeleted()) {
            throw new IllegalStateException("Cannot undo deletetion of non-deleted element");
        }
        this.C.putBoolean(this.B + IS_DELETED_KEY, false);
    }

    public void setDeleted() {
        this.C.putBoolean(this.B + IS_DELETED_KEY, true);
    }

    public String getFullyQualifiedNameForDeletedElement() {
        return this.C.getString(this.B + FULLY_QUALIFIED_NAME_FOR_DELETED_ELEMENT_KEY);
    }

    public void setFullyQualifiedNameForDeletedElement(String string) {
        this.C.putString(this.B + FULLY_QUALIFIED_NAME_FOR_DELETED_ELEMENT_KEY, string);
    }

    public boolean isModifiedAfterLastGeneration() {
        return this.isGenerated() && this.getLastModifiedTimestamp() > this.getLastGeneratedTimestamp();
    }

    public boolean isGenerated() {
        return this.getLastGeneratedTimestamp() != (long)CustomJavaRoundtripSettings.NOT_SPECIFIED_TIMESTAMP;
    }
}

