/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.xml;

import com.gentleware.jboogie.kernel.Id;
import com.gentleware.jboogie.model_management.XmiIdHandler;
import com.gentleware.jboogie.util.SubInputStream;
import com.gentleware.mdr.MdrFacade;
import com.gentleware.mdr.PoseidonXmiHeaderConsumer;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.util.ProductVersion;
import com.gentleware.openapi.util.Strings;
import com.gentleware.poseidon.merging.BadXmiException;
import com.gentleware.poseidon.merging.LoadException;
import com.gentleware.poseidon.uml.UmlProject;
import com.gentleware.poseidon.uml.xml.A.G;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.zip.ZipInputStream;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.TransactionEvent;
import org.netbeans.api.xmi.XMIReader;
import org.netbeans.api.xmi.XMIReaderFactory;
import org.netbeans.api.xmi.XMIReferenceResolver;
import org.netbeans.lib.jmi.xmi.InputConfig;
import org.netbeans.lib.jmi.xmi.XMIHeaderConsumer;
import org.omg.uml.UmlPackage;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmiLoader {
    private static final Logger B = Logger.getLogger("com.gentleware.poseidon.uml.xml.XmiLoader");
    private static final DecimalFormat A = new DecimalFormat("###,###,###,###,##0");
    private static final DecimalFormat E = new DecimalFormat("###,###,###,##0.000 MB");
    private static final DecimalFormat D = new DecimalFormat("###,###,###,##0.000 s");
    private final UmlProject H;
    private boolean C;
    private final boolean G;
    private final MDRChangeListener F = new MDRChangeListener(){

        public void change(MDRChangeEvent mDRChangeEvent) {
            if (mDRChangeEvent instanceof TransactionEvent) {
                TransactionEvent transactionEvent = (TransactionEvent)mDRChangeEvent;
                if (transactionEvent.getType() == 0x110002) {
                    MdrFacade.getInstance().removeRepositoryListener((MDRChangeListener)this);
                    B.info("received transaction end event");
                    XmiLoader.this.C = true;
                    XmiLoader.this.H.setWaitForLoading(false);
                } else if (transactionEvent.getType() == 0x110001) {
                    B.debug("received transaction start event");
                }
            }
        }
    };

    public XmiLoader(UmlProject umlProject) {
        this(umlProject, true);
    }

    public XmiLoader(UmlProject umlProject, boolean bl) {
        this.H = umlProject;
        this.G = bl;
    }

    private void A(double d2) {
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.freeMemory();
        long l3 = runtime.maxMemory();
        long l4 = runtime.totalMemory();
        long l5 = l4 - l2;
        long l6 = l3 - l5;
        B.debug("Loading Time           :" + Strings.leftPad((String)D.format(d2), (int)25));
        B.debug("Free Memory            :" + XmiLoader.A(l2));
        B.debug("Used Memory            :" + XmiLoader.A(l5));
        B.debug("Max. available memory  :" + XmiLoader.A(l6));
    }

    private static String A(long l2) {
        String string = Strings.leftPad((String)A.format(l2), (int)12);
        String string2 = Strings.leftPad((String)E.format((double)l2 / 1048576.0), (int)10);
        return string + " (" + string2 + ')';
    }

    public synchronized ProductVersion load(InputStream inputStream, RefPackage refPackage, int n2, XMIReader xMIReader) throws LoadException {
        B.info("=======================================");
        B.info("== READING MODEL " + inputStream.toString());
        ProductVersion productVersion = this.A(inputStream, refPackage, n2, xMIReader);
        B.info("=======================================");
        B.info("#models in project = " + ((UmlPackage)refPackage).getModelManagement().getModel().refAllOfClass().size());
        if (n2 == UmlProject.LOAD_NOVOSOFT) {
            this.H.setWaitForLoading(false);
        } else {
            try {
                while (!this.C) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return productVersion;
    }

    public ProductVersion load(InputStream inputStream, RefPackage refPackage) throws LoadException {
        ProductVersion productVersion = this.A(inputStream, refPackage, UmlProject.LOAD_MDR, null);
        return productVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProductVersion A(InputStream inputStream, RefPackage refPackage, int n2, XMIReader xMIReader) throws LoadException {
        InputStream inputStream2 = inputStream instanceof ZipInputStream ? new SubInputStream((ZipInputStream)inputStream) : inputStream;
        InputStream inputStream3 = inputStream2;
        long l2 = System.currentTimeMillis();
        try {
            ProductVersion productVersion;
            if (n2 == UmlProject.LOAD_MDR) {
                productVersion = this.A(inputStream3, refPackage, xMIReader);
            } else if (n2 == UmlProject.LOAD_NOVOSOFT) {
                this.A(inputStream3);
                productVersion = ProductVersion.createProductVersion((String)"1.3");
            } else {
                B.error("XMI seems to be generated from an unknown XMIWriter -> skip reading!");
                productVersion = ProductVersion.createProductVersion((String)"1.4.4");
            }
            ProductVersion productVersion2 = productVersion;
            return productVersion2;
        }
        finally {
            long l3 = System.currentTimeMillis();
            double d2 = (double)(l3 - l2) / 1000.0;
            this.A(d2);
        }
    }

    private ProductVersion A(InputStream inputStream, RefPackage refPackage, XMIReader xMIReader) throws LoadException {
        MdrFacade mdrFacade = MdrFacade.getInstance();
        boolean bl = true;
        mdrFacade.beginWriteTransaction();
        try {
            ProductVersion productVersion;
            B.info("Load MDR-compliant XMI.");
            XMIReader xMIReader2 = xMIReader != null ? xMIReader : XMIReaderFactory.getDefault().createXMIReader();
            InputConfig inputConfig = (InputConfig)xMIReader2.getConfiguration();
            XmiIdHandler xmiIdHandler = new XmiIdHandler((Project)this.H, this.G);
            inputConfig.setReferenceResolver((XMIReferenceResolver)xmiIdHandler);
            PoseidonXmiHeaderConsumer poseidonXmiHeaderConsumer = new PoseidonXmiHeaderConsumer();
            inputConfig.setHeaderConsumer((XMIHeaderConsumer)poseidonXmiHeaderConsumer);
            if (this.F != null) {
                mdrFacade.addRepositoryListener(this.F, 0x110002);
            }
            xMIReader2.read(inputStream, null, refPackage);
            bl = false;
            ProductVersion productVersion2 = productVersion = poseidonXmiHeaderConsumer.getProductVersion();
            return productVersion2;
        }
        catch (MalformedXMIException malformedXMIException) {
            String string = malformedXMIException.getMessage();
            B.error("Strange obfuscation bug", malformedXMIException);
            if (string != null) {
                String string2 = "The same value of xmi.idref used second time: ";
                int n2 = string.indexOf("The same value of xmi.idref used second time: ");
                if (n2 > -1) {
                    string = string.substring(n2 + "The same value of xmi.idref used second time: ".length(), string.length() - 2);
                    B.info(">>" + string + "<<");
                    Id id = this.H.getSmIdMap().getIdWithXmiid(string);
                    if (id == null) {
                        id = this.H.getDiIdMap().getIdWithXmiid(string);
                    }
                    B.info("already used id: " + id);
                }
            }
            throw new BadXmiException(malformedXMIException);
        }
        catch (IOException iOException) {
            throw new LoadException((Throwable)iOException);
        }
        finally {
            mdrFacade.endTransaction(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void A(InputStream inputStream) throws LoadException {
        boolean bl = true;
        MdrFacade.getInstance().beginWriteTransaction();
        try {
            B.error("XMI reading uses Novosoft XMIReader!");
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(inputStream.toString());
            G g2 = new G(this.H);
            try {
                g2.A(inputSource);
            }
            finally {
                g2.E();
            }
            bl = false;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new LoadException((Throwable)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new LoadException((Throwable)sAXException);
        }
        finally {
            MdrFacade.getInstance().endTransaction(bl);
        }
    }
}

