/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.handlers;

import java.util.Collection;
import java.util.Iterator;
import org.netbeans.mdr.handlers.FeaturedHandler;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableFeatured;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;
import org.netbeans.mdr.util.TransactionMutex;

public class AttrImmutCollWrapper
implements Collection {
    protected final MdrStorage storage;
    protected FeaturedHandler source;
    protected final String attrName;
    protected final int attrIndex;
    protected final TransactionMutex mutex;
    protected final Collection inner;

    public AttrImmutCollWrapper(MdrStorage storage, FeaturedHandler source, int attrIndex, String attrName) {
        this.storage = storage;
        this.source = source;
        this.attrName = attrName;
        this.attrIndex = attrIndex;
        this.mutex = storage.getRepositoryMutex();
        this.inner = null;
    }

    public AttrImmutCollWrapper(MdrStorage storage, Collection inner) {
        this.storage = storage;
        this.mutex = storage.getRepositoryMutex();
        this.inner = inner;
        this.source = null;
        this.attrName = null;
        this.attrIndex = 0;
    }

    public Collection getInnerCollection() {
        if (this.inner != null) {
            return this.inner;
        }
        try {
            if (this.attrName != null) {
                return (Collection)((StorableFeatured)this.source._getDelegate()).getAttribute(this.attrName);
            }
            return (Collection)((StorableObject)this.source._getDelegate()).getAttribute(this.attrIndex);
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
        }
    }

    protected final void lock(boolean write) {
        this.mutex.enter(write);
    }

    protected final void unlock() {
        this.mutex.leave();
    }

    protected final void unlock(boolean fail) {
        this.mutex.leave(fail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean contains(Object obj) {
        try {
            this.lock(false);
            boolean bl = this.getInnerCollection().contains(obj);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        try {
            this.lock(false);
            AttrImmutIteratorWrapper attrImmutIteratorWrapper = new AttrImmutIteratorWrapper(this.getInnerCollection().iterator());
            return attrImmutIteratorWrapper;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        try {
            this.lock(false);
            int n = this.getInnerCollection().size();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEmpty() {
        try {
            this.lock(false);
            boolean bl = this.getInnerCollection().isEmpty();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsAll(Collection collection) {
        try {
            this.lock(false);
            boolean bl = this.getInnerCollection().containsAll(collection);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object[] toArray(Object[] obj) {
        try {
            this.lock(false);
            Object[] objectArray = this.getInnerCollection().toArray(obj);
            return objectArray;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object[] toArray() {
        try {
            this.lock(false);
            Object[] objectArray = this.getInnerCollection().toArray();
            return objectArray;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Collection)) {
            return false;
        }
        try {
            this.lock(false);
            Iterator it1 = this.iterator();
            Iterator it2 = ((Collection)object).iterator();
            while (it1.hasNext() && it2.hasNext()) {
                Object o1 = it1.next();
                Object o2 = it2.next();
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = !it1.hasNext() && !it2.hasNext();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        this.lock(false);
        try {
            int hashCode = 1;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            }
            int n = hashCode;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    protected class AttrImmutIteratorWrapper
    implements Iterator {
        protected final Iterator innerIterator;

        protected AttrImmutIteratorWrapper(Iterator innerIterator) {
            this.innerIterator = innerIterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean hasNext() {
            try {
                AttrImmutCollWrapper.this.lock(false);
                boolean bl = this.innerIterator.hasNext();
                return bl;
            }
            finally {
                AttrImmutCollWrapper.this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            try {
                AttrImmutCollWrapper.this.lock(false);
                Object e = this.innerIterator.next();
                return e;
            }
            finally {
                AttrImmutCollWrapper.this.unlock();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

