/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import java.io.PrintWriter;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.Btree;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePageSource;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.SearchResult;

public class BigKeyPage
extends BtreePage {
    private int keyLength;

    public void init(Btree btree, byte[] pageId, byte[] pageBuffer, boolean isNew) throws StorageException {
        if (this.initialized) {
            return;
        }
        super.init(btree, pageId, pageBuffer, isNew);
        if (isNew) {
            this.keyLength = 0;
            this.flags = 0;
        } else {
            this.keyLength = this.freeStart;
        }
    }

    public void store() {
        this.freeStart = this.keyLength;
        super.store();
    }

    int numEntries() {
        return 1;
    }

    int keyOffset(int entryNum) {
        return this.headerLength;
    }

    int keyLength(int entryNum) {
        return this.keyLength;
    }

    byte[] getData(int entryNum) throws StorageException {
        byte[] data = new byte[this.dataLength];
        int pageSpace = this.btree.pageSize - this.headerLength;
        if (this.keyLength + this.dataLength < pageSpace) {
            System.arraycopy(this.pageBuffer, this.headerLength + this.keyLength, data, 0, this.dataLength);
        } else {
            SearchResult location = this.getDataLocation();
            System.arraycopy(location.page.pageBuffer, location.entryNum, data, 0, this.dataLength);
            if (location.page != this) {
                this.pageSource.unpinPage(location.page);
            }
        }
        return data;
    }

    private SearchResult getDataLocation() throws StorageException {
        byte[] next;
        int pageSpace = this.btree.pageSize - this.headerLength;
        BtreePage current = this;
        int left = this.keyLength;
        while (left > pageSpace) {
            left -= pageSpace;
            next = current.nextPage;
            if (current != this) {
                this.pageSource.unpinPage(current);
            }
            current = this.pageSource.getPage(next, this.btree);
        }
        if (left + this.dataLength <= pageSpace) {
            return new SearchResult(true, this.headerLength + left, current);
        }
        next = current.nextPage;
        if (current != this) {
            this.pageSource.unpinPage(current);
        }
        current = this.pageSource.getPage(next, this.btree);
        return new SearchResult(true, this.headerLength, current);
    }

    byte[] getKey(int entryNum) throws StorageException {
        byte[] key = new byte[this.keyLength];
        int pageSpace = this.btree.pageSize - this.headerLength;
        if (this.keyLength < pageSpace) {
            System.arraycopy(this.pageBuffer, this.headerLength, key, 0, this.keyLength);
        } else {
            BtreePage page = this;
            int left = this.keyLength;
            while (left > pageSpace) {
                System.arraycopy(page.pageBuffer, this.headerLength, key, this.keyLength - left, pageSpace);
                left -= pageSpace;
                byte[] next = page.nextPage;
                if (page != this) {
                    this.pageSource.unpinPage(page);
                }
                page = this.pageSource.getPage(next, this.btree);
            }
            if (left > 0) {
                System.arraycopy(page.pageBuffer, this.headerLength, key, this.keyLength - left, left);
            }
            if (page != this) {
                this.pageSource.unpinPage(page);
            }
        }
        return key;
    }

    BtreePage.BtreeEntry replace(BtreePage.BtreeEntry entry, int entryNum, SearchResult resultPosition) throws StorageException {
        this.pageSource.dirtyPage(this);
        SearchResult location = this.getDataLocation();
        if (location.page != this) {
            this.pageSource.dirtyPage(location.page);
        }
        System.arraycopy(entry.data, 0, location.page.pageBuffer, location.entryNum, entry.data.length);
        if (location.page != this) {
            this.pageSource.unpinPage(location.page);
        }
        if (resultPosition != null) {
            resultPosition.matched = true;
            resultPosition.skipCount = 0;
            resultPosition.page = this;
            resultPosition.entryNum = entryNum;
        }
        return null;
    }

    BtreePage.BtreeEntry insert(BtreePage.BtreeEntry entry, int entryNum, SearchResult resultPosition) throws StorageException {
        BigKeyPage previous;
        int left;
        BigKeyPage newNext;
        BigKeyPage current;
        int pageSpace = this.btree.pageSize - this.headerLength;
        if (this.keyLength == 0) {
            current = this;
            this.pageSource.dirtyPage(current);
            newNext = null;
        } else {
            BtreePage newPrevious;
            current = this.pageSource.newBigKeyPage(this.btree);
            if (entryNum == 0) {
                newPrevious = this.pageSource.getPage(this.previousPage, this.btree);
                newNext = this;
                this.pageSource.dirtyPage(this);
            } else {
                newNext = null;
                newPrevious = this;
                byte[] next = newPrevious.nextPage;
                while (!this.pageSource.isNoPage(next)) {
                    if (newPrevious != this) {
                        this.pageSource.unpinPage(newPrevious);
                    }
                    newPrevious = this.pageSource.getPage(next, this.btree);
                    next = newPrevious.nextPage;
                }
            }
            this.pageSource.dirtyPage(newPrevious);
            this.linkNewPage(current, newPrevious, newNext);
            this.pageSource.unpinPage(newPrevious);
        }
        if (resultPosition != null) {
            resultPosition.matched = true;
            resultPosition.skipCount = 0;
            resultPosition.page = current;
            resultPosition.entryNum = entryNum;
        }
        current.keyLength = entry.key.length;
        for (left = entry.key.length; left > pageSpace; left -= pageSpace) {
            System.arraycopy(entry.key, entry.key.length - left, current.pageBuffer, this.headerLength, pageSpace);
            previous = current;
            current = this.pageSource.newBigKeyPage(this.btree);
            this.linkNewPage(current, previous, newNext);
            if (previous == this) continue;
            this.pageSource.unpinPage(previous);
        }
        if (left > 0) {
            System.arraycopy(entry.key, entry.key.length - left, current.pageBuffer, this.headerLength, left);
        }
        if (left + this.dataLength > pageSpace) {
            previous = current;
            current = this.pageSource.newBigKeyPage(this.btree);
            this.linkNewPage(current, previous, newNext);
            if (previous != this) {
                this.pageSource.unpinPage(previous);
            }
            left = 0;
        }
        System.arraycopy(entry.data, 0, current.pageBuffer, this.headerLength + left, this.dataLength);
        if (current != this) {
            this.pageSource.unpinPage(current);
        }
        if (newNext != null && newNext != this) {
            this.pageSource.unpinPage(newNext);
        }
        return null;
    }

    private void linkNewPage(BtreePage newPage, BtreePage left, BtreePage right) {
        System.arraycopy(left.pageId, 0, newPage.previousPage, 0, left.pageId.length);
        System.arraycopy(left.nextPage, 0, newPage.nextPage, 0, left.pageId.length);
        System.arraycopy(newPage.pageId, 0, left.nextPage, 0, newPage.pageId.length);
        if (right != null) {
            System.arraycopy(newPage.pageId, 0, right.previousPage, 0, newPage.pageId.length);
        }
    }

    void delete(int first, int last) throws StorageException {
        BtreePage next;
        int pageSpace = this.btree.pageSize - this.headerLength;
        int left = this.keyLength;
        BtreePage current = this;
        BtreePage previous = this.pageSource.getPage(this.previousPage, this.btree);
        this.pageSource.dirtyPage(previous);
        while (left > pageSpace) {
            left -= pageSpace;
            next = this.pageSource.getPage(current.nextPage, this.btree);
            if (current != this) {
                this.pageSource.unpinPage(current);
            }
            current = next;
        }
        if (left + this.dataLength > pageSpace) {
            next = this.pageSource.getPage(current.nextPage, this.btree);
            this.pageSource.unpinPage(current);
            current = next;
        }
        System.arraycopy(current.nextPage, 0, previous.nextPage, 0, current.nextPage.length);
        if (!this.pageSource.isNoPage(current.nextPage)) {
            next = this.pageSource.getPage(current.nextPage, this.btree);
            this.pageSource.dirtyPage(next);
            System.arraycopy(previous.pageId, 0, next.previousPage, 0, previous.pageId.length);
            this.pageSource.unpinPage(next);
        }
        if (previous.isRoot() && this.pageSource.isNoPage(previous.nextPage)) {
            this.btree.unsetHasBigKeys();
        }
        this.pageSource.unpinPage(previous);
        if (current != this) {
            this.pageSource.unpinPage(current);
        }
    }

    byte[] splitEntries(BtreePage leftBP, BtreePage rightBP, BtreePage.BtreeEntry entry, int newEntryNum, SearchResult resultPosition) throws StorageException {
        return null;
    }

    SearchResult searchBigKeys(byte[] key) throws StorageException {
        BigKeyPage current;
        BigKeyPage next = this;
        SearchResult result = null;
        do {
            byte[] currentKey;
            byte compare;
            if ((compare = this.btree.keyInfo.compare(key, currentKey = (current = next).getKey(0), 0, currentKey.length)) == 0) {
                result = new SearchResult(true, 0, current);
                continue;
            }
            if (compare == -1) {
                result = new SearchResult(false, 0, current);
                continue;
            }
            next = current.getNextKeyStart();
            if (current == this) continue;
            this.pageSource.unpinPage(current);
        } while (result == null && next != null);
        if (result == null) {
            result = new SearchResult(false, 1, current);
        }
        return result;
    }

    static void getNext(byte[] key, SearchResult result, boolean testOnly) throws StorageException {
        byte[] currentKey;
        BigKeyPage page;
        Btree btree = result.page.btree;
        if (result.entryNum == -1) {
            page = (BigKeyPage)result.page;
            if (!testOnly) {
                result.entryNum = 0;
            }
        } else {
            page = ((BigKeyPage)result.page).getNextKeyStart();
        }
        if (page == null) {
            result.matched = false;
            result.entryNum = 1;
            return;
        }
        result.matched = key != null ? btree.keyInfo.compare(key, currentKey = page.getKey(0), 0, currentKey.length) == 0 : true;
        if (!testOnly) {
            result.page = page;
        }
    }

    BigKeyPage getNextKeyStart() throws StorageException {
        BigKeyPage currentDataPage = (BigKeyPage)this.getDataLocation().page;
        BigKeyPage next = !this.pageSource.isNoPage(currentDataPage.nextPage) ? (BigKeyPage)this.pageSource.getPage(currentDataPage.nextPage, this.btree) : null;
        if (currentDataPage != this) {
            this.pageSource.unpinPage(currentDataPage);
        }
        return next;
    }

    static void getPrevious(byte[] key, SearchResult result, boolean testOnly) throws StorageException {
        byte[] currentKey;
        Btree btree = result.page.btree;
        BigKeyPage page = ((BigKeyPage)result.page).getPreviousKeyStart();
        if (page == null) {
            if (!testOnly) {
                result.entryNum = -1;
            }
            result.matched = false;
            return;
        }
        result.matched = key != null ? btree.keyInfo.compare(key, currentKey = page.getKey(0), 0, currentKey.length) == 0 : true;
        if (!testOnly) {
            result.page = page;
        }
    }

    BigKeyPage getPreviousKeyStart() throws StorageException {
        int currentLength = 0;
        BtreePage current = this;
        do {
            BtreePage previous = this.pageSource.getPage(current.previousPage, this.btree);
            if (current != this) {
                this.pageSource.unpinPage(current);
            }
            if (!((current = previous) instanceof BigKeyPage)) {
                this.pageSource.unpinPage(current);
                current = null;
                continue;
            }
            currentLength = current.keyLength;
        } while (current != null && currentLength == 0);
        return current;
    }

    static BtreePage makeFirst(BtreePage root, BtreePageSource pageSource) throws StorageException {
        BigKeyPage newPage = pageSource.newBigKeyPage(root.btree);
        System.arraycopy(newPage.pageId, 0, root.nextPage, 0, newPage.pageId.length);
        System.arraycopy(root.pageId, 0, newPage.previousPage, 0, newPage.pageId.length);
        root.btree.setHasBigKeys();
        return newPage;
    }

    void dumpLevel(PrintWriter out) throws StorageException {
        BigKeyPage next;
        BigKeyPage current = this;
        do {
            current.dumpPage(out);
            next = current.getNextKeyStart();
            if (current == this) continue;
            this.pageSource.unpinPage(current);
        } while ((current = next) != null);
    }

    public void dumpPageHeader(PrintWriter out) {
        super.dumpPageHeader(out);
        out.println("Key length: " + this.keyLength + '\n');
    }

    public void dumpPageEntries(PrintWriter out) throws StorageException {
        out.println("\nPage entries:\n\n");
        out.print(this.btree.keyInfo.fromBuffer(this.getKey(0)) + ", ");
        out.println(this.btree.dataInfo.fromBuffer(this.getData(0)));
    }
}

