/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import com.gentleware.mdr.storagemodel.TransactionLogSwitcher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.RuntimeStorageException;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageClient;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.StoragePersistentDataException;
import org.netbeans.mdr.persistence.StorageTransientDataException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.Btree;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.MofidGenerator;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.SinglevaluedBtree;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeDataFile;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeFactory;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeFileSource;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeStorage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPageInputStream;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CounterIndex;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileCache;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileHeader;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.MDRCache;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.MofidIndex;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.NormalBtreeExtent;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.NullTransactionCache;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.TransactionCache;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.TransactionCacheImpl;
import org.netbeans.mdr.util.AbstractCollectionFactory;
import org.netbeans.mdr.util.Logger;

public class BtreeDatabase
implements SinglevaluedIndex,
MDRCache.OverflowHandler {
    static final int PAGE_SIZE_DFLT = 2048;
    static final int FILE_CACHE_SIZE_DFLT = 64;
    static final int MDR_CACHE_SIZE_DFLT = 2048;
    static final int MDR_CACHE_THRESHHOLD_DFLT = 1000;
    private int modificationLevel;
    private String repositoryName;
    private BtreeDataFile dataFile;
    private SinglevaluedIndex indexFile;
    private FileCache fileCache;
    private MDRCache cache;
    private CounterIndex classIndex;
    private boolean classIndexChanged;
    private static String CLASS_INDEX_TYPE = "org.netbeans.mdr.persistence.btreeimpl.btreestorage.CounterIndex";
    private List classes;
    private MofidIndex indexIndex;
    private BtreeStorage myStorage;
    private boolean saveFailed = false;
    private byte[] baoStrmToBytes;
    private ByteArrayOutputStream baoStrm = new ByteArrayOutputStream();
    private DataOutputStream daoStrm = new DataOutputStream(this.baoStrm);
    private TransactionCache transactionCache;
    private boolean nullTransactionCache = false;
    private PropertyChangeListener strategyLogChangerListener = null;
    private PrintStream loggingStream;
    private static final int DFL = 0;
    private static final int IFL = 1;
    private static final int LFL = 2;
    private static MofidGenerator currentlyStreamingMofidGenerator = null;
    private Map mofidMap = null;

    BtreeDatabase(String name, BtreeStorage parent, boolean isNew) throws StorageException {
        this.repositoryName = name;
        this.myStorage = parent;
        this.classes = AbstractCollectionFactory.getCollectionFactory().createArrayList();
        try {
            this.classes.add(Class.forName(CLASS_INDEX_TYPE));
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        this.open(isNew);
    }

    private static String[] getFileNames(String base) {
        String[] names = new String[]{base + ".btd", base + ".btx", base + ".btb"};
        return names;
    }

    static boolean exists(String base) {
        String[] names = BtreeDatabase.getFileNames(base);
        return new File(names[0]).exists() || new File(names[1]).exists() || new File(names[2]).exists();
    }

    static boolean delete(String base) {
        String[] names = BtreeDatabase.getFileNames(base);
        return BtreeDatabase.deleteFile(names[0]) & BtreeDatabase.deleteFile(names[1]) & BtreeDatabase.deleteFile(names[2]);
    }

    private static boolean deleteFile(String name) {
        File file = new File(name);
        if (!file.exists()) {
            return true;
        }
        return file.delete();
    }

    static void rename(String from, String to) throws StorageException {
        File fromLog;
        String[] toNames;
        if (BtreeDatabase.exists(to)) {
            throw new StorageBadRequestException(MessageFormat.format("Btree repository {0} already exists", to));
        }
        String[] fromNames = BtreeDatabase.getFileNames(from);
        boolean success = new File(fromNames[0]).renameTo(new File((toNames = BtreeDatabase.getFileNames(to))[0]));
        if (success) {
            success = new File(fromNames[1]).renameTo(new File(toNames[1]));
        }
        if (success && (fromLog = new File(fromNames[2])).exists()) {
            success = fromLog.renameTo(new File(toNames[0]));
        }
        if (!success) {
            throw new StorageBadRequestException(MessageFormat.format("Unable to rename btree repository {0} to {1}", from, to));
        }
    }

    private int getIntProperty(String propertyName, int defaultValue) {
        String value = this.myStorage.getProperty(propertyName);
        int result = defaultValue;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                Logger.getDefault().log("Error getting value of " + propertyName + " storage property: " + e.getMessage());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(boolean isNew) throws StorageException {
        boolean rebuildIndex = false;
        this.cache = new MDRCache(this.myStorage.mdrCacheSize, this, this.myStorage.mdrCacheThreshold);
        this.transactionCache = this.nullTransactionCache ? new NullTransactionCache() : new TransactionCacheImpl();
        if (this.strategyLogChangerListener == null) {
            this.strategyLogChangerListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (Boolean.FALSE.equals(evt.getNewValue())) {
                        BtreeDatabase.this.nullTransactionCache = false;
                        BtreeDatabase.this.transactionCache = new TransactionCacheImpl();
                    } else {
                        BtreeDatabase.this.nullTransactionCache = true;
                        BtreeDatabase.this.transactionCache = new NullTransactionCache();
                    }
                    System.out.println("Changed indexStrategyLog to " + (BtreeDatabase.this.nullTransactionCache ? "null" : "original"));
                }
            };
            TransactionLogSwitcher.addPropertyChangeListener((PropertyChangeListener)this.strategyLogChangerListener);
        }
        String[] names = BtreeDatabase.getFileNames(this.repositoryName);
        String[] fileNames = new String[]{names[0], names[1]};
        if (isNew) {
            FileHeader hdr = FileHeader.createFiles(new String[]{names[1]}, this.myStorage.pageSize, false);
            BtreeDataFile.create(this.myStorage, names[0], hdr, this.myStorage.pageSize, false);
        } else {
            File dfl = new File(names[0]);
            File ifl = new File(names[1]);
            if (dfl.exists() && !ifl.exists()) {
                FileHeader hdr = null;
                try {
                    RandomAccessFile draf = new RandomAccessFile(dfl, "r");
                    hdr = new FileHeader(draf);
                    draf.close();
                }
                catch (IOException ex) {
                    throw new StorageIOException(ex);
                }
                hdr.addFiles(new String[]{names[1]}, this.myStorage.pageSize, false);
                rebuildIndex = true;
            }
        }
        this.fileCache = new FileCache(this.myStorage.pageSize, this.myStorage.fileCacheSize, fileNames, names[2]);
        boolean failure = true;
        try {
            this.dataFile = new BtreeDataFile(this.myStorage, this.fileCache, 0);
            this.myStorage.gen = this.dataFile;
            BtreeFileSource source = new BtreeFileSource(1, this.fileCache, this.myStorage.pageSize, isNew || rebuildIndex, this.dataFile, this.myStorage);
            this.indexFile = new SinglevaluedBtree(this.repositoryName, Storage.EntryType.MOFID, Storage.EntryType.INT, source);
            if (rebuildIndex) {
                this.rebuildIndexFile();
                this.save(true);
            }
            this.fetchClassIndex();
            if (isNew) {
                this.save(true);
            }
            failure = false;
        }
        finally {
            if (failure) {
                this.fileCache.abort();
            }
        }
    }

    void copy(String target) throws StorageException {
        FileCache copyCache = null;
        if (this.cache.hasChanges()) {
            throw new StorageBadRequestException(MessageFormat.format("There are changes to repository {0} that have not been committed", target));
        }
        if (BtreeDatabase.exists(target)) {
            throw new StorageBadRequestException(MessageFormat.format("Btree repository {0} already exists", target));
        }
        String[] copyNames = BtreeDatabase.getFileNames(target);
        String[] fileNames = new String[]{copyNames[0]};
        BtreeDataFile.create(this.myStorage, copyNames[0], new FileHeader(), this.myStorage.pageSize, false);
        try {
            copyCache = new FileCache(this.myStorage.pageSize, this.myStorage.fileCacheSize, fileNames, copyNames[2]);
            BtreeDataFile copyFile = new BtreeDataFile(this.myStorage, copyCache, 0);
            this.dataFile.copy(copyFile);
            copyCache.commit();
            copyCache.close();
            BtreeDatabase db = new BtreeDatabase(target, this.myStorage, false);
            db.close();
        }
        catch (StorageException ex) {
            if (copyCache != null) {
                copyCache.close();
            }
            BtreeDatabase.delete(target);
            throw ex;
        }
    }

    public synchronized void compress() throws StorageException {
        if (this.cache.hasChanges()) {
            throw new StorageBadRequestException(MessageFormat.format("There are changes to repository {0} that have not been committed", this.repositoryName));
        }
        String tempName = "tmp" + new Random().nextInt();
        this.copy(tempName);
        this.closeFiles();
        BtreeDatabase.delete(this.repositoryName);
        BtreeDatabase.rename(tempName, this.repositoryName);
        this.open(false);
    }

    private void rebuildIndexFile() throws StorageException {
        Iterator iter = this.dataFile.iterator(1);
        while (iter.hasNext()) {
            NormalBtreeExtent ext = (NormalBtreeExtent)iter.next();
            MOFID k = this.myStorage.readMOFIDData(new ByteArrayInputStream(ext.key));
            this.indexFile.add(k, new Integer(ext.myChunkNum));
        }
    }

    public synchronized int size() {
        return this.dataFile.size() + this.cache.numberNew() - this.cache.numberDeleted();
    }

    public String getName() {
        return this.repositoryName;
    }

    public Storage.EntryType getValueType() {
        return Storage.EntryType.STREAMABLE;
    }

    public Storage.EntryType getKeyType() {
        return Storage.EntryType.MOFID;
    }

    synchronized void close() throws StorageException {
        this.closeFiles();
        this.cache = null;
        this.transactionCache = null;
        this.dispose();
    }

    synchronized void closeFiles() throws StorageException {
        ++this.modificationLevel;
        this.fileCache.abort();
        this.fileCache = null;
        this.dataFile = null;
        this.indexFile = null;
    }

    public void cacheThreshholdReached(MDRCache cach, int size) throws StorageException {
        this.saveChanges();
    }

    public synchronized void commitChanges() throws StorageException {
        this.save(false);
        if (this.transactionCache.tresholdReached()) {
            try {
                this.fileCache.commit();
                this.transactionCache.clear();
            }
            catch (StorageException ex) {
                this.saveFailed = true;
                throw ex;
            }
        } else {
            this.transactionCache.commit();
        }
    }

    public synchronized void shutDown() throws StorageException {
        try {
            this.fileCache.commit();
        }
        catch (StorageException ex) {
            this.saveFailed = true;
            throw ex;
        }
    }

    public synchronized void saveChanges() throws StorageException {
        this.save(false);
    }

    private void save(boolean commit) throws StorageException {
        if (this.saveFailed) {
            throw new StorageBadRequestException("A save of this repository has failed previously.  Allowing this commit to proceed would potentially corrupt persistent data.");
        }
        try {
            StorageException writeError;
            Object value;
            MOFID id;
            ++this.modificationLevel;
            this.classIndexChanged = false;
            Iterator delIter = this.cache.getDeleted().iterator();
            while (delIter.hasNext()) {
                id = (MOFID)delIter.next();
                this.removeRecord(id);
                delIter.remove();
                this.transactionCache.addDeleted(id);
            }
            Iterator dirtyIter = this.cache.getDirty().iterator();
            while (dirtyIter.hasNext()) {
                id = (MOFID)dirtyIter.next();
                writeError = this.replaceRecord(id, value = this.cache.get(id));
                if (writeError == null) {
                    dirtyIter.remove();
                    this.transactionCache.addReplaced(id, this.baoStrmToBytes);
                    continue;
                }
                throw writeError;
            }
            Iterator newIter = this.cache.getNew().iterator();
            while (newIter.hasNext()) {
                id = (MOFID)newIter.next();
                writeError = this.addRecord(id, value = this.cache.get(id));
                if (writeError == null) {
                    newIter.remove();
                    this.transactionCache.addInserted(id, this.baoStrmToBytes);
                    continue;
                }
                throw writeError;
            }
            if (this.classIndexChanged) {
                writeError = this.replaceRecord(BtreeFactory.classIndexId, this.classIndex);
                this.transactionCache.addReplaced(BtreeFactory.classIndexId, this.baoStrmToBytes);
                if (writeError != null) {
                    throw writeError;
                }
                this.classIndexChanged = false;
            }
            if (commit) {
                this.fileCache.commit();
                this.transactionCache.clear();
            }
        }
        catch (StorageException ex) {
            this.saveFailed = true;
            throw ex;
        }
    }

    public synchronized void rollbackChanges() throws StorageException {
        ++this.modificationLevel;
        Iterator iter = this.transactionCache.iterator();
        long counter = this.dataFile.getMofIdCounter();
        boolean dataCommited = this.transactionCache.containsCommitedData();
        this.close();
        this.open(false);
        try {
            while (iter.hasNext()) {
                TransactionCacheImpl.Record rec = (TransactionCacheImpl.Record)iter.next();
                switch (rec.op) {
                    case 1: {
                        this.removeRecord(rec.id);
                        break;
                    }
                    case 2: {
                        Integer offset = (Integer)this.indexFile.get(rec.id);
                        int dataOffset = this.dataFile.replace((int)offset, rec.id.getSerialNumber(), rec.value);
                        this.indexFile.replace(rec.id, new Integer(dataOffset));
                        break;
                    }
                    case 0: {
                        int dataOffset = this.dataFile.put(rec.id.getSerialNumber(), rec.value);
                        this.indexFile.add(rec.id, new Integer(dataOffset));
                    }
                }
            }
            this.dataFile.setMofIdCounter(counter);
            this.fileCache.commit();
        }
        catch (StorageException ex) {
            this.saveFailed = true;
            throw ex;
        }
    }

    public synchronized boolean remove(Object key) throws StorageException {
        return this.remove(this.makeMOFID(key));
    }

    public void dispose() {
        TransactionLogSwitcher.removePropertyChangeListener((PropertyChangeListener)this.strategyLogChangerListener);
        this.strategyLogChangerListener = null;
    }

    public synchronized boolean remove(MOFID mKey) throws StorageException {
        ++this.modificationLevel;
        if (!this.exists(mKey)) {
            return false;
        }
        this.cache.remove(mKey);
        return true;
    }

    public synchronized void add(Object key, Object value) throws StorageException {
        this.add(this.makeMOFID(key), value);
    }

    public synchronized void add(MOFID mKey, Object value) throws StorageException {
        ++this.modificationLevel;
        if (this.exists(mKey)) {
            throw new StorageBadRequestException(MessageFormat.format("Record with key {0} already exists", mKey));
        }
        this.addToCache(mKey, value);
    }

    private void addToCache(MOFID key, Object value) throws StorageException {
        this.cache.put(key, value);
        this.cache.setNew(key);
    }

    public synchronized void replace(Object key, Object value) throws StorageException {
        this.replace(this.makeMOFID(key), value);
    }

    public synchronized void replace(MOFID mKey, Object value) throws StorageException {
        ++this.modificationLevel;
        if (!this.exists(mKey)) {
            this.noSuchRecord(mKey);
        }
        this.replaceInCache(mKey, value);
    }

    private void replaceInCache(MOFID key, Object value) throws StorageException {
        boolean isNew = this.cache.isNew(key);
        this.cache.replace(key, value);
        if (isNew) {
            this.cache.setNew(key);
        } else {
            this.cache.setDirty(key);
        }
    }

    public synchronized boolean put(Object key, Object value) throws StorageException {
        ++this.modificationLevel;
        MOFID mKey = this.makeMOFID(key);
        if (!this.exists(mKey)) {
            this.addToCache(mKey, value);
            return false;
        }
        this.replaceInCache(mKey, value);
        return true;
    }

    public synchronized Object getIfExists(Object key) throws StorageException {
        return this.getIfExists(this.makeMOFID(key));
    }

    public synchronized Object getObjectIfExists(Object key, SinglevaluedIndex dummy) throws StorageException {
        return this.getIfExists(key);
    }

    public synchronized Object getIfExists(MOFID mKey) throws StorageException {
        Object retval = this.cache.get(mKey);
        if (retval == null) {
            if (this.cache.isDeleted(mKey)) {
                return null;
            }
            retval = this.getRecord(mKey);
            if (retval != null) {
                this.cache.put(mKey, retval);
            }
        }
        return retval;
    }

    public synchronized Object get(Object key) throws StorageException {
        Object retval = this.getIfExists(key);
        if (retval == null) {
            this.noSuchRecord(key);
        }
        return retval;
    }

    public synchronized Object getObject(Object key, SinglevaluedIndex dummy) throws StorageException {
        return this.get(key);
    }

    public synchronized Object get(MOFID mKey) throws StorageException {
        Object retval = this.getIfExists(mKey);
        if (retval == null) {
            this.noSuchRecord(mKey);
        }
        return retval;
    }

    public synchronized Collection queryByKeyPrefix(Object prefix, SinglevaluedIndex repos) {
        throw new UnsupportedOperationException();
    }

    private boolean exists(MOFID key) throws StorageException {
        if (this.cache.get(key) != null) {
            return true;
        }
        if (this.cache.isDeleted(key)) {
            return false;
        }
        return this.indexFile.getIfExists(key) != null;
    }

    private boolean removeRecord(MOFID mKey) throws StorageException {
        Integer offset = (Integer)this.indexFile.getIfExists(mKey);
        if (offset == null) {
            this.noSuchRecord(mKey);
        }
        this.indexFile.remove(mKey);
        this.dataFile.remove((int)offset, mKey.getSerialNumber());
        return true;
    }

    public synchronized void objectStateChanged(Object key) throws StorageException {
        this.objectStateChanged(this.makeMOFID(key));
    }

    public synchronized void objectStateChanged(MOFID mKey) throws StorageException {
        ++this.modificationLevel;
        this.cache.setDirty(mKey);
    }

    synchronized Object fetchIndex(String name) throws StorageException {
        this.fetchIndexIndex();
        MOFID indexID = this.indexIndex.get(name);
        return indexID == null ? null : this.get(indexID);
    }

    synchronized void dropIndex(String name) throws StorageException {
        ++this.modificationLevel;
        this.fetchIndexIndex();
        MOFID indexId = this.indexIndex.get(name);
        this.indexIndex.remove(name);
        this.objectStateChanged(BtreeFactory.indexIndexId);
        this.remove(indexId);
    }

    public synchronized String[] listIndexes() throws StorageException {
        this.fetchIndexIndex();
        Object[] retval = this.indexIndex.listNames();
        Arrays.sort(retval);
        return retval;
    }

    synchronized void addIndex(String name, Object index, MOFID mID) throws StorageException {
        ++this.modificationLevel;
        this.add(mID, index);
        this.fetchIndexIndex();
        this.indexIndex.add(name, mID);
        this.objectStateChanged(BtreeFactory.indexIndexId);
    }

    static MofidGenerator getCurrentlyStreamingMofidGenerator() {
        return currentlyStreamingMofidGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StorageException writeStreamable(Streamable obj) {
        MofidGenerator previous = currentlyStreamingMofidGenerator;
        currentlyStreamingMofidGenerator = this.dataFile;
        try {
            this.baoStrm.reset();
            this.daoStrm.writeInt(this.getClassCode(obj.getClass()));
            obj.write(this.daoStrm);
            this.baoStrmToBytes = this.baoStrm.toByteArray();
        }
        catch (StorageException ex) {
            StorageException storageException = ex;
            return storageException;
        }
        catch (IOException ioException) {
            StorageException storageException = (StorageException)Logger.getDefault().annotate((Throwable)new StorageIOException(ioException), (Throwable)ioException);
            return storageException;
        }
        catch (RuntimeException th) {
            StorageException storageException = (StorageException)Logger.getDefault().annotate((Throwable)new StorageTransientDataException(th.getClass().getName() + ": " + th.getMessage()), (Throwable)th);
            return storageException;
        }
        finally {
            currentlyStreamingMofidGenerator = previous;
        }
        return null;
    }

    private Streamable readStreamable(DataInputStream stream) throws StorageException {
        Streamable data;
        int classCode;
        try {
            classCode = stream.readInt();
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
        try {
            Class cls = (Class)this.classes.get(classCode);
            data = (Streamable)cls.newInstance();
        }
        catch (Exception ex) {
            throw new StoragePersistentDataException(ex.getMessage());
        }
        if (data instanceof StorageClient) {
            ((StorageClient)((Object)data)).setStorage(this.myStorage);
        }
        data.read(stream);
        return data;
    }

    private StorageException addRecord(MOFID mKey, Object value) throws StorageException {
        StorageException ex = this.writeStreamable((Streamable)value);
        if (ex != null) {
            return ex;
        }
        int dataOffset = this.dataFile.put(mKey.getSerialNumber(), this.baoStrmToBytes);
        this.indexFile.add(mKey, new Integer(dataOffset));
        return null;
    }

    int getClassCode(Class cls) throws StorageException {
        String className = cls.getName();
        this.fetchClassIndex();
        Integer i = this.classIndex.getIf(className);
        if (i != null) {
            return i;
        }
        int code = this.classIndex.add(className);
        this.classes.add(code, cls);
        this.classIndexChanged = true;
        return code;
    }

    private StorageException replaceRecord(MOFID mKey, Object value) throws StorageException {
        StorageException ex = this.writeStreamable((Streamable)value);
        if (ex != null) {
            return ex;
        }
        Integer offset = (Integer)this.indexFile.get(mKey);
        int dataOffset = this.dataFile.replace((int)offset, mKey.getSerialNumber(), this.baoStrmToBytes);
        this.indexFile.replace(mKey, new Integer(dataOffset));
        return null;
    }

    private void noSuchRecord(Object key) throws StorageException {
        throw new StorageBadRequestException(MessageFormat.format("No record exists with key {0}", key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getRecord(MOFID mKey) throws StorageException {
        Streamable data;
        Integer offset = (Integer)this.indexFile.getIfExists(mKey);
        if (offset == null) {
            return null;
        }
        CachedPageInputStream strm = this.dataFile.get((int)offset, mKey.getSerialNumber());
        try {
            DataInputStream inStream = new DataInputStream(strm);
            data = this.readStreamable(inStream);
        }
        finally {
            try {
                ((InputStream)strm).close();
            }
            catch (IOException ex) {
                throw new StorageIOException(ex);
            }
        }
        return data;
    }

    private void fetchIndexIndex() throws StorageException {
        if (this.indexIndex == null) {
            this.indexIndex = (MofidIndex)this.getIfExists(BtreeFactory.indexIndexId);
            if (this.indexIndex == null) {
                this.indexIndex = new MofidIndex(this.myStorage);
                this.add(BtreeFactory.indexIndexId, (Object)this.indexIndex);
            }
            this.indexIndex.setName("Index of secondary Indexes");
        }
    }

    private void fetchClassIndex() throws StorageException {
        if (this.classIndex == null) {
            this.classIndex = (CounterIndex)this.getIfExists(BtreeFactory.classIndexId);
            if (this.classIndex == null) {
                this.classIndex = new CounterIndex();
                this.add(BtreeFactory.classIndexId, (Object)this.classIndex);
                this.classIndex.add(CLASS_INDEX_TYPE);
            } else {
                Iterator itr = this.classIndex.iterator();
                while (itr.hasNext()) {
                    Map.Entry ent = (Map.Entry)itr.next();
                    try {
                        int code = (Integer)ent.getValue();
                        while (this.classes.size() < code + 1) {
                            this.classes.add(null);
                        }
                        this.classes.set(code, Class.forName((String)ent.getKey()));
                    }
                    catch (Exception ex) {
                        throw new StoragePersistentDataException(ex.getMessage());
                    }
                }
            }
            this.classIndex.setName("Index of stored classes");
        }
    }

    public Set keySet() throws StorageException {
        return new Keys();
    }

    public Collection values() throws StorageException {
        return new Values();
    }

    public synchronized void setLoggingStream(PrintStream strm) {
        this.loggingStream = strm;
    }

    public synchronized MofidGenerator getMofidGenerator() {
        return this.dataFile;
    }

    public synchronized Map getMofidMap() {
        if (this.mofidMap == null) {
            this.mofidMap = AbstractCollectionFactory.getCollectionFactory().createHashMap();
            this.mofidMap.put(this.dataFile.getMofidPrefix(), this.dataFile);
        }
        return this.mofidMap;
    }

    public synchronized int checkConsistency(PrintWriter strm) throws StorageException {
        int numErrs = this.dataFile.dump(16, 0, false, strm);
        Iterator recordIter = this.dataFile.iterator(1);
        while (recordIter.hasNext()) {
            NormalBtreeExtent ext = (NormalBtreeExtent)recordIter.next();
            MOFID mKey = this.myStorage.readMOFIDData(new ByteArrayInputStream(ext.key));
            Integer offset = (Integer)this.indexFile.getIfExists(mKey);
            if (offset == null) {
                strm.println("ID " + mKey + " is not in the index file.");
                ++numErrs;
                continue;
            }
            if (offset == ext.myChunkNum) continue;
            strm.println("ID " + mKey + " has differring offsets: " + ext.myChunkNum + " and " + offset);
            ++numErrs;
        }
        Iterator actIter = this.cache.iterateActive();
        while (actIter.hasNext()) {
            MOFID key = (MOFID)actIter.next();
            if (this.cache.isDeleted(key)) {
                if (this.cache.isNew(key)) continue;
                strm.println("ID " + key + " is deleted and active but not new");
                ++numErrs;
                continue;
            }
            if (this.cache.isNew(key)) {
                if (!this.inIndexFile(key)) continue;
                strm.println("ID " + key + " is new but in the index file");
                ++numErrs;
                continue;
            }
            if (this.inIndexFile(key)) continue;
            strm.println("ID " + key + " exists but is not in the index file");
            ++numErrs;
        }
        Iterator delIter = this.cache.iterateDeleted();
        while (delIter.hasNext()) {
            MOFID key = (MOFID)delIter.next();
            if (this.inIndexFile(key)) continue;
            strm.println("ID " + key + " is deleted but not in the index file");
            ++numErrs;
        }
        strm.println("" + (numErrs += ((Btree)((Object)this.indexFile)).consistencyCheck(strm)) + " error(s) detected.");
        strm.println();
        this.cache.showStats(strm);
        strm.println();
        this.fileCache.showStats(strm);
        strm.println();
        strm.flush();
        return numErrs;
    }

    private boolean inIndexFile(MOFID key) throws StorageException {
        return this.indexFile.getIfExists(key) != null;
    }

    private MOFID makeMOFID(Object key) {
        if (key instanceof MOFID) {
            return (MOFID)key;
        }
        throw new IllegalArgumentException("Argument must be of org.netbeans.mdr.persistence.MOFID type");
    }

    class Values
    extends AbstractCollection
    implements Collection {
        Values() {
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        public int size() {
            return BtreeDatabase.this.size();
        }
    }

    class Keys
    extends AbstractSet
    implements Set {
        Keys() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator iterator() {
            BtreeDatabase btreeDatabase = BtreeDatabase.this;
            synchronized (btreeDatabase) {
                return new KeyIterator(false);
            }
        }

        public int size() {
            return BtreeDatabase.this.size();
        }
    }

    class ValueIterator
    implements Iterator {
        private Iterator keyIter;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ValueIterator() {
            BtreeDatabase btreeDatabase = BtreeDatabase.this;
            synchronized (btreeDatabase) {
                this.keyIter = new KeyIterator(true);
            }
        }

        public boolean hasNext() {
            return this.keyIter.hasNext();
        }

        public Object next() {
            MOFID id = (MOFID)this.keyIter.next();
            try {
                return BtreeDatabase.this.get(id);
            }
            catch (StorageException ex) {
                throw new RuntimeStorageException(ex);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported");
        }
    }

    class KeyIterator
    implements Iterator {
        private int iterModLevel;
        private Iterator fileIter;
        private Iterator newIter;
        private MOFID nextKey;

        KeyIterator(boolean internal) {
            this.fileIter = BtreeDatabase.this.dataFile.iterator(2);
            this.newIter = null;
            this.iterModLevel = BtreeDatabase.this.modificationLevel;
            this.getNextKey();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getNextKey() {
            this.nextKey = null;
            BtreeDatabase btreeDatabase = BtreeDatabase.this;
            synchronized (btreeDatabase) {
                this.checkModLevel();
                while (this.fileIter.hasNext()) {
                    MOFID fileKey = (MOFID)this.fileIter.next();
                    if (BtreeDatabase.this.cache.isDeleted(fileKey)) continue;
                    this.nextKey = fileKey;
                    return;
                }
                if (this.newIter == null) {
                    this.newIter = BtreeDatabase.this.cache.iterateNew();
                }
                if (this.newIter.hasNext()) {
                    this.nextKey = (MOFID)this.newIter.next();
                }
            }
        }

        public synchronized boolean hasNext() {
            return this.nextKey != null;
        }

        public synchronized Object next() {
            MOFID current = this.nextKey;
            this.getNextKey();
            return current;
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported");
        }

        private void checkModLevel() {
            if (this.iterModLevel != BtreeDatabase.this.modificationLevel) {
                throw new ConcurrentModificationException("Database had been modified");
            }
        }
    }
}

