/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.ByteArrayInputStream;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BigKeyPage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.Btree;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePageSource;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.EntryTypeInfo;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.MofidGenerator;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeDatabase;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeFactory;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeStorage;

public class BtreeMDRSource
implements BtreePageSource {
    BtreeStorage storage;
    MofidGenerator gen;
    private int pageSize;
    private EntryTypeInfo pageIdInfo;
    private byte[] noPageId;
    private String mofidPrefix;

    public BtreeMDRSource(BtreeStorage storage, int pageSize) throws StorageException {
        this.storage = storage;
        this.pageSize = pageSize;
        this.gen = ((BtreeDatabase)storage.getPrimaryIndex()).getMofidGenerator();
        this.pageIdInfo = EntryTypeInfo.getEntryTypeInfo(Storage.EntryType.MOFID, storage);
        this.noPageId = this.storage.getMOFIDData(BtreeFactory.nullMOFID);
    }

    public BigKeyPage newBigKeyPage(Btree btree) throws StorageException {
        BigKeyPage page = new BigKeyPage();
        this.initNewPage(page, btree);
        return page;
    }

    public BtreePage newPage(Btree btree) throws StorageException {
        BtreePage page = btree.pageFactory();
        this.initNewPage(page, btree);
        return page;
    }

    private void initNewPage(BtreePage page, Btree btree) throws StorageException {
        MOFID pageMOFID = new MOFID(this.storage);
        byte[] mofBytes = this.storage.getMOFIDData(pageMOFID);
        page.init(btree, mofBytes, new byte[this.pageSize], true);
        BtreeDatabase repos = (BtreeDatabase)this.storage.getPrimaryIndex();
        repos.add(pageMOFID, (Object)page);
        repos.objectStateChanged(pageMOFID);
    }

    public BtreePage getPage(byte[] pageId, Btree btree) throws StorageException {
        MOFID mofId = this.storage.readMOFIDData(new ByteArrayInputStream(pageId));
        BtreePage page = (BtreePage)((BtreeDatabase)this.storage.getPrimaryIndex()).get(mofId);
        page.init(btree, pageId, page.pageBuffer, false);
        return page;
    }

    public BtreePage getRootPage(Btree btree) throws StorageException {
        return this.newPage(btree);
    }

    public void unpinPage(BtreePage page) {
    }

    public void unpinPage(BigKeyPage page) {
    }

    public void dirtyPage(BtreePage page) throws StorageException {
        MOFID mofId = this.storage.readMOFIDData(new ByteArrayInputStream(page.pageId));
        ((BtreeDatabase)this.storage.getPrimaryIndex()).objectStateChanged(mofId);
    }

    public EntryTypeInfo getPageIdInfo() {
        return this.pageIdInfo;
    }

    public int getPageIdLength() {
        return 8;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setNoPage(byte[] pageId) {
        System.arraycopy(this.noPageId, 0, pageId, 0, pageId.length);
    }

    public boolean isNoPage(byte[] pageId) {
        for (int i = 0; i < pageId.length; ++i) {
            if (pageId[i] == this.noPageId[i]) continue;
            return false;
        }
        return true;
    }

    public long getNextMofid() {
        return this.gen.getNextMofid();
    }

    public String getMofidPrefix() {
        return this.gen.getMofidPrefix();
    }

    public BtreeStorage getStorage() {
        return this.storage;
    }
}

