/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.StoragePersistentDataException;
import org.netbeans.mdr.persistence.StorageTransientDataException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileHeader;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.IntrusiveList;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.LogFile;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.PageID;
import org.netbeans.mdr.util.AbstractCollectionFactory;

public class FileCache {
    private String[] fileNames;
    private RandomAccessFile[] files;
    private int[] fileSize;
    private FileHeader header;
    private LogFile log;
    private int pageSize;
    private boolean inXact;
    private List pages;
    private Map pageHash;
    private IntrusiveList freePages;
    private Map heldForLog;
    private long newTimeStamp;
    private int hits;
    private int misses;
    private int pagesFlushed;
    private int logFlushes;
    private int extensions;
    private int flushFailure;
    private int commitFailure;
    private List toNotify;

    int checkForForcedFailure(String property, int count) {
        if (count == -1) {
            Integer failCount = Integer.getInteger(property);
            int n = count = failCount == null ? 0 : failCount;
        }
        if (count > 0 && --count == 0) {
            System.exit(1);
        }
        return count;
    }

    private void addPages(int numToAdd) {
        for (int i = 0; i < numToAdd; ++i) {
            CachedPage page = new CachedPage(this.pageSize, this);
            this.pages.add(page);
            this.freePages.addLast(page);
        }
    }

    void holdForLog(CachedPage page) {
        page.heldForLog = true;
        this.heldForLog.put(page.key, page);
    }

    void logWasFlushed() {
        Iterator itr = this.heldForLog.values().iterator();
        while (itr.hasNext()) {
            CachedPage page = (CachedPage)itr.next();
            page.heldForLog = false;
            if (page.pinCount != 0) continue;
            this.freePages.addFirst(page);
        }
        this.heldForLog.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileCache(int pgSize, int numBufs, String[] names, String logName) throws StorageException {
        block13: {
            this.hits = 0;
            this.misses = 0;
            this.pagesFlushed = 0;
            this.logFlushes = 0;
            this.extensions = 0;
            this.flushFailure = -1;
            this.commitFailure = -1;
            boolean failure = true;
            try {
                block14: {
                    try {
                        int i;
                        this.files = new RandomAccessFile[names.length];
                        this.fileSize = new int[names.length];
                        this.fileNames = new String[names.length];
                        System.arraycopy(names, 0, this.fileNames, 0, names.length);
                        for (i = 0; i < this.fileNames.length; ++i) {
                            this.files[i] = new RandomAccessFile(this.fileNames[i], "rw");
                        }
                        FileHeader tmpHeader = new FileHeader(this.files[0]);
                        this.pageSize = pgSize;
                        this.log = new LogFile(this, logName, this.pageSize, this.fileNames.length, tmpHeader.fileId);
                        for (i = 0; i < this.fileNames.length; ++i) {
                            this.fileSize[i] = (int)this.files[i].length();
                            FileHeader hdr = new FileHeader(this.files[i]);
                            if (i == 0) {
                                this.header = hdr;
                                continue;
                            }
                            if (hdr.equals(this.header)) continue;
                            throw new StoragePersistentDataException("Files are not consistent");
                        }
                        this.pages = AbstractCollectionFactory.getCollectionFactory().createArrayList(numBufs);
                        this.pageHash = AbstractCollectionFactory.getCollectionFactory().createHashMap();
                        this.heldForLog = AbstractCollectionFactory.getCollectionFactory().createHashMap();
                        this.freePages = new IntrusiveList();
                        this.addPages(numBufs);
                        failure = false;
                        Object var10_10 = null;
                        if (!failure) break block13;
                        if (this.files == null) break block14;
                    }
                    catch (Throwable throwable) {
                        Object var10_11 = null;
                        if (failure) {
                            if (this.files != null) {
                                for (int i = 0; i < this.files.length; ++i) {
                                    if (this.files[i] == null) continue;
                                    this.files[i].close();
                                }
                            }
                            if (this.log != null) {
                                this.log.close();
                            }
                        }
                        throw throwable;
                    }
                    for (int i = 0; i < this.files.length; ++i) {
                        if (this.files[i] == null) continue;
                        this.files[i].close();
                    }
                }
                if (this.log != null) {
                    this.log.close();
                }
            }
            catch (IOException ex) {
                throw new StorageIOException(ex);
            }
        }
    }

    RandomAccessFile[] getFiles() {
        return this.files;
    }

    public synchronized void abort() throws StorageException {
        this.closeFiles();
    }

    public synchronized void close() throws StorageException {
        this.commit();
        this.closeFiles();
    }

    private void closeFiles() throws StorageException {
        try {
            for (int i = 0; i < this.files.length; ++i) {
                this.files[i].close();
            }
            this.log.close();
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    public synchronized void commit() throws StorageException {
        this.commitFailure = this.checkForForcedFailure("org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileCache.commitFailure", this.commitFailure);
        if (this.toNotify != null) {
            Iterator itr = this.toNotify.iterator();
            while (itr.hasNext()) {
                NotifyOnCommit obj = (NotifyOnCommit)itr.next();
                obj.prepareToCommit();
            }
        }
        if (this.inXact) {
            for (int i = 0; i < this.files.length; ++i) {
                CachedPage first = this.getPage(i, 0);
                this.setWritable(first);
                FileHeader.updateTime(first, this.newTimeStamp);
                first.unpin();
            }
            this.log.flush();
            Iterator itr = this.pages.iterator();
            while (itr.hasNext()) {
                CachedPage page = (CachedPage)itr.next();
                if (!page.isDirty) continue;
                this.flushOne(page);
            }
            this.log.commit();
            this.header.timeStamp = this.newTimeStamp;
            this.inXact = false;
        }
    }

    private void flushOne(CachedPage page) throws StorageException {
        try {
            this.flushFailure = this.checkForForcedFailure("org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileCache.flushFailure", this.flushFailure);
            RandomAccessFile file = this.files[page.key.fileIndex];
            file.seek(page.key.offset);
            file.write(page.contents);
            page.isDirty = false;
            ++this.pagesFlushed;
            if (page.key.offset >= this.fileSize[page.key.fileIndex]) {
                this.fileSize[page.key.fileIndex] = page.key.offset + this.pageSize;
            }
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    public synchronized void unpin(CachedPage[] pages) throws StorageException {
        for (int i = 0; i < pages.length; ++i) {
            this.unpin(pages[i]);
        }
    }

    public synchronized void unpin(CachedPage page) throws StorageException {
        if (page.pinCount <= 0) {
            throw new StorageTransientDataException("Attempt to unpin page which is not pinned");
        }
        if (--page.pinCount == 0 && !page.heldForLog) {
            this.freePages.addFirst(page);
        }
    }

    public synchronized CachedPage[] getPages(int fileidx, int first, int size) throws StorageException {
        CachedPage[] retval = new CachedPage[size];
        for (int i = 0; i < size; ++i) {
            retval[i] = this.getPage(new PageID(fileidx, this.pageSize * (first + i)), false);
        }
        return retval;
    }

    public synchronized CachedPage getPage(int fileidx, int pageNum) throws StorageException {
        return this.getPage(new PageID(fileidx, pageNum * this.pageSize), false);
    }

    synchronized CachedPage getPage(PageID page) throws StorageException {
        return this.getPage(page, false);
    }

    private CachedPage getPage(PageID id, boolean fromCacheOnly) throws StorageException {
        CachedPage page = (CachedPage)this.pageHash.get(id);
        if (page != null) {
            if (page.pinCount++ == 0 && !page.heldForLog) {
                this.freePages.remove(page);
            }
            ++this.hits;
            return page;
        }
        if (fromCacheOnly) {
            return null;
        }
        CachedPage free = (CachedPage)this.freePages.removeLast();
        if (free == null && !this.heldForLog.isEmpty()) {
            this.log.flush();
            ++this.logFlushes;
            free = (CachedPage)this.freePages.removeLast();
        }
        if (free == null) {
            int increment = this.pages.size() + 1 >> 1;
            this.addPages(increment);
            ++this.extensions;
            free = (CachedPage)this.freePages.removeLast();
        }
        if (free.isDirty) {
            this.flushOne(free);
        }
        if (free.key != null) {
            this.pageHash.remove(free.key);
        }
        free.reInit(id);
        this.pageHash.put(id, free);
        if (id.offset >= this.fileSize[id.fileIndex]) {
            Arrays.fill(free.contents, (byte)0);
        } else {
            try {
                this.files[id.fileIndex].seek(id.offset);
                this.files[id.fileIndex].readFully(free.contents);
            }
            catch (IOException ex) {
                throw new StorageIOException(ex);
            }
        }
        free.pinCount = 1;
        ++this.misses;
        return free;
    }

    public synchronized void setWritable(CachedPage page) throws StorageException {
        if (page.isDirty) {
            return;
        }
        if (!this.inXact) {
            this.newTimeStamp = System.currentTimeMillis();
            this.log.begin(this.files, this.header.timeStamp, this.newTimeStamp);
            this.inXact = true;
        }
        this.log.addPageToLog(page);
        page.isDirty = true;
    }

    public synchronized void setWritable(CachedPage[] pages) throws StorageException {
        for (int i = 0; i < pages.length; ++i) {
            this.setWritable(pages[i]);
        }
    }

    public void dumpCache(PrintStream strm) {
        strm.println("Cached files:");
        for (int i = 0; i < this.fileNames.length; ++i) {
            strm.println(Integer.toString(i) + ": " + this.fileNames[i] + " size: " + this.fileSize[i]);
        }
        strm.println("");
        strm.println(Integer.toString(this.pages.size()) + " pages");
        Iterator itr = this.pages.iterator();
        int num = 0;
        while (itr.hasNext()) {
            strm.println(Integer.toString(num++) + ':');
            strm.print(((CachedPage)itr.next()).toString());
        }
    }

    public void showStats(PrintStream strm) {
        this.showStats(new PrintWriter(strm));
    }

    public void showStats(PrintWriter strm) {
        int pinned = 0;
        int dirty = 0;
        int held = 0;
        for (int i = 0; i < this.pages.size(); ++i) {
            CachedPage pg = (CachedPage)this.pages.get(i);
            if (pg.pinCount > 0) {
                ++pinned;
            }
            if (pg.isDirty) {
                ++dirty;
            }
            if (!pg.heldForLog) continue;
            ++held;
        }
        strm.println("Page counts: total = " + this.pages.size() + " pinned = " + pinned + " dirty = " + dirty + " held = " + held);
        strm.println("Cache hits: " + this.hits + " misses: " + this.misses + " hit rate: " + 100.0 * (double)this.hits / (double)(this.hits + this.misses));
        strm.println(this.pagesFlushed + " pages written");
        strm.println("Log file flushed to free pages " + this.logFlushes + " times");
        strm.println("Cache made bigger " + this.extensions + " times");
        strm.flush();
    }

    int getPageSize() {
        return this.pageSize;
    }

    public synchronized void addNotifier(NotifyOnCommit notified) {
        if (this.toNotify == null) {
            this.toNotify = AbstractCollectionFactory.getCollectionFactory().createArrayList();
        }
        this.toNotify.add(notified);
    }

    public static interface NotifyOnCommit {
        public void prepareToCommit() throws StorageException;
    }
}

