/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.ref.ReferenceQueue;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CacheReference;
import org.netbeans.mdr.util.AbstractCollectionFactory;

public class MDRCache {
    private static final String CRITICAL_CACHE_SIZE_DFLT = "0.5";
    private int criticalCacheSize;
    private Map hashOnId = AbstractCollectionFactory.getCollectionFactory().createHashMap();
    private CacheReference[] hardRef;
    private int hardIndex;
    private ReferenceQueue queue;
    private Map newOnes;
    private Map dirty;
    private Map deleted = AbstractCollectionFactory.getCollectionFactory().createHashMap();
    OverflowHandler handler;
    int threshhold;
    int hits;
    int misses;
    int maxSize;

    public MDRCache(int size, OverflowHandler hndlr, int limit) {
        this(size);
        this.handler = hndlr;
        this.threshhold = Integer.getInteger("org.netbeans.mdr.persistence.btreeimpl.btreestorage.MDRCache.threshhold", limit);
        double fraction = Double.parseDouble(System.getProperty("storage.btree.mdr.cache.criticalsize", CRITICAL_CACHE_SIZE_DFLT));
        if (fraction >= 1.0) {
            fraction -= Math.floor(fraction);
        }
        this.criticalCacheSize = Math.round((float)size * (float)fraction);
        System.out.println("Critical cache size: " + this.criticalCacheSize);
    }

    public MDRCache(int size) {
        this.hardRef = new CacheReference[size];
        this.hardIndex = 0;
        this.queue = new ReferenceQueue();
        this.dirty = AbstractCollectionFactory.getCollectionFactory().createHashMap();
        this.newOnes = AbstractCollectionFactory.getCollectionFactory().createHashMap();
    }

    public synchronized boolean hasChanges() {
        return this.dirty.size() + this.newOnes.size() + this.deleted.size() > 0;
    }

    public synchronized void put(Object m, Object o) throws StorageException {
        CacheReference cr = new CacheReference(m, o, this.queue);
        CacheReference oldCr = this.hashOnId.put(m, cr);
        if (oldCr != null) {
            if (oldCr.get() != null && oldCr.get() != o) {
                throw new StorageBadRequestException(MessageFormat.format("Duplicate MOF ID: {0}", m));
            }
            oldCr.clear();
        }
        this.makeHardRef(cr);
        this.checkQueue();
        int curSize = this.hashOnId.size();
        if (curSize > this.maxSize) {
            this.maxSize = curSize;
        }
    }

    public synchronized Object get(Object m) {
        Object o = null;
        CacheReference cr = (CacheReference)this.hashOnId.get(m);
        if (cr != null) {
            o = cr.get();
        }
        if (o != null) {
            this.makeHardRef(cr);
            ++this.hits;
        } else {
            ++this.misses;
        }
        this.checkQueue();
        return o;
    }

    public synchronized void replace(Object m, Object o) throws StorageException {
        this.removeFromCache(m);
        this.put(m, o);
    }

    public synchronized void remove(Object m) {
        if (!this.removeFromCache(m)) {
            this.deleted.put(m, m);
        }
        this.checkQueue();
    }

    private boolean removeFromCache(Object m) {
        CacheReference cr = (CacheReference)this.hashOnId.remove(m);
        if (cr != null) {
            cr.clear();
        }
        boolean wasNew = this.newOnes.remove(m) != null;
        this.dirty.remove(m);
        return wasNew;
    }

    public synchronized void clear() {
        Arrays.fill(this.hardRef, null);
        this.checkQueue();
    }

    private void makeHardRef(CacheReference cr) {
        if (cr.isHard()) {
            int oldIndex = cr.getIndex();
            if (oldIndex < this.hardIndex ? this.hardIndex - oldIndex > this.criticalCacheSize : oldIndex - this.hardIndex < this.criticalCacheSize) {
                CacheReference tmp = this.hardRef[this.hardIndex];
                this.hardRef[this.hardIndex] = this.hardRef[oldIndex];
                this.hardRef[oldIndex] = tmp;
                this.hardRef[this.hardIndex].setIndex(this.hardIndex);
                if (this.hardRef[oldIndex] != null) {
                    this.hardRef[oldIndex].setIndex(oldIndex);
                }
            }
        } else {
            if (this.hardRef[this.hardIndex] != null) {
                this.hardRef[this.hardIndex].weaken();
            }
            cr.harden(this.hardIndex);
            this.hardRef[this.hardIndex] = cr;
        }
        ++this.hardIndex;
        if (this.hardIndex >= this.hardRef.length) {
            this.hardIndex = 0;
        }
    }

    private void checkQueue() {
        CacheReference cr;
        while ((cr = (CacheReference)this.queue.poll()) != null) {
            Object k = cr.getKey();
            if (k != null) continue;
        }
    }

    private void checkThreshhold() throws StorageException {
        int allChanged = this.newOnes.size() + this.dirty.size();
        if (allChanged >= this.threshhold) {
            this.handler.cacheThreshholdReached(this, allChanged);
        }
    }

    private void badKey(Object key) throws StorageException {
        throw new StorageBadRequestException(MessageFormat.format("No object with ID {0}", key));
    }

    public synchronized void setNew(Object key) throws StorageException {
        Object o = this.get(key);
        if (o == null) {
            this.badKey(key);
        }
        this.newOnes.put(key, o);
        if (this.handler != null) {
            this.checkThreshhold();
        }
    }

    public synchronized boolean isNew(Object key) {
        return this.newOnes.get(key) != null;
    }

    public synchronized Iterator iterateActive() {
        return this.hashOnId.keySet().iterator();
    }

    public synchronized Iterator iterateDeleted() {
        return this.deleted.keySet().iterator();
    }

    public synchronized Iterator iterateNew() {
        return this.newOnes.keySet().iterator();
    }

    public int numberNew() {
        return this.newOnes.size();
    }

    public int numberDeleted() {
        return this.deleted.size();
    }

    public synchronized boolean isDeleted(Object key) {
        return this.deleted.get(key) != null;
    }

    public synchronized void setDirty(Object key) throws StorageException {
        Object o = this.get(key);
        if (o == null) {
            this.badKey(key);
        }
        if (this.newOnes.get(key) == null) {
            this.dirty.put(key, o);
            if (this.handler != null) {
                this.checkThreshhold();
            }
        }
    }

    public synchronized Collection getNew() {
        return this.newOnes.keySet();
    }

    public synchronized Collection getDirty() {
        return this.dirty.keySet();
    }

    public synchronized Collection getDeleted() {
        return this.deleted.values();
    }

    public synchronized void clearLists() {
        this.dirty.clear();
        this.newOnes.clear();
        this.deleted.clear();
    }

    public void showStats(PrintStream strm) {
        this.showStats(new PrintWriter(strm));
    }

    public void showStats(PrintWriter strm) {
        strm.println("Cache hits: " + this.hits + " misses: " + this.misses + " hit rate: " + 100.0 * (double)this.hits / (double)(this.hits + this.misses));
        strm.println("Maximum size: " + this.maxSize);
        strm.flush();
    }

    public static interface OverflowHandler {
        public void cacheThreshholdReached(MDRCache var1, int var2) throws StorageException;
    }
}

